/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.io.FileInfo;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseWheelEvent;
import java.io.IOException;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.xml.parsers.ParserConfigurationException;
import loci.formats.FormatTools;
import loci.formats.cache.Cache;
import loci.formats.gui.CacheIndicator;
import loci.formats.gui.XMLWindow;
import loci.plugins.util.BFVirtualStack;
import loci.plugins.util.BrowserOptionsWindow;
import org.xml.sax.SAXException;

public class DataBrowser
extends StackWindow {
    protected static final int MIN_BROWSER_WIDTH = 400;
    protected JSpinner fpsSpin;
    protected Button animate;
    protected Button options;
    protected Button metadata;
    protected boolean anim = false;
    protected boolean allowShow = false;
    protected XMLWindow metaWindow;
    protected BrowserOptionsWindow optionsWindow;
    protected String xml;
    protected Scrollbar zScroll;
    protected Scrollbar cScroll;
    protected Scrollbar tScroll;
    protected Scrollbar[] cSliders;
    protected int[] cLengths;
    protected int[] cIndex;

    public DataBrowser(ImagePlus imp) {
        this(imp, null, null, null, null);
    }

    public DataBrowser(ImagePlus imp, ImageCanvas ic, String[] channels, int[] cLengths) {
        this(imp, ic, channels, cLengths, null);
    }

    public DataBrowser(final ImagePlus imp, ImageCanvas ic, String[] channels, int[] cLengths, XMLWindow xmlWindow) {
        super(imp, ic);
        int blockIncrement;
        Component[] comps;
        if (channels == null || channels.length == 0) {
            channels = new String[]{"Channel"};
        }
        if (cLengths == null || cLengths.length == 0) {
            cLengths = new int[]{imp.getNChannels()};
        }
        this.cLengths = cLengths;
        this.cIndex = new int[cLengths.length];
        this.metaWindow = xmlWindow;
        if (this.metaWindow == null) {
            this.metaWindow = new XMLWindow("OME Metadata - " + this.getTitle());
        }
        while (this.getComponentCount() > 1) {
            this.remove(1);
        }
        Panel controls = new Panel(){

            @Override
            public Dimension getPreferredSize() {
                int minWidth = 400;
                int w = imp.getCanvas().getWidth();
                if (w < minWidth) {
                    w = minWidth;
                }
                int h2 = super.getPreferredSize().height;
                return new Dimension(w, h2);
            }
        };
        String cols = "5dlu, right:pref, 3dlu, pref:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        StringBuilder rows = new StringBuilder("4dlu, pref, 3dlu, pref");
        for (int i = 0; i < channels.length; ++i) {
            rows.append(", 3dlu, pref");
        }
        rows.append(", 6dlu");
        controls.setLayout(new FormLayout(cols, rows.toString()));
        controls.setBackground(Color.white);
        int c = imp.getNChannels();
        int z = imp.getNSlices();
        int t2 = imp.getNFrames();
        boolean hasZ = z > 1;
        boolean hasC = c > 1;
        boolean hasT = t2 > 1;
        for (Component comp : comps = this.getComponents()) {
            if (comp instanceof ImageCanvas) continue;
            this.remove(comp);
        }
        ImageJ ij = IJ.getInstance();
        if (hasC) {
            this.cScroll = new Scrollbar(0, 1, 1, 1, c + 1);
            this.add(this.cScroll);
            if (ij != null) {
                this.cScroll.addKeyListener(ij);
            }
            this.cScroll.addAdjustmentListener(this);
            this.cScroll.setFocusable(false);
            this.cScroll.setUnitIncrement(1);
            this.cScroll.setBlockIncrement(1);
        }
        if (hasZ) {
            this.zScroll = new Scrollbar(0, 1, 1, 1, z + 1);
            this.add(this.zScroll);
            if (ij != null) {
                this.zScroll.addKeyListener(ij);
            }
            this.zScroll.addAdjustmentListener(this);
            this.zScroll.setFocusable(false);
            blockIncrement = Math.max(z / 10, 1);
            this.zScroll.setUnitIncrement(1);
            this.zScroll.setBlockIncrement(blockIncrement);
        }
        if (hasT) {
            this.tScroll = new Scrollbar(0, 1, 1, 1, t2 + 1);
            this.add(this.tScroll);
            if (ij != null) {
                this.tScroll.addKeyListener(ij);
            }
            this.tScroll.addAdjustmentListener(this);
            this.tScroll.setFocusable(false);
            blockIncrement = Math.max(t2 / 10, 1);
            this.tScroll.setUnitIncrement(1);
            this.tScroll.setBlockIncrement(blockIncrement);
        }
        Label zLabel = new Label("Z-depth");
        zLabel.setEnabled(hasZ);
        Label tLabel = new Label("Time");
        tLabel.setEnabled(hasT);
        Label[] cLabels = new Label[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            cLabels[i] = new Label(channels[i]);
            cLabels[i].setEnabled(hasC);
        }
        Scrollbar zSlider = hasZ ? this.zScroll : DataBrowser.makeDummySlider();
        final Scrollbar tSlider = hasT ? this.tScroll : DataBrowser.makeDummySlider();
        this.cSliders = new Scrollbar[channels.length];
        Panel[] cPanels = new Panel[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            if (channels.length == 1) {
                this.cSliders[i] = hasC ? this.cScroll : DataBrowser.makeDummySlider();
            } else if (cLengths[i] == 1) {
                this.cSliders[i] = DataBrowser.makeDummySlider();
            } else {
                this.cSliders[i] = new Scrollbar(0, 1, 1, 1, cLengths[i] + 1);
                this.cSliders[i].addAdjustmentListener(this);
            }
            cPanels[i] = DataBrowser.makeHeavyPanel(this.cSliders[i]);
        }
        Panel zPanel = DataBrowser.makeHeavyPanel(zSlider);
        Panel tPanel = DataBrowser.makeHeavyPanel(tSlider);
        this.fpsSpin = new JSpinner(new SpinnerNumberModel(10, 1, 99, 1));
        this.fpsSpin.setToolTipText("Animation rate in frames per second");
        Label fpsLabel = new Label(" FPS");
        Panel fpsPanel = new Panel();
        fpsPanel.setLayout(new BorderLayout());
        fpsPanel.add((Component)this.fpsSpin, "Center");
        fpsPanel.add((Component)fpsLabel, "East");
        ImageStack stack = imp.getStack();
        if (stack instanceof BFVirtualStack) {
            BFVirtualStack bfvs = (BFVirtualStack)stack;
            Cache cache = bfvs.getCache();
            if (hasZ) {
                CacheIndicator zCache = new CacheIndicator(cache, channels.length, zSlider, 10, 20);
                zPanel.add((Component)zCache, "South");
            }
            if (hasT) {
                CacheIndicator tCache = new CacheIndicator(cache, channels.length + 1, tSlider, 10, 20);
                tPanel.add((Component)tCache, "South");
            }
            for (int i = 0; i < channels.length; ++i) {
                if (cLengths[i] <= 1) continue;
                CacheIndicator cCache = new CacheIndicator(cache, i, this.cSliders[i], 10, 20);
                cPanels[i].add((Component)cCache, "South");
            }
            String[] axes = new String[channels.length + 2];
            System.arraycopy(channels, 0, axes, 0, channels.length);
            axes[channels.length] = "Z";
            axes[channels.length + 1] = "T";
            this.optionsWindow = new BrowserOptionsWindow("Options - " + this.getTitle(), cache, axes);
        }
        this.animate = new Button("Animate");
        this.animate.addActionListener(this);
        this.fpsSpin.setEnabled(hasT);
        fpsLabel.setEnabled(hasT);
        this.animate.setEnabled(hasT);
        this.options = new Button("Options");
        this.options.addActionListener(this);
        this.options.setEnabled(this.optionsWindow != null);
        this.metadata = new Button("Metadata");
        this.metadata.addActionListener(this);
        this.metadata.setEnabled(false);
        CellConstraints cc = new CellConstraints();
        controls.add((Component)zLabel, cc.xy(2, 2));
        controls.add((Component)zPanel, cc.xyw(4, 2, 3));
        controls.add((Component)fpsPanel, cc.xy(8, 2));
        controls.add((Component)tLabel, cc.xy(2, 4));
        controls.add((Component)tPanel, cc.xyw(4, 4, 3));
        controls.add((Component)this.animate, cc.xy(8, 4));
        int row = 6;
        if (channels.length == 1) {
            controls.add((Component)this.options, cc.xy(6, row));
            controls.add((Component)this.metadata, cc.xy(8, row));
            controls.add((Component)cLabels[0], cc.xy(2, row));
            controls.add((Component)cPanels[0], cc.xy(4, row));
        } else {
            controls.add((Component)this.options, cc.xy(8, row));
            controls.add((Component)this.metadata, cc.xy(8, row + 2));
            for (int i = 0; i < channels.length; ++i) {
                int w = i < 2 ? 3 : 5;
                controls.add((Component)cLabels[i], cc.xy(2, row));
                controls.add((Component)cPanels[i], cc.xyw(4, row, w));
                row += 2;
            }
        }
        this.add((Component)controls, "South");
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi.description != null && fi.description.startsWith("<?xml")) {
            this.setXML(fi.description);
        }
        this.allowShow = true;
        this.pack();
        this.setVisible(true);
        if (hasT) {
            new Thread("DataBrowser-Animation"){

                @Override
                public void run() {
                    while (DataBrowser.this.isVisible()) {
                        int ms = 200;
                        if (DataBrowser.this.anim) {
                            int sizeT;
                            int c = imp.getChannel();
                            int z = imp.getSlice();
                            int t2 = imp.getFrame() + 1;
                            if (t2 > (sizeT = tSlider.getMaximum() - 1)) {
                                t2 = 1;
                            }
                            imp.setPosition(c, z, t2);
                            DataBrowser.this.syncSliders();
                            int fps = ((Number)DataBrowser.this.fpsSpin.getValue()).intValue();
                            ms = 1000 / fps;
                        }
                        try {
                            Thread.sleep(ms);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }.start();
        }
    }

    public void setXML(String xml) {
        try {
            this.metaWindow.setXML(xml);
        }
        catch (ParserConfigurationException exc) {
            exc.printStackTrace();
        }
        catch (SAXException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        this.metadata.setEnabled(this.metaWindow.getDocument() != null);
    }

    public void toggleAnimation() {
        this.animate.setLabel(this.anim ? "Animate" : "Stop");
        this.anim = !this.anim;
    }

    public void showOptionsWindow() {
        Rectangle r = this.getBounds();
        Dimension w = this.optionsWindow.getSize();
        int x = Math.max(5, r.x + (r.width - w.width) / 2);
        int y = Math.max(5, r.y + (r.height - w.height) / 2);
        this.optionsWindow.setLocation(x, y);
        this.optionsWindow.setVisible(true);
    }

    public void showMetadataWindow() {
        Rectangle r = this.getBounds();
        Dimension w = this.metaWindow.getSize();
        int x = r.x + (r.width - w.width) / 2;
        int y = r.y + (r.height - w.height) / 2;
        if (x < 5) {
            x = 5;
        }
        if (y < 5) {
            y = 5;
        }
        this.metaWindow.setLocation(x, y);
        this.metaWindow.setVisible(true);
    }

    @Override
    public void pack() {
        if (this.allowShow) {
            super.pack();
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (this.allowShow) {
            super.setVisible(b);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.animate) {
            this.toggleAnimation();
        } else if (src == this.options) {
            this.showOptionsWindow();
        } else if (src == this.metadata) {
            this.showMetadataWindow();
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        super.adjustmentValueChanged(e);
        this.syncPlane();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        super.mouseWheelMoved(event);
        this.syncSliders();
    }

    private void syncPlane() {
        for (int i = 0; i < this.cSliders.length; ++i) {
            this.cIndex[i] = this.cSliders[i].getValue() - 1;
        }
        int c = FormatTools.positionToRaster(this.cLengths, this.cIndex) + 1;
        int z = this.zScroll == null ? 1 : this.zScroll.getValue();
        int t2 = this.tScroll == null ? 1 : this.tScroll.getValue();
        this.setPosition(c, z, t2);
        this.imp.setPosition(c, z, t2);
    }

    private void syncSliders() {
        this.cIndex = FormatTools.rasterToPosition(this.cLengths, this.imp.getChannel() - 1);
        for (int i = 0; i < this.cSliders.length; ++i) {
            this.cSliders[i].setValue(this.cIndex[i] + 1);
        }
        if (this.zScroll != null) {
            this.zScroll.setValue(this.imp.getSlice());
        }
        if (this.tScroll != null) {
            this.tScroll.setValue(this.imp.getFrame());
        }
    }

    protected static Scrollbar makeDummySlider() {
        Scrollbar scrollbar = new Scrollbar(0, 1, 1, 1, 2);
        scrollbar.setFocusable(false);
        scrollbar.setUnitIncrement(1);
        scrollbar.setBlockIncrement(1);
        scrollbar.setEnabled(false);
        return scrollbar;
    }

    protected static Panel makeHeavyPanel(Component c) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add(c, "Center");
        return panel;
    }
}

