/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class RecordedImageProcessor
extends ImageProcessor {
    private ImageProcessor proc;
    private boolean doRecording;
    private List<MethodEntry> methodStack;
    private int channelNumber;
    private ImageProcessor[] otherChannels;

    public RecordedImageProcessor(ImageProcessor proc) {
        this.proc = proc;
        this.methodStack = new ArrayList<MethodEntry>();
        this.doRecording = true;
    }

    public RecordedImageProcessor(ImageProcessor proc, int channelNum, ImageProcessor[] otherChannels) {
        this.proc = proc;
        this.methodStack = new ArrayList<MethodEntry>();
        this.doRecording = true;
        this.channelNumber = channelNum;
        this.otherChannels = otherChannels;
    }

    public void setDoRecording(boolean doRecording) {
        this.doRecording = doRecording;
    }

    public List<MethodEntry> getMethodStack() {
        return this.methodStack;
    }

    public void applyMethodStack(List<MethodEntry> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            MethodEntry m4 = stack.get(i);
            try {
                m4.method.invoke((Object)this.proc, m4.args);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public ImageProcessor getChild() {
        return this.proc;
    }

    @Override
    public void abs() {
        this.record("abs");
        this.proc.abs();
    }

    @Override
    public void add(double value) {
        this.record("add", value, Double.TYPE);
        this.proc.add(value);
    }

    @Override
    public void add(int value) {
        this.record("add", value, Integer.TYPE);
        this.proc.add(value);
    }

    @Override
    public void and(int value) {
        this.record("and", value, Integer.TYPE);
        this.proc.and(value);
    }

    @Override
    public void applyTable(int[] lut) {
        this.record("applyTable", (Object)lut, int[].class);
        this.proc.applyTable(lut);
    }

    @Override
    public void autoThreshold() {
        this.record("autoThreshold");
        this.proc.autoThreshold();
    }

    @Override
    public ImageProcessor convertToByte(boolean doScaling) {
        this.record("convertToByte", doScaling, Boolean.TYPE);
        return this.proc.convertToByte(doScaling);
    }

    @Override
    public ImageProcessor convertToFloat() {
        this.record("convertToFloat");
        return this.proc.convertToFloat();
    }

    @Override
    public ImageProcessor convertToRGB() {
        this.record("convertToRGB");
        return this.proc.convertToRGB();
    }

    @Override
    public ImageProcessor convertToShort(boolean doScaling) {
        this.record("convertToShort", doScaling, Boolean.TYPE);
        return this.proc.convertToShort(doScaling);
    }

    @Override
    public void convolve(float[] kernel, int kernelWidth, int kernelHeight) {
        this.record("convolve", new Object[]{kernel, kernelWidth, kernelHeight}, new Class[]{float[].class, Integer.TYPE, Integer.TYPE});
        this.proc.convolve(kernel, kernelWidth, kernelHeight);
    }

    @Override
    public void convolve3x3(int[] kernel) {
        this.record("convolve3x3", (Object)kernel, int[].class);
        this.proc.convolve3x3(kernel);
    }

    @Override
    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        this.record("copyBits", new Object[]{ip, xloc, yloc, mode}, new Class[]{ImageProcessor.class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.copyBits(ip, xloc, yloc, mode);
    }

    @Override
    public Image createImage() {
        if (this.otherChannels == null) {
            return this.proc.createImage();
        }
        int size = this.proc.getWidth() * this.proc.getHeight();
        int[] rgbPixels = new int[size];
        block6: for (int i = 0; i < this.otherChannels.length + 1; ++i) {
            int q;
            int q2;
            ImageProcessor activeProcessor = null;
            activeProcessor = i == this.channelNumber ? this.proc : (i < this.channelNumber ? this.otherChannels[i] : this.otherChannels[i - 1]);
            IndexColorModel cm = (IndexColorModel)activeProcessor.getColorModel();
            int mapSize = cm.getMapSize();
            int[] reds = new int[mapSize];
            int[] greens = new int[mapSize];
            int[] blues = new int[mapSize];
            byte[] tmp = new byte[mapSize];
            cm.getReds(tmp);
            for (q2 = 0; q2 < mapSize; ++q2) {
                reds[q2] = (tmp[q2] & 0xFF) << 16;
            }
            cm.getGreens(tmp);
            for (q2 = 0; q2 < mapSize; ++q2) {
                greens[q2] = (tmp[q2] & 0xFF) << 8;
            }
            cm.getBlues(tmp);
            for (q2 = 0; q2 < mapSize; ++q2) {
                blues[q2] = tmp[q2] & 0xFF;
            }
            byte[] pixels = new byte[size];
            double min2 = activeProcessor.getMin();
            double max = activeProcessor.getMax();
            double scale = 256.0 / (max - min2 + 1.0);
            if (activeProcessor instanceof ByteProcessor) {
                pixels = (byte[])activeProcessor.getPixels();
            } else if (activeProcessor instanceof ShortProcessor) {
                short[] s2 = (short[])activeProcessor.getPixels();
                for (q = 0; q < size; ++q) {
                    int value = (int)((double)(s2[q] & 0xFFFF) - min2);
                    if (value < 0) {
                        value = 0;
                    }
                    if ((value = (int)((double)value * scale + 0.5)) > 255) {
                        value = 255;
                    }
                    pixels[q] = (byte)value;
                }
            } else if (activeProcessor instanceof FloatProcessor) {
                float[] f = (float[])activeProcessor.getPixels();
                for (q = 0; q < size; ++q) {
                    int ivalue;
                    float value = (float)((double)f[q] - min2);
                    if (value < 0.0f) {
                        value = 0.0f;
                    }
                    if ((ivalue = (int)((double)value * scale)) > 255) {
                        ivalue = 255;
                    }
                    pixels[q] = (byte)ivalue;
                }
            }
            switch (i) {
                case 0: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        rgbPixels[q3] = rgbPixels[q3] & 0xFF00FFFF | reds[pixels[q3] & 0xFF];
                    }
                    continue block6;
                }
                case 1: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        rgbPixels[q3] = rgbPixels[q3] & 0xFFFF00FF | greens[pixels[q3] & 0xFF];
                    }
                    continue block6;
                }
                case 2: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        rgbPixels[q3] = rgbPixels[q3] & 0xFFFFFF00 | blues[pixels[q3] & 0xFF];
                    }
                    continue block6;
                }
                case 3: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        int red = reds[pixels[q3] & 0xFF];
                        int green = greens[pixels[q3] & 0xFF];
                        int blue = blues[pixels[q3] & 0xFF];
                        rgbPixels[q3] = red | green | blue;
                    }
                    continue block6;
                }
                default: {
                    int q3;
                    for (q3 = 0; q3 < size; ++q3) {
                        int pixel = rgbPixels[q3];
                        int red = (pixel & 0xFF0000) + reds[pixels[q3] & 0xFF];
                        int green = (pixel & 0xFF00) + greens[pixels[q3] & 0xFF];
                        int blue = (pixel & 0xFF) + blues[pixels[q3] & 0xFF];
                        if (red > 0xFF0000) {
                            red = 0xFF0000;
                        }
                        if (green > 65280) {
                            green = 65280;
                        }
                        if (blue > 255) {
                            blue = 255;
                        }
                        rgbPixels[q3] = red | green | blue;
                    }
                }
            }
        }
        DirectColorModel rgb = new DirectColorModel(32, 0xFF0000, 65280, 255);
        MemoryImageSource src = new MemoryImageSource(this.proc.getWidth(), this.proc.getHeight(), (ColorModel)rgb, rgbPixels, 0, this.proc.getWidth());
        src.setAnimated(true);
        src.setFullBufferUpdates(true);
        return Toolkit.getDefaultToolkit().createImage(src);
    }

    @Override
    public ImageProcessor createProcessor(int width, int height) {
        this.record("createProcessor", new Object[]{width, height}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.createProcessor(width, height);
    }

    @Override
    public ImageProcessor crop() {
        this.record("crop");
        return this.proc.crop();
    }

    @Override
    public void dilate() {
        this.record("dilate");
        this.proc.dilate();
    }

    @Override
    public void drawDot(int xcenter, int ycenter) {
        this.record("drawDot", new Object[]{xcenter, ycenter}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.drawDot(xcenter, ycenter);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.record("drawLine", new Object[]{x1, y1, x2, y2}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.record("drawOval", new Object[]{x, y, width, height}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.drawOval(x, y, width, height);
    }

    @Override
    public void drawPixel(int x, int y) {
        this.record("drawPixel", new Object[]{x, y}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.drawPixel(x, y);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.record("drawPolygon", p, Polygon.class);
        this.proc.drawPolygon(p);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.record("drawRect", new Object[]{x, y, width, height}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.drawRect(x, y, width, height);
    }

    @Override
    public void drawString(String s2) {
        this.record("drawString", s2, String.class);
        this.proc.drawString(s2);
    }

    @Override
    public void drawString(String s2, int x, int y) {
        this.record("drawString", new Object[]{s2, x, y}, new Class[]{String.class, Integer.TYPE, Integer.TYPE});
        this.proc.drawString(s2, x, y);
    }

    @Override
    public ImageProcessor duplicate() {
        this.record("duplicate");
        return this.proc.duplicate();
    }

    @Override
    public void erode() {
        this.record("erode");
        this.proc.erode();
    }

    @Override
    public void exp() {
        this.record("exp");
        this.proc.exp();
    }

    @Override
    public void fill() {
        this.record("fill");
        this.proc.fill();
    }

    @Override
    public void fill(ImageProcessor mask) {
        this.record("fill", mask, ImageProcessor.class);
        this.proc.fill(mask);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.record("fillOval", new Object[]{x, y, width, height}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.record("fillPolygon", p, Polygon.class);
        this.proc.fillPolygon(p);
    }

    @Override
    public void filter(int type) {
        this.record("filter", type, Integer.TYPE);
        this.proc.filter(type);
    }

    @Override
    public void findEdges() {
        this.record("findEdges");
        this.proc.findEdges();
    }

    @Override
    public void flipHorizontal() {
        this.record("flipHorizontal");
        this.proc.flipHorizontal();
    }

    @Override
    public void flipVertical() {
        this.record("flipVertical");
        this.proc.flipVertical();
    }

    @Override
    public void gamma(double value) {
        this.record("gamma", value, Double.TYPE);
        this.proc.gamma(value);
    }

    @Override
    public int get(int index) {
        this.record("get", index, Integer.TYPE);
        return this.proc.get(index);
    }

    @Override
    public int get(int x, int y) {
        this.record("get", new Object[]{x, y}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.get(x, y);
    }

    @Override
    public int getAutoThreshold() {
        this.record("getAutoThreshold");
        return this.proc.getAutoThreshold();
    }

    @Override
    public double getBackgroundValue() {
        this.record("getBackgroundValue");
        return this.proc.getBackgroundValue();
    }

    @Override
    public double getForegroundValue() {
        this.record("getForegroundValue");
        return this.proc.getForegroundValue();
    }

    @Override
    public int getAutoThreshold(int[] histogram) {
        this.record("getAutoThreshold", (Object)histogram, int[].class);
        return this.proc.getAutoThreshold(histogram);
    }

    @Override
    public int getBestIndex(Color c) {
        this.record("getBestIndex", c, Color.class);
        return this.proc.getBestIndex(c);
    }

    @Override
    public BufferedImage getBufferedImage() {
        this.record("getBufferedImage");
        return this.proc.getBufferedImage();
    }

    @Override
    public float[] getCalibrationTable() {
        this.record("getCalibrationTable");
        return this.proc.getCalibrationTable();
    }

    @Override
    public ColorModel getColorModel() {
        this.record("getColorModel");
        return this.proc.getColorModel();
    }

    @Override
    public void getColumn(int x, int y, int[] data, int length) {
        this.record("getColumn", new Object[]{x, y, data, length}, new Class[]{Integer.TYPE, Integer.TYPE, int[].class, Integer.TYPE});
        this.proc.getColumn(x, y, data, length);
    }

    @Override
    public ColorModel getCurrentColorModel() {
        this.record("getCurrentColorModel");
        return this.proc.getCurrentColorModel();
    }

    @Override
    public IndexColorModel getDefaultColorModel() {
        this.record("getDefaultColorModel");
        return this.proc.getDefaultColorModel();
    }

    @Override
    public float getf(int index) {
        this.record("getf", index, Integer.TYPE);
        return this.proc.getf(index);
    }

    @Override
    public float getf(int x, int y) {
        this.record("getf", new Object[]{x, y}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.getf(x, y);
    }

    @Override
    public float[][] getFloatArray() {
        this.record("getFloatArray");
        return this.proc.getFloatArray();
    }

    @Override
    public FontMetrics getFontMetrics() {
        this.record("getFontMetrics");
        return this.proc.getFontMetrics();
    }

    @Override
    public int getHeight() {
        this.record("getHeight");
        return this.proc.getHeight();
    }

    @Override
    public int[] getHistogram() {
        this.record("getHistogram");
        return this.proc.getHistogram();
    }

    @Override
    public double getHistogramMax() {
        this.record("getHistogramMax");
        return this.proc.getHistogramMax();
    }

    @Override
    public double getHistogramMin() {
        this.record("getHistogramMin");
        return this.proc.getHistogramMin();
    }

    @Override
    public int getHistogramSize() {
        this.record("getHistogramSize");
        return this.proc.getHistogramSize();
    }

    @Override
    public int[][] getIntArray() {
        this.record("getIntArray");
        return this.proc.getIntArray();
    }

    @Override
    public boolean getInterpolate() {
        this.record("getInterpolate");
        return this.proc.getInterpolate();
    }

    @Override
    public double getInterpolatedPixel(double x, double y) {
        this.record("getInterpolatedPixel", new Object[]{x, y}, new Class[]{Double.TYPE, Double.TYPE});
        return this.proc.getInterpolatedPixel(x, y);
    }

    @Override
    public double[] getLine(double x1, double y1, double x2, double y2) {
        this.record("getLine", new Object[]{x1, y1, x2, y2}, new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        return this.proc.getLine(x1, y1, x2, y2);
    }

    @Override
    public int getLutUpdateMode() {
        this.record("getLutUpdateMode");
        return this.proc.getLutUpdateMode();
    }

    @Override
    public ImageProcessor getMask() {
        this.record("getMask");
        return this.proc.getMask();
    }

    @Override
    public byte[] getMaskArray() {
        this.record("getMaskArray");
        return this.proc.getMaskArray();
    }

    @Override
    public double getMax() {
        this.record("getMax");
        return this.proc.getMax();
    }

    @Override
    public double getMaxThreshold() {
        this.record("getMaxThreshold");
        return this.proc.getMaxThreshold();
    }

    @Override
    public double getMin() {
        this.record("getMin");
        return this.proc.getMin();
    }

    @Override
    public double getMinThreshold() {
        this.record("getMinThreshold");
        return this.proc.getMinThreshold();
    }

    @Override
    public int getNChannels() {
        this.record("getNChannels");
        return this.proc.getNChannels();
    }

    @Override
    public int getPixel(int x, int y) {
        this.record("getPixel", new Object[]{x, y}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.getPixel(x, y);
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray) {
        this.record("getPixel", new Object[]{x, y, iArray}, new Class[]{Integer.TYPE, Integer.TYPE, int[].class});
        return this.proc.getPixel(x, y, iArray);
    }

    @Override
    public int getPixelInterpolated(double x, double y) {
        this.record("getPixelInterpolated", new Object[]{x, y}, new Class[]{Double.TYPE, Double.TYPE});
        return this.proc.getPixelInterpolated(x, y);
    }

    @Override
    public int getPixelCount() {
        this.record("getPixelCount");
        return this.proc.getPixelCount();
    }

    @Override
    public Object getPixels() {
        this.record("getPixels");
        return this.proc.getPixels();
    }

    @Override
    public Object getPixelsCopy() {
        this.record("getPixelsCopy");
        return this.proc.getPixelsCopy();
    }

    @Override
    public float getPixelValue(int x, int y) {
        this.record("getPixelValue", new Object[]{x, y}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.getPixelValue(x, y);
    }

    @Override
    public Rectangle getRoi() {
        this.record("getRoi");
        return this.proc.getRoi();
    }

    @Override
    public void getRow(int x, int y, int[] data, int length) {
        this.record("getRow", new Object[]{x, y, data, length}, new Class[]{Integer.TYPE, Integer.TYPE, int[].class, Integer.TYPE});
        this.proc.getRow(x, y, data, length);
    }

    @Override
    public Object getSnapshotPixels() {
        this.record("getSnapshotPixels");
        return this.proc.getSnapshotPixels();
    }

    @Override
    public int getStringWidth(String s2) {
        this.record("getStringWidth", s2, String.class);
        return this.proc.getStringWidth(s2);
    }

    @Override
    public int getWidth() {
        this.record("getWidth");
        return this.proc.getWidth();
    }

    @Override
    public void insert(ImageProcessor ip, int xloc, int yloc) {
        this.record("insert", new Object[]{ip, xloc, yloc}, new Class[]{ImageProcessor.class, Integer.TYPE, Integer.TYPE});
        this.proc.insert(ip, xloc, yloc);
    }

    @Override
    public void invert() {
        this.record("invert");
        this.proc.invert();
    }

    @Override
    public void invertLut() {
        this.record("invertLut");
        this.proc.invertLut();
    }

    @Override
    public boolean isColorLut() {
        this.record("isColorLut");
        return this.proc.isColorLut();
    }

    @Override
    public boolean isInvertedLut() {
        this.record("isInvertedLut");
        return this.proc.isInvertedLut();
    }

    @Override
    public boolean isPseudoColorLut() {
        this.record("isPseudoColorLut");
        return this.proc.isPseudoColorLut();
    }

    @Override
    public void lineTo(int x2, int y2) {
        this.record("lineTo", new Object[]{x2, y2}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.lineTo(x2, y2);
    }

    @Override
    public void log() {
        this.record("log");
        this.proc.log();
    }

    @Override
    public void max(double value) {
        this.record("max", value, Double.TYPE);
        this.proc.max(value);
    }

    @Override
    public double maxValue() {
        this.record("maxValue");
        return this.proc.maxValue();
    }

    @Override
    public void medianFilter() {
        this.record("medianFilter");
        this.proc.medianFilter();
    }

    @Override
    public void min(double value) {
        this.record("min", value, Double.TYPE);
        this.proc.min(value);
    }

    @Override
    public double minValue() {
        this.record("minValue");
        return this.proc.minValue();
    }

    @Override
    public void moveTo(int x, int y) {
        this.record("moveTo", new Object[]{x, y}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.moveTo(x, y);
    }

    @Override
    public void multiply(double value) {
        this.record("multiply", value, Double.TYPE);
        this.proc.multiply(value);
    }

    @Override
    public void noise(double range) {
        this.record("noise", range, Double.TYPE);
        this.proc.noise(range);
    }

    @Override
    public void or(int value) {
        this.record("or", value, Integer.TYPE);
        this.proc.or(value);
    }

    @Override
    public void putColumn(int x, int y, int[] data, int length) {
        this.record("putColumn", new Object[]{x, y, data, length}, new Class[]{Integer.TYPE, Integer.TYPE, int[].class, Integer.TYPE});
        this.proc.putColumn(x, y, data, length);
    }

    @Override
    public void putPixel(int x, int y, int value) {
        this.record("putPixel", new Object[]{x, y, value}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.putPixel(x, y, value);
    }

    @Override
    public void putPixel(int x, int y, int[] iArray) {
        this.record("putPixel", new Object[]{x, y, iArray}, new Class[]{Integer.TYPE, Integer.TYPE, int[].class});
        this.proc.putPixel(x, y, iArray);
    }

    @Override
    public void putPixelValue(int x, int y, double value) {
        this.record("putPixelValue", new Object[]{x, y, value}, new Class[]{Integer.TYPE, Integer.TYPE, Double.TYPE});
        this.proc.putPixelValue(x, y, value);
    }

    @Override
    public void putRow(int x, int y, int[] data, int length) {
        this.record("putRow", new Object[]{x, y, data, length}, new Class[]{Integer.TYPE, Integer.TYPE, int[].class, Integer.TYPE});
        this.proc.putRow(x, y, data, length);
    }

    @Override
    public void reset() {
        this.record("reset");
        this.proc.reset();
    }

    @Override
    public void reset(ImageProcessor mask) {
        this.record("reset", mask, ImageProcessor.class);
        this.proc.reset(mask);
    }

    @Override
    public void resetBinaryThreshold() {
        this.record("resetBinaryThreshold");
        this.proc.resetBinaryThreshold();
    }

    @Override
    public void resetMinAndMax() {
        this.record("resetMinAndMax");
        this.proc.resetMinAndMax();
    }

    @Override
    public void resetRoi() {
        this.record("resetRoi");
        this.proc.resetRoi();
    }

    @Override
    public void resetThreshold() {
        this.record("resetThreshold");
        this.proc.resetThreshold();
    }

    @Override
    public ImageProcessor resize(int dstWidth) {
        this.record("resize", dstWidth, Integer.TYPE);
        return this.proc.resize(dstWidth);
    }

    @Override
    public ImageProcessor resize(int dstWidth, int dstHeight) {
        this.record("resize", new Object[]{dstWidth, dstHeight}, new Class[]{Integer.TYPE, Integer.TYPE});
        return this.proc.resize(dstWidth, dstHeight);
    }

    @Override
    public void rotate(double angle) {
        this.record("rotate", angle, Double.TYPE);
        this.proc.rotate(angle);
    }

    @Override
    public ImageProcessor rotateLeft() {
        this.record("rotateLeft");
        return this.proc.rotateLeft();
    }

    @Override
    public ImageProcessor rotateRight() {
        this.record("rotateRight");
        return this.proc.rotateRight();
    }

    @Override
    public void scale(double xScale, double yScale) {
        this.record("scale", new Object[]{xScale, yScale}, new Class[]{Double.TYPE, Double.TYPE});
        this.proc.scale(xScale, yScale);
    }

    @Override
    public void set(int index, int value) {
        this.record("set", new Object[]{index, value}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.set(index, value);
    }

    @Override
    public void set(int x, int y, int value) {
        this.record("set", new Object[]{x, y, value}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.set(x, y, value);
    }

    @Override
    public void setAntialiasedText(boolean antialiased) {
        this.record("setAntialiasedText", antialiased, Boolean.TYPE);
        this.proc.setAntialiasedText(antialiased);
    }

    @Override
    public void setAutoThreshold(int method, int lutUpdate) {
        this.record("setAutoThreshold", new Object[]{method, lutUpdate}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.setAutoThreshold(method, lutUpdate);
    }

    @Override
    public void setBackgroundValue(double value) {
        this.record("setBackgroundValue", value, Double.TYPE);
        this.proc.setBackgroundValue(value);
    }

    @Override
    public void setCalibrationTable(float[] ctable) {
        this.record("setCalibrationTable", (Object)ctable, float[].class);
        this.proc.setCalibrationTable(ctable);
    }

    @Override
    public void setClipRect(Rectangle clipRect) {
        this.record("setClipRect", clipRect, Rectangle.class);
        this.proc.setClipRect(clipRect);
    }

    @Override
    public void setColor(Color color) {
        this.record("setColor", color, Color.class);
        this.proc.setColor(color);
    }

    @Override
    public void setColor(int value) {
        this.record("setColor", value, Integer.TYPE);
        this.proc.setColor(value);
    }

    @Override
    public void setColorModel(ColorModel cm) {
        this.record("setColorModel", cm, ColorModel.class);
        this.proc.setColorModel(cm);
    }

    @Override
    public void setf(int index, float value) {
        this.record("setf", new Object[]{index, Float.valueOf(value)}, new Class[]{Integer.TYPE, Float.TYPE});
        this.proc.setf(index, value);
    }

    @Override
    public void setf(int x, int y, float value) {
        this.record("setf", new Object[]{x, y, Float.valueOf(value)}, new Class[]{Integer.TYPE, Integer.TYPE, Float.TYPE});
        this.proc.setf(x, y, value);
    }

    @Override
    public void setFloatArray(float[][] a) {
        this.record("setFloatArray", a, float[][].class);
        this.proc.setFloatArray(a);
    }

    @Override
    public void setFont(Font font) {
        this.record("setFont", font, Font.class);
        this.proc.setFont(font);
    }

    @Override
    public void setHistogramRange(double histMin, double histMax) {
        this.record("setHistogramRange", new Object[]{histMin, histMax}, new Class[]{Double.TYPE, Double.TYPE});
        this.proc.setHistogramRange(histMin, histMax);
    }

    @Override
    public void setHistogramSize(int size) {
        this.record("setHistogramSize", size, Integer.TYPE);
        this.proc.setHistogramSize(size);
    }

    @Override
    public void setIntArray(int[][] a) {
        this.record("setIntArray", a, int[][].class);
        this.proc.setIntArray(a);
    }

    @Override
    public void setInterpolate(boolean interpolate) {
        this.record("setInterpolate", interpolate, Boolean.TYPE);
        this.proc.setInterpolate(interpolate);
    }

    @Override
    public void setJustification(int justification) {
        this.record("setJustification", justification, Integer.TYPE);
        this.proc.setJustification(justification);
    }

    @Override
    public void setLineWidth(int width) {
        this.record("setLineWidth", width, Integer.TYPE);
        this.proc.setLineWidth(width);
    }

    @Override
    public void setLutAnimation(boolean lutAnimation) {
        this.record("setLutAnimation", lutAnimation, Boolean.TYPE);
        this.proc.setLutAnimation(lutAnimation);
    }

    @Override
    public void setMask(ImageProcessor mask) {
        this.record("setMask", mask, ImageProcessor.class);
        this.proc.setMask(mask);
    }

    @Override
    public void setMinAndMax(double min2, double max) {
        this.record("setMinAndMax", new Object[]{min2, max}, new Class[]{Double.TYPE, Double.TYPE});
        this.proc.setMinAndMax(min2, max);
    }

    @Override
    public void setPixels(int channelNumber, FloatProcessor fp) {
        this.record("setPixels", new Object[]{channelNumber, fp}, new Class[]{Integer.TYPE, FloatProcessor.class});
        this.proc.setPixels(channelNumber, fp);
    }

    @Override
    public void setPixels(Object pixels) {
        this.record("setPixels", pixels, Object.class);
        this.proc.setPixels(pixels);
    }

    @Override
    public void setProgressBar(ProgressBar pb) {
        this.record("setProgressBar", pb, ProgressBar.class);
        this.proc.setProgressBar(pb);
    }

    @Override
    public void setRoi(int x, int y, int rwidth, int rheight) {
        this.record("setRoi", new Object[]{x, y, rwidth, rheight}, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        this.proc.setRoi(x, y, rwidth, rheight);
    }

    @Override
    public void setRoi(Polygon roi) {
        this.record("setRoi", roi, Polygon.class);
        this.proc.setRoi(roi);
    }

    @Override
    public void setRoi(Rectangle roi) {
        this.record("setRoi", roi, Rectangle.class);
        this.proc.setRoi(roi);
    }

    @Override
    public void setRoi(Roi roi) {
        this.record("setRoi", roi, Roi.class);
        this.proc.setRoi(roi);
    }

    @Override
    public void setSnapshotCopyMode(boolean b) {
        this.record("setSnapshotCopyMode", b, Boolean.TYPE);
        this.proc.setSnapshotCopyMode(b);
    }

    @Override
    public void setSnapshotPixels(Object pixels) {
        this.record("setSnapshotPixels", pixels, Object.class);
        this.proc.setSnapshotPixels(pixels);
    }

    @Override
    public void setThreshold(double minThreshold, double maxThreshold, int lutUpdate) {
        this.record("setThreshold", new Object[]{minThreshold, maxThreshold, lutUpdate}, new Class[]{Double.TYPE, Double.TYPE, Integer.TYPE});
        this.proc.setThreshold(minThreshold, maxThreshold, lutUpdate);
    }

    @Override
    public void setValue(double value) {
        this.record("setValue", value, Double.TYPE);
        this.proc.setValue(value);
    }

    @Override
    public void sharpen() {
        this.record("sharpen");
        this.proc.sharpen();
    }

    @Override
    public void smooth() {
        this.record("smooth");
        this.proc.smooth();
    }

    @Override
    public void snapshot() {
        this.record("snapshot");
        this.proc.snapshot();
    }

    @Override
    public void sqr() {
        this.record("sqr");
        this.proc.sqr();
    }

    @Override
    public void sqrt() {
        this.record("sqrt");
        this.proc.sqrt();
    }

    @Override
    public void swapPixelArrays() {
        this.record("swapPixelArrays");
        this.proc.swapPixelArrays();
    }

    @Override
    public void threshold(int level) {
        this.record("threshold", level, Integer.TYPE);
        this.proc.threshold(level);
    }

    @Override
    public FloatProcessor toFloat(int channelNumber, FloatProcessor fp) {
        this.record("toFloat", new Object[]{channelNumber, fp}, new Class[]{Integer.TYPE, FloatProcessor.class});
        return this.proc.toFloat(channelNumber, fp);
    }

    @Override
    public String toString() {
        this.record("toString");
        return this.proc.toString();
    }

    public void translate(int xOffset, int yOffset) {
        this.record("translate", new Object[]{xOffset, yOffset}, new Class[]{Integer.TYPE, Integer.TYPE});
        this.proc.translate(xOffset, yOffset);
    }

    @Override
    public void updateComposite(int[] rgbPixels, int channel) {
        this.record("updateComposite", new Object[]{rgbPixels, channel}, new Class[]{int[].class, Integer.TYPE});
        this.proc.updateComposite(rgbPixels, channel);
    }

    @Override
    public void xor(int value) {
        this.record("xor", value, Integer.TYPE);
        this.proc.xor(value);
    }

    private void record(String method) {
        this.record(method, (Object)null, (Class)null);
    }

    private void record(String method, Object v, Class<?> c) {
        Class[] classArray;
        Object[] objectArray;
        if (v == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = v;
        }
        if (c == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = c;
        }
        this.record(method, objectArray, classArray);
    }

    private void record(String method, Object[] v, Class<?>[] c) {
        if (!this.doRecording) {
            return;
        }
        MethodEntry m4 = new MethodEntry();
        m4.name = method;
        m4.args = v;
        if (v == null && c != null) {
            m4.args = new Object[c.length];
            for (int i = 0; i < m4.args.length; ++i) {
                m4.args[i] = null;
            }
        }
        try {
            m4.method = this.proc.getClass().getMethod(method, c);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.methodStack.add(m4);
    }

    class MethodEntry {
        public String name;
        public Object[] args;
        public Method method;

        MethodEntry() {
        }
    }
}

