/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.dev;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RecordGenerator {
    public static void main(String[] args2) throws Exception {
        Class.forName("loci.poi.generator.FieldIterator");
        if (args2.length != 4) {
            System.out.println("Usage:");
            System.out.println("  java loci.poi.hssf.util.RecordGenerator RECORD_DEFINTIONS RECORD_STYLES DEST_SRC_PATH TEST_SRC_PATH");
        } else {
            RecordGenerator.generateRecords(args2[0], args2[1], args2[2], args2[3]);
        }
    }

    private static void generateRecords(String defintionsDir, String recordStyleDir, String destSrcPathDir, String testSrcPathDir) throws Exception {
        File definitionsFile = new File(defintionsDir);
        for (int i = 0; i < definitionsFile.listFiles().length; ++i) {
            File file2 = definitionsFile.listFiles()[i];
            if (!file2.isFile() || !file2.getName().endsWith("_record.xml") && !file2.getName().endsWith("_type.xml")) continue;
            DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory2.newDocumentBuilder();
            Document document = builder.parse(file2);
            Element record = document.getDocumentElement();
            String extendstg = record.getElementsByTagName("extends").item(0).getFirstChild().getNodeValue();
            String suffix = record.getElementsByTagName("suffix").item(0).getFirstChild().getNodeValue();
            String recordName = record.getAttributes().getNamedItem("name").getNodeValue();
            String packageName = record.getAttributes().getNamedItem("package").getNodeValue();
            packageName = packageName.replace('.', '/');
            String destinationPath = destSrcPathDir + "/" + packageName;
            File destinationPathFile = new File(destinationPath);
            destinationPathFile.mkdirs();
            String destinationFilepath = destinationPath + "/" + recordName + suffix + ".java";
            RecordGenerator.transform(file2, new File(destinationFilepath), new File(recordStyleDir + "/" + extendstg.toLowerCase() + ".xsl"));
            System.out.println("Generated " + suffix + ": " + destinationFilepath);
            destinationPath = testSrcPathDir + "/" + packageName;
            destinationPathFile = new File(destinationPath);
            destinationPathFile.mkdirs();
            destinationFilepath = destinationPath + "/Test" + recordName + suffix + ".java";
            if (!new File(destinationFilepath).exists()) {
                String temp = recordStyleDir + "/" + extendstg.toLowerCase() + "_test.xsl";
                RecordGenerator.transform(file2, new File(destinationFilepath), new File(temp));
                System.out.println("Generated test: " + destinationFilepath);
                continue;
            }
            System.out.println("Skipped test generation: " + destinationFilepath);
        }
    }

    private static void transform(File in, File out, File xslt) throws FileNotFoundException, TransformerException {
        Transformer t2;
        FileReader r = new FileReader(xslt);
        StreamSource ss = new StreamSource(r);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            t2 = tf.newTransformer(ss);
        }
        catch (TransformerException ex) {
            System.err.println("Error compiling XSL style sheet " + xslt);
            throw ex;
        }
        Properties p = new Properties();
        p.setProperty("method", "text");
        t2.setOutputProperties(p);
        StreamResult result = new StreamResult(out);
        t2.transform(new StreamSource(in), result);
    }
}

