/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.model;

import java.util.Iterator;
import java.util.List;
import loci.poi.ddf.EscherOptRecord;
import loci.poi.ddf.EscherProperty;
import loci.poi.ddf.EscherSimpleProperty;
import loci.poi.hssf.model.TextboxShape;
import loci.poi.hssf.record.CommonObjectDataSubRecord;
import loci.poi.hssf.record.NoteRecord;
import loci.poi.hssf.record.NoteStructureSubRecord;
import loci.poi.hssf.record.ObjRecord;
import loci.poi.hssf.usermodel.HSSFComment;
import loci.poi.hssf.usermodel.HSSFShape;

public class CommentShape
extends TextboxShape {
    private NoteRecord note;

    public CommentShape(HSSFComment hssfShape, int shapeId) {
        super(hssfShape, shapeId);
        this.note = this.createNoteRecord(hssfShape, shapeId);
        ObjRecord obj = this.getObjRecord();
        List records = obj.getSubRecords();
        int cmoIdx = 0;
        for (int i = 0; i < records.size(); ++i) {
            Object r = records.get(i);
            if (!(r instanceof CommonObjectDataSubRecord)) continue;
            CommonObjectDataSubRecord cmo = (CommonObjectDataSubRecord)r;
            cmo.setAutofill(false);
            cmoIdx = i;
        }
        NoteStructureSubRecord u = new NoteStructureSubRecord();
        obj.addSubRecord(cmoIdx + 1, u);
    }

    private NoteRecord createNoteRecord(HSSFComment shape, int shapeId) {
        NoteRecord note = new NoteRecord();
        note.setColumn(shape.getColumn());
        note.setRow((short)shape.getRow());
        note.setFlags(shape.isVisible() ? (short)2 : 0);
        note.setShapeId((short)shapeId);
        note.setAuthor(shape.getAuthor() == null ? "" : shape.getAuthor());
        return note;
    }

    @Override
    protected int addStandardOptions(HSSFShape shape, EscherOptRecord opt) {
        super.addStandardOptions(shape, opt);
        List props = opt.getEscherProperties();
        Iterator iterator2 = props.iterator();
        while (iterator2.hasNext()) {
            EscherProperty prop = (EscherProperty)iterator2.next();
            switch (prop.getId()) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 387: 
                case 448: 
                case 959: {
                    iterator2.remove();
                }
            }
        }
        HSSFComment comment = (HSSFComment)shape;
        opt.addEscherProperty(new EscherSimpleProperty(959, comment.isVisible() ? 655360 : 655362));
        opt.addEscherProperty(new EscherSimpleProperty(575, 196611));
        opt.addEscherProperty(new EscherSimpleProperty(513, 0));
        opt.sortProperties();
        return opt.getEscherProperties().size();
    }

    public NoteRecord getNoteRecord() {
        return this.note;
    }
}

