/*
 * Decompiled with CFR 0.152.
 */
package mdbtools;

import mdbtools.jdbc2.File;
import mdbtools.libmdb.Catalog;
import mdbtools.libmdb.Data;
import mdbtools.libmdb.Holder;
import mdbtools.libmdb.MdbCatalogEntry;
import mdbtools.libmdb.MdbColumn;
import mdbtools.libmdb.MdbHandle;
import mdbtools.libmdb.MdbTableDef;
import mdbtools.libmdb.Table;
import mdbtools.libmdb.file;
import mdbtools.libmdb.mem;

public class mdb_export {
    public static boolean is_text_type(int x) {
        return x == 10 || x == 12 || x == 8;
    }

    public static void main(String[] args2) {
        args2 = new String[]{"/home/whoever/Downloads/test.mdb", "user"};
        MdbColumn col = null;
        Holder[] bound_values = new Holder[256];
        String delimiter = ",";
        boolean header_row = true;
        boolean quote_text = true;
        String filename = args2[0];
        String tablename = args2[1];
        mem.mdb_init();
        try {
            MdbHandle mdb = file.mdb_open(new File(args2[0]));
            Catalog.mdb_read_catalog(mdb, 1);
            for (int i = 0; i < mdb.num_catalog; ++i) {
                int j;
                MdbCatalogEntry entry = (MdbCatalogEntry)mdb.catalog.get(i);
                if (entry.object_type != 1 || !entry.object_name.equals(tablename)) continue;
                MdbTableDef table = Table.mdb_read_table(entry);
                Table.mdb_read_columns(table);
                Data.mdb_rewind_table(table);
                for (j = 0; j < table.num_cols; ++j) {
                    bound_values[j] = new Holder();
                    Data.mdb_bind_column(table, j + 1, bound_values[j]);
                }
                if (header_row) {
                    col = (MdbColumn)table.columns.get(0);
                    System.out.print(col.name);
                    for (j = 1; j < table.num_cols; ++j) {
                        col = (MdbColumn)table.columns.get(j);
                        System.out.print(delimiter + col.name);
                    }
                    System.out.println("");
                }
                while (Data.mdb_fetch_row(table)) {
                    char c;
                    int k;
                    if (quote_text && mdb_export.is_text_type(col.col_type)) {
                        System.out.print("\"");
                        for (k = 0; k < bound_values[0].s.length(); ++k) {
                            c = bound_values[0].s.charAt(k);
                            if (c == '\"') {
                                System.out.print("\"\"");
                                continue;
                            }
                            System.out.print(c);
                        }
                        System.out.print("\"");
                    } else {
                        System.out.print(bound_values[0].s);
                    }
                    for (j = 1; j < table.num_cols; ++j) {
                        col = (MdbColumn)table.columns.get(j);
                        if (quote_text && mdb_export.is_text_type(col.col_type)) {
                            System.out.print(delimiter);
                            System.out.print("\"");
                            for (k = 0; k < bound_values[j].s.length(); ++k) {
                                c = bound_values[j].s.charAt(k);
                                if (c == '\"') {
                                    System.out.print("\"\"");
                                    continue;
                                }
                                System.out.print(c);
                            }
                            System.out.print("\"");
                            continue;
                        }
                        System.out.print(delimiter + bound_values[j].s);
                    }
                    System.out.println("");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

