/*
 * Decompiled with CFR 0.152.
 */
package mdbtools;

import mdbtools.jdbc2.File;
import mdbtools.libmdb.Catalog;
import mdbtools.libmdb.MdbCatalogEntry;
import mdbtools.libmdb.MdbColumn;
import mdbtools.libmdb.MdbHandle;
import mdbtools.libmdb.MdbTableDef;
import mdbtools.libmdb.Table;
import mdbtools.libmdb.backend;
import mdbtools.libmdb.file;
import mdbtools.libmdb.mem;

public class mdb_schema {
    public static void main(String[] args2) {
        if (args2.length < 1) {
            System.out.println("Usage: <file> [<backend>]");
            return;
        }
        try {
            mem.mdb_init();
            MdbHandle mdb = file.mdb_open(new File(args2[0]));
            Catalog.mdb_read_catalog(mdb, 1);
            for (int i = 0; i < mdb.num_catalog; ++i) {
                MdbCatalogEntry entry = (MdbCatalogEntry)mdb.catalog.get(i);
                if (entry.object_type != 1 || entry.object_name.startsWith("MSys")) continue;
                System.out.println("DROP TABLE " + entry.object_name + ";");
                System.out.println("CREATE TABLE " + entry.object_name);
                System.out.println(" (");
                MdbTableDef table = Table.mdb_read_table(entry);
                Table.mdb_read_columns(table);
                for (int k = 0; k < table.num_cols; ++k) {
                    MdbColumn col = (MdbColumn)table.columns.get(k);
                    System.out.print("\t" + col.name + "\t\t\t" + backend.mdb_get_coltype_string(mdb.default_backend, col.col_type));
                    if (col.col_size != 0) {
                        System.out.print(" (" + col.col_size + ")");
                    }
                    if (k < table.num_cols - 1) {
                        System.out.println(", ");
                        continue;
                    }
                    System.out.println("");
                }
                System.out.println("\n");
                System.out.println(");");
                System.out.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

