/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.tests;

import mdbtools.libmdb.Catalog;
import mdbtools.libmdb.Data;
import mdbtools.libmdb.Holder;
import mdbtools.libmdb.MdbCatalogEntry;
import mdbtools.libmdb.MdbColumn;
import mdbtools.libmdb.MdbHandle;
import mdbtools.libmdb.MdbTableDef;
import mdbtools.libmdb.Table;
import mdbtools.libmdb.backend;
import mdbtools.libmdb.file;
import mdbtools.libmdb.mem;

public class ColumnTest {
    private static final String[][] columns = new String[][]{{"aText", "Text"}, {"aMemo", "Memo/Hyperlink"}, {"aLongInteger", "Long Integer"}, {"aDateTime", "DateTime (Short)"}, {"aCurrency", "Currency"}, {"aAutoNumber", "Long Integer"}, {"aYesNo", "Boolean"}, {"aOleObject", "OLE"}, {"aHyperlink", "Memo/Hyperlink"}, {"aDouble", "Double"}, {"aByte", "Byte"}, {"aInteger", "Integer"}, {"aSingle", "Single"}, {"aReplicationId", "Replication ID"}, {"aDecimal", "Decimal"}};
    private static final String tableName = "aTable";
    private static final String[][] dataAsString = new String[][]{{"My Text", "This is a story about a boy who lived a very long life", "892", "2/8/2005 0:0:0", "8.9800", "1", "0", "+++ole+++", new String(new byte[]{-3, -3}) + "My Link#http://www.yahoo.com#", "23.4456", "253", "23432", "677.333", "+++replication+++", "2143"}};

    public static void main(String[] args2) {
        new ColumnTest().go();
    }

    private void go() {
        try {
            MdbColumn col;
            int i;
            mem.mdb_init();
            String filename = "/home/melissa/data/cellr/colin/07-06-21_d.mtb";
            MdbHandle mdb = null;
            Catalog.mdb_read_catalog(mdb, 1);
            MdbTableDef table = null;
            for (i = 0; i < mdb.num_catalog; ++i) {
                MdbCatalogEntry entry = (MdbCatalogEntry)mdb.catalog.get(i);
                if (entry.object_type != 1 || !entry.object_name.equals(tableName)) continue;
                table = Table.mdb_read_table(entry);
                break;
            }
            if (table == null) {
                throw new RuntimeException("table not found");
            }
            Table.mdb_read_columns(table);
            Data.mdb_rewind_table(table);
            if (table.columns.size() != columns.length) {
                throw new RuntimeException("wrong number of columns");
            }
            for (i = 0; i < table.num_cols; ++i) {
                col = (MdbColumn)table.columns.get(i);
                if (this.findColumnName(col.name)) continue;
                throw new RuntimeException("column name " + col.name + " not found");
            }
            System.out.println("column names check out");
            for (i = 0; i < table.num_cols; ++i) {
                col = (MdbColumn)table.columns.get(i);
                String col_type = backend.mdb_get_coltype_string(mdb.default_backend, col.col_type);
                String real_type = this.findColumnType(col.name, col_type);
                if (real_type.equals(col_type)) continue;
                throw new RuntimeException("column " + col.name + " should have a type of " + real_type + " instead it's " + col_type);
            }
            System.out.println("column types check out");
            Holder[] bound_values = new Holder[table.num_cols];
            for (int i2 = 0; i2 < table.num_cols; ++i2) {
                bound_values[i2] = new Holder();
                Data.mdb_bind_column(table, i2 + 1, bound_values[i2]);
            }
            int row = 0;
            if (Data.mdb_fetch_row(table)) {
                for (int i3 = 0; i3 < table.num_cols; ++i3) {
                    String foundValue;
                    MdbColumn col2 = (MdbColumn)table.columns.get(i3);
                    String value = this.findStringValue(row, col2.name);
                    if (col2.col_type == 11 || col2.name.equals("aReplicationId") || value.equals(foundValue = bound_values[i3].s)) continue;
                    throw new RuntimeException("wrong data for row: " + i3 + " column: " + col2.name + " found " + bound_values[i3].s + " should be: " + value);
                }
                ++row;
                System.out.println("first row worked");
            }
            System.out.println("string data checks out");
            System.out.println("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean findColumnName(String name) {
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i][0].equals(name)) continue;
            return true;
        }
        return false;
    }

    private String findColumnType(String name, String type) {
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i][0].equals(name)) continue;
            return columns[i][1];
        }
        throw new RuntimeException("column " + name + " not found");
    }

    private String findStringValue(int row, String name) {
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i][0].equals(name)) continue;
            return dataAsString[row][i];
        }
        throw new RuntimeException("column " + name + " not found");
    }

    private String toHex(byte[] ba) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ba.length; ++i) {
            sb.append(Integer.toHexString(file.unsign(ba[i])));
        }
        return sb.toString();
    }
}

