/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSink;
import okio.Segment;
import okio.Sink;
import okio.Util;

public final class HashingSink
extends ForwardingSink {
    private final MessageDigest messageDigest;
    private final Mac mac;

    public static HashingSink md5(Sink sink2) {
        return new HashingSink(sink2, "MD5");
    }

    public static HashingSink sha1(Sink sink2) {
        return new HashingSink(sink2, "SHA-1");
    }

    public static HashingSink sha256(Sink sink2) {
        return new HashingSink(sink2, "SHA-256");
    }

    public static HashingSink sha512(Sink sink2) {
        return new HashingSink(sink2, "SHA-512");
    }

    public static HashingSink hmacSha1(Sink sink2, ByteString key) {
        return new HashingSink(sink2, key, "HmacSHA1");
    }

    public static HashingSink hmacSha256(Sink sink2, ByteString key) {
        return new HashingSink(sink2, key, "HmacSHA256");
    }

    public static HashingSink hmacSha512(Sink sink2, ByteString key) {
        return new HashingSink(sink2, key, "HmacSHA512");
    }

    private HashingSink(Sink sink2, String algorithm) {
        super(sink2);
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
            this.mac = null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    private HashingSink(Sink sink2, ByteString key, String algorithm) {
        super(sink2);
        try {
            this.mac = Mac.getInstance(algorithm);
            this.mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            this.messageDigest = null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void write(Buffer source2, long byteCount) throws IOException {
        int toHash;
        Util.checkOffsetAndCount(source2.size, 0L, byteCount);
        Segment s2 = source2.head;
        for (long hashedCount = 0L; hashedCount < byteCount; hashedCount += (long)toHash) {
            toHash = (int)Math.min(byteCount - hashedCount, (long)(s2.limit - s2.pos));
            if (this.messageDigest != null) {
                this.messageDigest.update(s2.data, s2.pos, toHash);
            } else {
                this.mac.update(s2.data, s2.pos, toHash);
            }
            s2 = s2.next;
        }
        super.write(source2, byteCount);
    }

    public ByteString hash() {
        byte[] result = this.messageDigest != null ? this.messageDigest.digest() : this.mac.doFinal();
        return ByteString.of(result);
    }
}

