/*
 * Decompiled with CFR 0.152.
 */
package ome.jxrlib;

import java.io.File;
import java.nio.ByteBuffer;
import ome.jxrlib.CodecFactory;
import ome.jxrlib.DecodeContext;
import ome.jxrlib.DecodeException;
import ome.jxrlib.Factory;
import ome.jxrlib.FormatConverter;
import ome.jxrlib.GUID;
import ome.jxrlib.ImageDecoder;
import ome.jxrlib.ImageEncoder;
import ome.jxrlib.Stream;

abstract class AbstractDecode {
    private final Factory factory = new Factory();
    private final CodecFactory codecFactory = new CodecFactory();
    private final File inputFile;
    private final ByteBuffer dataBuffer;
    private final ImageDecoder decoder;
    private final long frameCount;

    public AbstractDecode(File inputFile) {
        this.inputFile = inputFile;
        this.dataBuffer = null;
        this.decoder = new ImageDecoder();
        this.codecFactory.decoderFromFile(this.decoder, inputFile.getAbsolutePath());
        this.frameCount = this.decoder.getFrameCount();
    }

    AbstractDecode(byte[] data) throws DecodeException {
        this(ByteBuffer.allocateDirect(data.length).put(data));
    }

    AbstractDecode(ByteBuffer dataBuffer) throws DecodeException {
        this(dataBuffer, 0, dataBuffer.capacity());
    }

    AbstractDecode(ByteBuffer dataBuffer, int offset, int length) throws DecodeException {
        if (!dataBuffer.isDirect()) {
            throw new DecodeException("Buffer must be allocated direct.");
        }
        this.inputFile = null;
        this.dataBuffer = dataBuffer;
        this.decoder = new ImageDecoder();
        this.codecFactory.decoderFromBytes(this.decoder, dataBuffer, offset, length);
        this.frameCount = this.decoder.getFrameCount();
    }

    public long getWidth() {
        return this.decoder.getWidth();
    }

    public long getHeight() {
        return this.decoder.getHeight();
    }

    public long getBytesPerPixel() {
        return this.decoder.getBytesPerPixel();
    }

    public GUID getPixelFormat() {
        return this.decoder.getGUIDPixFormat();
    }

    public boolean isBGR() {
        return this.decoder.isBGR();
    }

    public void toBytes(ByteBuffer imageBuffer) throws DecodeException {
        if (!imageBuffer.isDirect()) {
            throw new DecodeException("Buffer must be allocated direct.");
        }
        this.decoder.getRawBytes(imageBuffer);
    }

    public void toFile(File outputFile) {
        String fileName = outputFile.getName();
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        for (long i = 0L; i < this.frameCount; ++i) {
            this.decoder.selectFrame(i);
            FormatConverter converter = this.codecFactory.createFormatConverter(this.decoder, extension);
            System.err.println("Created format converter for extension: " + extension);
            Stream outputStream2 = this.factory.createStreamFromFilename(outputFile.getAbsolutePath());
            System.err.println("Created output stream for file: " + fileName);
            ImageEncoder encoder = new ImageEncoder(outputStream2, "." + extension);
            System.err.println("Created image encoder");
            encoder.initializeWithDecoder(this.decoder);
            encoder.writeSource(converter);
            encoder.close();
        }
    }

    protected static byte[] decodeFirstFrame(byte[] source2, int offset, int length) {
        DecodeContext decodeContext = new DecodeContext();
        return decodeContext.decodeFirstFrame(source2, offset, length);
    }
}

