/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import org.apache.bcel.classfile.Utility;

public abstract class NativeVerifier {
    public static void main(String[] args2) {
        int dotclasspos;
        if (args2.length != 1) {
            System.out.println("Verifier front-end: need exactly one argument.");
            System.exit(1);
        }
        if ((dotclasspos = args2[0].lastIndexOf(".class")) != -1) {
            args2[0] = args2[0].substring(0, dotclasspos);
        }
        args2[0] = Utility.pathToPackage(args2[0]);
        try {
            Class.forName(args2[0]);
        }
        catch (ExceptionInInitializerError eiie) {
            System.out.println("NativeVerifier: ExceptionInInitializerError encountered on '" + args2[0] + "'.");
            System.out.println(eiie);
            System.exit(1);
        }
        catch (LinkageError le) {
            System.out.println("NativeVerifier: LinkageError encountered on '" + args2[0] + "'.");
            System.out.println(le);
            System.exit(1);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("NativeVerifier: FILE NOT FOUND: '" + args2[0] + "'.");
            System.exit(1);
        }
        catch (Throwable t2) {
            System.out.println("NativeVerifier: Unspecified verification error on '" + args2[0] + "'.");
            System.exit(1);
        }
        System.out.println("NativeVerifier: Class file '" + args2[0] + "' seems to be okay.");
        System.exit(0);
    }

    private NativeVerifier() {
    }
}

