/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class FileEqualsFileFilter
extends AbstractFileFilter {
    private final File file;
    private final Path path;

    public FileEqualsFileFilter(File file2) {
        this.file = Objects.requireNonNull(file2, "file");
        this.path = file2.toPath();
    }

    @Override
    public boolean accept(File file2) {
        return Objects.equals(this.file, file2);
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes attributes) {
        return this.toFileVisitResult(Objects.equals(this.path, path));
    }
}

