/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;

public class Variance
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -9111962718267217978L;
    protected SecondMoment moment = null;
    protected boolean incMoment = true;
    private boolean isBiasCorrected = true;

    public Variance() {
        this.moment = new SecondMoment();
    }

    public Variance(SecondMoment m22) {
        this.incMoment = false;
        this.moment = m22;
    }

    public Variance(boolean isBiasCorrected) {
        this.moment = new SecondMoment();
        this.isBiasCorrected = isBiasCorrected;
    }

    public Variance(boolean isBiasCorrected, SecondMoment m22) {
        this.incMoment = false;
        this.moment = m22;
        this.isBiasCorrected = isBiasCorrected;
    }

    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    public double getResult() {
        if (this.moment.n == 0L) {
            return Double.NaN;
        }
        if (this.moment.n == 1L) {
            return 0.0;
        }
        if (this.isBiasCorrected) {
            return this.moment.m2 / ((double)this.moment.n - 1.0);
        }
        return this.moment.m2 / (double)this.moment.n;
    }

    public long getN() {
        return this.moment.getN();
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double evaluate(double[] values2) {
        if (values2 == null) {
            throw new IllegalArgumentException("input values array is null");
        }
        return this.evaluate(values2, 0, values2.length);
    }

    public double evaluate(double[] values2, int begin, int length) {
        double var = Double.NaN;
        if (this.test(values2, begin, length)) {
            this.clear();
            if (length == 1) {
                var = 0.0;
            } else if (length > 1) {
                Mean mean = new Mean();
                double m4 = mean.evaluate(values2, begin, length);
                var = this.evaluate(values2, m4, begin, length);
            }
        }
        return var;
    }

    public double evaluate(double[] values2, double mean, int begin, int length) {
        double var = Double.NaN;
        if (this.test(values2, begin, length)) {
            if (length == 1) {
                var = 0.0;
            } else if (length > 1) {
                double accum = 0.0;
                double dev = 0.0;
                double accum2 = 0.0;
                for (int i = begin; i < begin + length; ++i) {
                    dev = values2[i] - mean;
                    accum += dev * dev;
                    accum2 += dev;
                }
                double len = length;
                var = this.isBiasCorrected ? (accum - accum2 * accum2 / len) / (len - 1.0) : (accum - accum2 * accum2 / len) / len;
            }
        }
        return var;
    }

    public double evaluate(double[] values2, double mean) {
        return this.evaluate(values2, mean, 0, values2.length);
    }

    public boolean isBiasCorrected() {
        return this.isBiasCorrected;
    }

    public void setBiasCorrected(boolean isBiasCorrected) {
        this.isBiasCorrected = isBiasCorrected;
    }
}

