/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.rank;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.stat.descriptive.AbstractUnivariateStatistic;

public class Percentile
extends AbstractUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8091216485095130416L;
    private double quantile = 0.0;

    public Percentile() {
        this(50.0);
    }

    public Percentile(double p) {
        this.setQuantile(p);
    }

    public double evaluate(double[] values2, double p) {
        this.test(values2, 0, 0);
        return this.evaluate(values2, 0, values2.length, p);
    }

    public double evaluate(double[] values2, int start, int length) {
        return this.evaluate(values2, start, length, this.quantile);
    }

    public double evaluate(double[] values2, int begin, int length, double p) {
        this.test(values2, begin, length);
        if (p > 100.0 || p <= 0.0) {
            throw new IllegalArgumentException("invalid quantile value: " + p);
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values2[begin];
        }
        double n = length;
        double pos = p * (n + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double[] sorted2 = new double[length];
        System.arraycopy(values2, begin, sorted2, 0, length);
        Arrays.sort(sorted2);
        if (pos < 1.0) {
            return sorted2[0];
        }
        if (pos >= n) {
            return sorted2[length - 1];
        }
        double lower = sorted2[intPos - 1];
        double upper = sorted2[intPos];
        return lower + dif * (upper - lower);
    }

    public double getQuantile() {
        return this.quantile;
    }

    public void setQuantile(double p) {
        if (p <= 0.0 || p > 100.0) {
            throw new IllegalArgumentException("Illegal quantile value: " + p);
        }
        this.quantile = p;
    }
}

