/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.perf4j.GroupedTimingStatistics;
import org.perf4j.chart.GoogleChartGenerator;
import org.perf4j.chart.StatisticsChartGenerator;
import org.perf4j.helpers.GroupedTimingStatisticsCsvFormatter;
import org.perf4j.helpers.GroupedTimingStatisticsFormatter;
import org.perf4j.helpers.GroupedTimingStatisticsTextFormatter;
import org.perf4j.helpers.GroupingStatisticsIterator;
import org.perf4j.helpers.StatsValueRetriever;
import org.perf4j.helpers.StopWatchLogIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogParser {
    private Reader inputLog;
    private PrintStream statisticsOutput;
    private PrintStream graphingOutput;
    private StatisticsChartGenerator meanTimeChartGenerator;
    private StatisticsChartGenerator tpsChartGenerator;
    private long timeSlice;
    private boolean createRollupStatistics;
    private GroupedTimingStatisticsFormatter statisticsFormatter;

    public LogParser() {
        this(new InputStreamReader(System.in), System.out, null, 30000L, false, new GroupedTimingStatisticsTextFormatter());
    }

    public LogParser(Reader inputLog, PrintStream statisticsOutput, PrintStream graphingOutput, long timeSlice, boolean createRollupStatistics, GroupedTimingStatisticsFormatter statisticsFormatter) {
        this.inputLog = inputLog;
        this.statisticsOutput = statisticsOutput;
        this.graphingOutput = graphingOutput;
        this.timeSlice = timeSlice;
        this.createRollupStatistics = createRollupStatistics;
        if (graphingOutput != null) {
            this.meanTimeChartGenerator = this.newMeanTimeChartGenerator();
            this.tpsChartGenerator = this.newTpsChartGenerator();
        }
        this.statisticsFormatter = statisticsFormatter;
    }

    public void parseLog() {
        StopWatchLogIterator stopWatchIter = new StopWatchLogIterator(this.inputLog);
        int i = 0;
        GroupingStatisticsIterator statsIter = new GroupingStatisticsIterator(stopWatchIter, this.timeSlice, this.createRollupStatistics);
        while (statsIter.hasNext()) {
            GroupedTimingStatistics statistics = statsIter.next();
            if (this.statisticsOutput != null) {
                this.statisticsOutput.print(this.statisticsFormatter.format(statistics));
            }
            if (this.graphingOutput == null) continue;
            this.meanTimeChartGenerator.appendData(statistics);
            this.tpsChartGenerator.appendData(statistics);
            if (++i % 20 != 0 && statsIter.hasNext()) continue;
            this.printGraphOutput();
        }
    }

    protected StatisticsChartGenerator newMeanTimeChartGenerator() {
        return new GoogleChartGenerator();
    }

    protected StatisticsChartGenerator newTpsChartGenerator() {
        return new GoogleChartGenerator(StatsValueRetriever.TPS_VALUE_RETRIEVER);
    }

    protected void printGraphOutput() {
        this.graphingOutput.println("<br/><br/><img src=\"" + this.meanTimeChartGenerator.getChartUrl() + "\"/>");
        this.graphingOutput.println("<br/><br/><img src=\"" + this.tpsChartGenerator.getChartUrl() + "\"/>");
    }

    public static void main(String[] args2) {
        System.exit(LogParser.runMain(args2));
    }

    public static int runMain(String[] args2) {
        try {
            ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args2));
            if (LogParser.printUsage(argsList)) {
                return 0;
            }
            PrintStream statisticsOutput = LogParser.openStatisticsOutput(argsList);
            PrintStream graphingOutput = LogParser.openGraphingOutput(argsList);
            long timeSlice = LogParser.getTimeSlice(argsList);
            boolean rollupStatistics = LogParser.getRollupStatistics(argsList);
            GroupedTimingStatisticsFormatter formatter = LogParser.getStatisticsFormatter(argsList);
            Reader input = LogParser.openInput(argsList);
            if (!argsList.isEmpty()) {
                LogParser.printUnknownArgs(argsList);
                return 1;
            }
            new LogParser(input, statisticsOutput, graphingOutput, timeSlice, rollupStatistics, formatter).parseLog();
            LogParser.closeGraphingOutput(graphingOutput);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    protected static boolean printUsage(List<String> argsList) {
        if (LogParser.getIndexOfArg(argsList, false, "-h", "--help", "-?", "--usage") >= 0) {
            System.out.println("Usage: LogParser [-o|--out|--output outputFile] [-g|--graph graphingOutputFile] [-t|--timeslice timeslice] [-r] [-f|--format text|csv] [logInputFile]");
            System.out.println("Arguments:");
            System.out.println("  logInputFile - The log file to be parsed. If not specified, log data is read from stdin.");
            System.out.println("  -o|--out|--output outputFile - The file where generated statistics should be written. If not specified, statistics are written to stdout.");
            System.out.println("  -g|--graph graphingOutputFile - The file where generated perf graphs should be written. If not specified, no graphs are written.");
            System.out.println("  -t|--timeslice timeslice - The length of time (in ms) of each timeslice for which statistics should be generated. Defaults to 30000 ms.");
            System.out.println("  -r - Whether or not statistics rollups should be generated. If not specified, rollups are not generated.");
            System.out.println("  -f|--format text|csv - The format for the statistics output, either plain text or CSV. Defaults to text.");
            System.out.println("                         If format is csv, then the columns output are tag, start, stop, mean, min, max, stddev, and count.");
            System.out.println();
            System.out.println("Note that out, stdout, err and stderr can be used as aliases to the standard output streams when specifying output files.");
            return true;
        }
        return false;
    }

    protected static PrintStream openStatisticsOutput(List<String> argsList) throws IOException {
        int indexOfOut = LogParser.getIndexOfArg(argsList, true, "-o", "--output", "--out");
        if (indexOfOut >= 0) {
            String fileName = argsList.remove(indexOfOut + 1);
            argsList.remove(indexOfOut);
            return LogParser.openStream(fileName);
        }
        return System.out;
    }

    protected static PrintStream openGraphingOutput(List<String> argsList) throws IOException {
        int indexOfOut = LogParser.getIndexOfArg(argsList, true, "-g", "--graph");
        if (indexOfOut >= 0) {
            String fileName = argsList.remove(indexOfOut + 1);
            argsList.remove(indexOfOut);
            PrintStream retVal = LogParser.openStream(fileName);
            retVal.println("<html>");
            retVal.println("<head><title>Perf4J Performance Graphs</title></head>");
            retVal.println("<body>");
            return retVal;
        }
        return null;
    }

    protected static void closeGraphingOutput(PrintStream graphingOutput) throws IOException {
        if (graphingOutput != null) {
            graphingOutput.println("</body></html>");
            if (graphingOutput != System.out && graphingOutput != System.err) {
                graphingOutput.close();
            }
        }
    }

    protected static long getTimeSlice(List<String> argsList) {
        int indexOfOut = LogParser.getIndexOfArg(argsList, true, "-t", "--timeslice");
        if (indexOfOut >= 0) {
            String timeslice = argsList.remove(indexOfOut + 1);
            argsList.remove(indexOfOut);
            return Long.parseLong(timeslice);
        }
        return 30000L;
    }

    protected static boolean getRollupStatistics(List<String> argsList) {
        int indexOfOut = LogParser.getIndexOfArg(argsList, false, "-r", "--rollup");
        if (indexOfOut >= 0) {
            argsList.remove(indexOfOut);
            return true;
        }
        return false;
    }

    protected static GroupedTimingStatisticsFormatter getStatisticsFormatter(List<String> argsList) {
        int indexOfFormat = LogParser.getIndexOfArg(argsList, true, "-f", "--format");
        if (indexOfFormat >= 0) {
            String formatString = argsList.remove(indexOfFormat + 1);
            argsList.remove(indexOfFormat);
            if ("text".equalsIgnoreCase(formatString)) {
                return new GroupedTimingStatisticsTextFormatter();
            }
            if ("csv".equalsIgnoreCase(formatString)) {
                return new GroupedTimingStatisticsCsvFormatter();
            }
            throw new IllegalArgumentException("Unknown format type: " + formatString);
        }
        return new GroupedTimingStatisticsTextFormatter();
    }

    protected static Reader openInput(List<String> argsList) throws IOException {
        if (argsList.isEmpty()) {
            return new InputStreamReader(System.in);
        }
        String fileName = argsList.remove(0);
        return new BufferedReader(new FileReader(fileName));
    }

    protected static void printUnknownArgs(List<String> argsList) {
        System.out.println("Unknown arguments: ");
        for (String arg : argsList) {
            System.out.print(arg + " ");
        }
        System.out.println();
    }

    protected static int getIndexOfArg(List<String> args2, boolean needsParam, String ... argNames) {
        int retVal = -1;
        boolean foundArg = false;
        for (String argName : argNames) {
            int argIndex = args2.indexOf(argName);
            if (argIndex < 0) continue;
            if (foundArg) {
                throw new IllegalArgumentException("You must specify only one of " + Arrays.toString(argNames));
            }
            retVal = argIndex;
            foundArg = true;
        }
        if (retVal >= 0 && needsParam && retVal == args2.size() - 1) {
            throw new IllegalArgumentException("You must specify a parameter for the " + args2.get(retVal) + " arg");
        }
        return retVal;
    }

    protected static PrintStream openStream(String fileName) throws IOException {
        if ("stdout".equals(fileName) || "out".equals(fileName)) {
            return System.out;
        }
        if ("stderr".equals(fileName) || "err".equals(fileName)) {
            return System.err;
        }
        return new PrintStream(new FileOutputStream(fileName), true);
    }
}

