/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.VertTransformBuilderIF;
import ucar.unidata.geoloc.vertical.HybridSigmaPressure;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class CFHybridSigmaPressure
extends AbstractTransformBuilder
implements VertTransformBuilderIF {
    private boolean useAp;
    private String a;
    private String b;
    private String ps;
    private String p0;
    private String ap;

    @Override
    public String getTransformName() {
        return VerticalCT.Type.HybridSigmaPressure.name();
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    @Override
    public VerticalCT makeCoordinateTransform(NetcdfDataset ds, AttributeContainer ctv) {
        String formula_terms = this.getFormula(ctv);
        if (null == formula_terms) {
            return null;
        }
        this.useAp = formula_terms.contains("ap:");
        VerticalCT rs = new VerticalCT("AtmHybridSigmaPressure_Transform_" + ctv.getName(), this.getTransformName(), VerticalCT.Type.HybridSigmaPressure, this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        if (this.useAp) {
            String[] values2 = this.parseFormula(formula_terms, "ap b ps");
            if (values2 == null) {
                return null;
            }
            this.ap = values2[0];
            this.b = values2[1];
            this.ps = values2[2];
            rs.addParameter(new Parameter("formula", "pressure(x,y,z) = ap(z) + b(z)*surfacePressure(x,y)"));
            if (!this.addParameter(rs, "SurfacePressure_variableName", ds, this.ps)) {
                return null;
            }
            if (!this.addParameter(rs, "AP_variableName", ds, this.ap)) {
                return null;
            }
            if (!this.addParameter(rs, "B_variableName", ds, this.b)) {
                return null;
            }
        } else {
            String[] values3 = this.parseFormula(formula_terms, "a b ps p0");
            if (values3 == null) {
                return null;
            }
            this.a = values3[0];
            this.b = values3[1];
            this.ps = values3[2];
            this.p0 = values3[3];
            rs.addParameter(new Parameter("formula", "pressure(x,y,z) = a(z)*p0 + b(z)*surfacePressure(x,y)"));
            if (!this.addParameter(rs, "SurfacePressure_variableName", ds, this.ps)) {
                return null;
            }
            if (!this.addParameter(rs, "A_variableName", ds, this.a)) {
                return null;
            }
            if (!this.addParameter(rs, "B_variableName", ds, this.b)) {
                return null;
            }
            if (!this.addParameter(rs, "P0_variableName", ds, this.p0)) {
                return null;
            }
        }
        return rs;
    }

    public String toString() {
        return "HybridSigmaPressure:" + (this.useAp ? "ps:" + this.ps + " p0:" + this.p0 + " a:" + this.a + " b:" + this.b : "ps:" + this.ps + " ap:" + this.ap + " b:" + this.b);
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new HybridSigmaPressure(ds, timeDim, vCT.getParameters());
    }
}

