/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.write.NcmlWriter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class FeatureDatasetCapabilitiesWriter {
    private static final Logger log = LoggerFactory.getLogger(FeatureDatasetCapabilitiesWriter.class);
    private FeatureDatasetPoint fdp;
    private String path;

    public FeatureDatasetCapabilitiesWriter(FeatureDatasetPoint fdp, String path) {
        this.fdp = fdp;
        this.path = path;
    }

    public String getCapabilities() {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(this.getCapabilitiesDocument());
    }

    public void getCapabilities(OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.getCapabilitiesDocument(), os);
    }

    public Document makeStationCollectionDocument(LatLonRect bb, String[] names) {
        List<DsgFeatureCollection> list = this.fdp.getPointFeatureCollectionList();
        DsgFeatureCollection fc = list.get(0);
        if (!(fc instanceof StationTimeSeriesFeatureCollection)) {
            throw new UnsupportedOperationException(fc.getClass().getName() + " not a StationTimeSeriesFeatureCollection");
        }
        StationTimeSeriesFeatureCollection sobs = (StationTimeSeriesFeatureCollection)fc;
        Element rootElem = new Element("stationCollection");
        Document doc = new Document(rootElem);
        List<StationFeature> stations = bb != null ? sobs.getStationFeatures(bb) : (names != null ? sobs.getStationFeatures(Arrays.asList(names)) : sobs.getStationFeatures());
        for (Station station : stations) {
            Element sElem = new Element("station");
            sElem.setAttribute("name", station.getName());
            if (station.getWmoId() != null) {
                sElem.setAttribute("wmo_id", station.getWmoId());
            }
            if (station.getDescription() != null && !station.getDescription().isEmpty()) {
                sElem.addContent((Content)new Element("description").addContent(station.getDescription()));
            }
            sElem.addContent((Content)new Element("longitude").addContent(Double.toString(station.getLongitude())));
            sElem.addContent((Content)new Element("latitide").addContent(Double.toString(station.getLatitude())));
            if (!Double.isNaN(station.getAltitude())) {
                sElem.addContent((Content)new Element("altitude").addContent(Double.toString(station.getAltitude())));
            }
            rootElem.addContent((Content)sElem);
        }
        return doc;
    }

    public Document getCapabilitiesDocument() {
        CalendarDateRange dateRange;
        Element rootElem = new Element("capabilities");
        Document doc = new Document(rootElem);
        if (null != this.path) {
            rootElem.setAttribute("location", this.path);
            Element elem = new Element("featureDataset");
            FeatureType ft = this.fdp.getFeatureType();
            elem.setAttribute("type", ft.toString().toLowerCase());
            String url = this.path.replace("dataset.xml", ft.toString().toLowerCase() + ".xml");
            elem.setAttribute("url", url);
            rootElem.addContent((Content)elem);
        }
        List<DsgFeatureCollection> list = this.fdp.getPointFeatureCollectionList();
        DsgFeatureCollection fc = list.get(0);
        rootElem.addContent((Content)this.writeTimeUnit(fc.getTimeUnit()));
        rootElem.addContent((Content)new Element("AltitudeUnits").addContent(fc.getAltUnits()));
        List<VariableSimpleIF> vars = this.fdp.getDataVariables();
        Collections.sort(vars);
        for (VariableSimpleIF v : vars) {
            rootElem.addContent((Content)this.writeVariable(v));
        }
        LatLonRect bb = fc.getBoundingBox();
        if (bb != null) {
            rootElem.addContent((Content)this.writeBoundingBox(bb));
        }
        if ((dateRange = fc.getCalendarDateRange()) != null) {
            Element drElem = new Element("TimeSpan");
            drElem.addContent((Content)new Element("begin").addContent(dateRange.getStart().toString()));
            drElem.addContent((Content)new Element("end").addContent(dateRange.getEnd().toString()));
            if (dateRange.getResolution() != null) {
                drElem.addContent((Content)new Element("resolution").addContent(dateRange.getResolution().toString()));
            }
            rootElem.addContent((Content)drElem);
        }
        return doc;
    }

    private Element writeTimeUnit(CalendarDateUnit dateUnit) {
        Element elem = new Element("TimeUnit");
        elem.addContent(dateUnit.getUdUnit());
        elem.setAttribute("calendar", dateUnit.getCalendar().toString());
        return elem;
    }

    private Element writeBoundingBox(LatLonRect bb) {
        int decToKeep = 6;
        double bbExpand = Math.pow(10.0, -decToKeep);
        LatLonPoint extendNorthEast = LatLonPoint.create(bb.getLatMax() + bbExpand, bb.getLonMax() + bbExpand);
        LatLonPoint extendSouthWest = LatLonPoint.create(bb.getLatMin() - bbExpand, bb.getLonMin() - bbExpand);
        bb.extend(extendNorthEast);
        bb.extend(extendSouthWest);
        Element bbElem = new Element("LatLonBox");
        bbElem.addContent((Content)new Element("west").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMin(), decToKeep)));
        bbElem.addContent((Content)new Element("east").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMax(), decToKeep)));
        bbElem.addContent((Content)new Element("south").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMin(), decToKeep)));
        bbElem.addContent((Content)new Element("north").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMax(), decToKeep)));
        return bbElem;
    }

    private Element writeVariable(VariableSimpleIF v) {
        NcmlWriter ncMLWriter = new NcmlWriter();
        Element varElem = new Element("variable");
        varElem.setAttribute("name", v.getShortName());
        DataType dt = v.getDataType();
        if (dt != null) {
            varElem.setAttribute("type", dt.toString());
        }
        for (Attribute att : v.attributes()) {
            varElem.addContent((Content)ncMLWriter.makeAttributeElement(att));
        }
        return varElem;
    }

    public Document readCapabilitiesDocument(InputStream in) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(false);
        return builder.build(in);
    }

    public static LatLonRect getSpatialExtent(Document doc) {
        Element root = doc.getRootElement();
        Element latlonBox = root.getChild("LatLonBox");
        if (latlonBox == null) {
            return null;
        }
        String westS = latlonBox.getChildText("west");
        String eastS = latlonBox.getChildText("east");
        String northS = latlonBox.getChildText("north");
        String southS = latlonBox.getChildText("south");
        if (westS == null || eastS == null || northS == null || southS == null) {
            return null;
        }
        try {
            double west = Double.parseDouble(westS);
            double east = Double.parseDouble(eastS);
            double south = Double.parseDouble(southS);
            double north = Double.parseDouble(northS);
            return new LatLonRect(LatLonPoint.create(south, east), LatLonPoint.create(north, west));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CalendarDateRange getTimeSpan(Document doc) {
        Element root = doc.getRootElement();
        Element timeSpan = root.getChild("TimeSpan");
        if (timeSpan == null) {
            return null;
        }
        String beginS = timeSpan.getChildText("begin");
        String endS = timeSpan.getChildText("end");
        if (beginS == null || endS == null) {
            return null;
        }
        try {
            CalendarDate start = CalendarDateFormatter.isoStringToCalendarDate(null, beginS);
            CalendarDate end = CalendarDateFormatter.isoStringToCalendarDate(null, endS);
            if (start == null || end == null) {
                return null;
            }
            CalendarDateRange dr = CalendarDateRange.of(start, end);
            return dr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CalendarDateUnit getTimeUnit(Document doc) {
        Element root = doc.getRootElement();
        Element timeUnitE = root.getChild("TimeUnit");
        if (timeUnitE == null) {
            return null;
        }
        String cal = timeUnitE.getAttributeValue("calendar");
        String timeUnitS = timeUnitE.getTextNormalize();
        try {
            return CalendarDateUnit.of(cal, timeUnitS);
        }
        catch (Exception e) {
            log.error("Illegal date unit {} in FeatureDatasetCapabilitiesXML", (Object)timeUnitS);
            return null;
        }
    }

    public static String getAltUnits(Document doc) {
        Element root = doc.getRootElement();
        String altUnits = root.getChildText("AltitudeUnits");
        if (altUnits == null || altUnits.isEmpty()) {
            return null;
        }
        return altUnits;
    }

    public static List<VariableSimpleIF> getDataVariables(Document doc) {
        Element root = doc.getRootElement();
        ArrayList<VariableSimpleIF> dataVars = new ArrayList<VariableSimpleIF>();
        List varElems = root.getChildren("variable");
        for (Element varElem : varElems) {
            dataVars.add(new VariableSimpleAdapter(varElem));
        }
        return dataVars;
    }

    private static class VariableSimpleAdapter
    implements VariableSimpleIF {
        String name;
        String desc;
        String units;
        DataType dt;
        List<Attribute> atts;

        VariableSimpleAdapter(Element velem) {
            this.name = velem.getAttributeValue("name");
            String type = velem.getAttributeValue("type");
            this.dt = DataType.getType(type);
            this.atts = new ArrayList<Attribute>();
            List attElems = velem.getChildren("attribute");
            for (Element attElem : attElems) {
                String attName = attElem.getAttributeValue("name");
                Array values2 = NcMLReader.readAttributeValues(attElem);
                this.atts.add(new Attribute(attName, values2));
            }
            for (Attribute att : this.atts) {
                if (att.getShortName().equals("units")) {
                    this.units = att.getStringValue();
                }
                if (att.getShortName().equals("long_name")) {
                    this.desc = att.getStringValue();
                }
                if (this.desc == null && att.getShortName().equals("description")) {
                    this.desc = att.getStringValue();
                }
                if (this.desc != null || !att.getShortName().equals("standard_name")) continue;
                this.desc = att.getStringValue();
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getFullName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getUnitsString() {
            return this.units;
        }

        @Override
        public int getRank() {
            return 0;
        }

        @Override
        public int[] getShape() {
            return new int[0];
        }

        @Override
        public List<Dimension> getDimensions() {
            return null;
        }

        @Override
        public DataType getDataType() {
            return this.dt;
        }

        @Override
        public List<Attribute> getAttributes() {
            return this.atts;
        }

        @Override
        public Attribute findAttributeIgnoreCase(String name) {
            for (Attribute att : this.atts) {
                if (!att.getShortName().equalsIgnoreCase(name)) continue;
                return att;
            }
            return null;
        }

        @Override
        public AttributeContainer attributes() {
            return new AttributeContainerMutable(this.name, this.atts).toImmutable();
        }

        @Override
        public int compareTo(VariableSimpleIF o) {
            return this.name.compareTo(o.getShortName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariableSimpleAdapter that = (VariableSimpleAdapter)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

