/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.EarthLocation;

public class WriterCFPointCollection
extends CFPointWriter {
    private int obsRecno;

    public WriterCFPointCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.point.name()));
        this.writer.addGroupAttribute(null, new Attribute("DSG_representation", "Point Data, H.1"));
    }

    public WriterCFPointCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, List<CoordinateAxis> coordVars, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, config, coordVars);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.point.name()));
        this.writer.addGroupAttribute(null, new Attribute("DSG_representation", "Point Data, H.1"));
    }

    public void writeHeader(PointFeature pf) throws IOException {
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        coords.add(VariableSimpleBuilder.makeScalar(pf.getFeatureCollection().getTimeName(), "time of measurement", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        coords.add(VariableSimpleBuilder.makeScalar("latitude", "latitude of measurement", "degrees_north", DataType.DOUBLE).build());
        coords.add(VariableSimpleBuilder.makeScalar("longitude", "longitude of measurement", "degrees_east", DataType.DOUBLE).build());
        Formatter coordNames = new Formatter().format("%s %s %s", pf.getFeatureCollection().getTimeName(), "latitude", "longitude");
        if (this.altUnits != null) {
            coords.add(VariableSimpleBuilder.makeScalar(pf.getFeatureCollection().getAltName(), "altitude of measurement", this.altUnits, DataType.DOUBLE).addAttribute("positive", CF1Convention.getZisPositive(pf.getFeatureCollection().getAltName(), this.altUnits)).build());
            coordNames.format(" %s", pf.getFeatureCollection().getAltName());
        }
        super.writeHeader(coords, null, pf.getDataAll(), coordNames.toString());
    }

    public void writeHeader(PointFeatureCollection pfc) throws IOException {
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        coords.add(VariableSimpleBuilder.makeScalar(pfc.getTimeName(), "time of measurement", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        coords.add(VariableSimpleBuilder.makeScalar("latitude", "latitude of measurement", "degrees_north", DataType.DOUBLE).build());
        coords.add(VariableSimpleBuilder.makeScalar("longitude", "longitude of measurement", "degrees_east", DataType.DOUBLE).build());
        if (this.altUnits != null) {
            coords.add(VariableSimpleBuilder.makeScalar(pfc.getAltName(), "altitude of measurement", this.altUnits, DataType.DOUBLE).addAttribute("positive", CF1Convention.getZisPositive(altName, this.altUnits)).build());
        }
        super.writeHeader((List<VariableSimpleIF>)coords, (List<? extends PointFeatureCollection>)Arrays.asList(pfc), (List<StructureData>)null, (List<StructureData>)null);
    }

    @Override
    protected void makeFeatureVariables(List<StructureData> featureData, boolean isExtended) {
    }

    public void writeRecord(PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(sobs.getFeatureCollection().getTimeName(), sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sobs.getFeatureCollection().getAltName(), sobs.getLocation(), sdata);
    }

    public void writeRecord(double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.writeRecord(timeName, timeCoordValue, obsDate, altName, loc, sdata);
    }

    private void writeRecord(String timeName, double timeCoordValue, CalendarDate obsDate, String altName, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(loc.getLatLon(), obsDate);
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar(timeName, null, null, DataType.DOUBLE, timeCoordValue);
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, loc.getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, loc.getLongitude());
        if (this.altUnits != null) {
            smb.addMemberScalar(altName, null, null, DataType.DOUBLE, loc.getAltitude());
        }
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, sdata));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

