/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.ft.point.writer2.WriterCFPointAbstract;
import ucar.nc2.time.CalendarDateUnit;

class WriterCFPointCollection
extends WriterCFPointAbstract {
    private int obsRecno;

    WriterCFPointCollection(String fileOut, AttributeContainer globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writerb.addAttribute(new Attribute("featureType", CF.FeatureType.point.name()));
        this.writerb.addAttribute(new Attribute("DSG_representation", "Point Data, H.1"));
    }

    void writeHeader(List<DsgFeatureCollection> featureCollections) throws IOException {
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        ArrayList<PointFeatureCollection> pointCollections = new ArrayList<PointFeatureCollection>();
        for (DsgFeatureCollection featureCollection : featureCollections) {
            pointCollections.add((PointFeatureCollection)featureCollection);
            coords.add(VariableSimpleBuilder.makeScalar(featureCollection.getTimeName(), "time of measurement", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
            if (this.altUnits == null) continue;
            this.altitudeCoordinateName = featureCollection.getAltName();
            coords.add(VariableSimpleBuilder.makeScalar(this.altitudeCoordinateName, "altitude of measurement", this.altUnits, DataType.DOUBLE).addAttribute("positive", CF1Convention.getZisPositive("altitude", this.altUnits)).build());
        }
        coords.add(VariableSimpleBuilder.makeScalar("latitude", "latitude of measurement", "degrees_north", DataType.DOUBLE).build());
        coords.add(VariableSimpleBuilder.makeScalar("longitude", "longitude of measurement", "degrees_east", DataType.DOUBLE).build());
        super.writeHeader(coords, pointCollections, null, null);
    }

    protected void writeRecord(PointFeature point) throws IOException {
        this.trackBB(point.getLocation().getLatLon(), point.getObservationTimeAsCalendarDate());
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar(point.getFeatureCollection().getTimeName(), null, null, DataType.DOUBLE, point.getObservationTime());
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, point.getLocation().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, point.getLocation().getLongitude());
        if (this.altUnits != null) {
            smb.addMemberScalar(point.getFeatureCollection().getAltName(), null, null, DataType.DOUBLE, point.getLocation().getAltitude());
        }
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, point.getFeatureData()));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }

    @Override
    void makeFeatureVariables(List<StructureData> featureData, boolean isExtended) {
    }
}

