/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.ExecutionException;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;

public class FileCacheGuava
implements FileCacheIF {
    private final String name;
    private LoadingCache<String, FileCacheable> cache;

    public FileCacheGuava(String name, int maxSize) {
        this.name = name;
        this.cache = CacheBuilder.newBuilder().maximumSize(maxSize).recordStats().build(new CacheLoader<String, FileCacheable>(){

            @Override
            public FileCacheable load(String key) {
                throw new IllegalStateException();
            }
        });
    }

    @Override
    public void enable() {
    }

    @Override
    public void disable() {
        this.clearCache(true);
        this.cache = null;
    }

    @Override
    public FileCacheable acquire(FileFactory factory2, DatasetUrl durl) {
        return this.acquire(factory2, durl.trueurl, durl, -1, null, null);
    }

    @Override
    public FileCacheable acquire(FileFactory factory2, Object hashKey, DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object spiObject) {
        if (null == hashKey) {
            hashKey = durl.trueurl;
        }
        if (null == hashKey) {
            throw new IllegalArgumentException();
        }
        try {
            return this.cache.get((String)hashKey, () -> factory2.open(durl, buffer_size, cancelTask, spiObject));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public boolean release(FileCacheable ncfile) {
        return false;
    }

    @Override
    public void eject(Object hashKey) {
    }

    @Override
    public void clearCache(boolean force) {
        this.cache.invalidateAll();
    }

    @Override
    public void resetTracking() {
    }

    @Override
    public void showTracking(Formatter format) {
    }

    @Override
    public void showCache(Formatter f) {
        CacheStats stats = this.cache.stats();
        f.format("%n%s%n%s%n", this.name, stats);
    }

    @Override
    public void showStats(Formatter f) {
        CacheStats stats = this.cache.stats();
        f.format("%s", stats);
    }

    @Override
    public List<String> showCache() {
        return null;
    }
}

