/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.tools.overlay;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.gui.util.FontUtil;
import icy.image.colormap.IcyColorMap;
import icy.image.lut.LUT;
import icy.math.MathUtil;
import icy.painter.Overlay;
import icy.preferences.GeneralPreferences;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.util.GraphicsUtil;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import javax.swing.JPanel;
import plugins.stef.tools.overlay.ColorBarSettingPanel;

public class ColorBarOverlay
extends Overlay
implements ColorBarSettingPanel.SettingChangeListener {
    protected ColorBarSettingPanel settingPanel;
    protected final XMLPreferences prefs;

    public ColorBarOverlay(final XMLPreferences prefs) {
        super("Color bar", Overlay.OverlayPriority.TEXT_LOW);
        this.prefs = prefs;
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                ColorBarOverlay.this.settingPanel = new ColorBarSettingPanel();
                if (prefs != null) {
                    ColorBarOverlay.this.settingPanel.setColorBarOffsetX(prefs.getDouble("offsetX", 0.0));
                    ColorBarOverlay.this.settingPanel.setColorBarOffsetY(prefs.getDouble("offsetY", 0.0));
                    ColorBarOverlay.this.settingPanel.setColorBarScale(prefs.getDouble("scale", 1.0));
                    ColorBarOverlay.this.settingPanel.setPosition(ColorBarPosition.values()[prefs.getInt("position", ColorBarPosition.RIGHT.ordinal())]);
                    ColorBarOverlay.this.settingPanel.setDisplayMinMax(prefs.getBoolean("displayMinMax", false));
                }
            }
        });
        this.settingPanel.addSettingChangeListener(this);
    }

    public JPanel getOptionsPanel() {
        return this.settingPanel;
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        LUT lut;
        if (g != null && canvas instanceof IcyCanvas2D && (lut = canvas.getLut()) != null) {
            double y;
            double x;
            double h;
            double w;
            double offsetXd = this.getColorBarOffsetX();
            double offsetYd = this.getColorBarOffsetY();
            double scale = this.getColorBarScale();
            ColorBarPosition position = this.getPosition();
            boolean displayMinMax = this.getDisplayMinMax();
            IcyCanvas2D cnv2d = (IcyCanvas2D)canvas;
            Graphics2D g2 = (Graphics2D)g.create();
            int numChannel = lut.getNumChannel();
            g2.transform(cnv2d.getInverseTransform());
            Rectangle region = new Rectangle(0, 0, cnv2d.getCanvasSizeX(), cnv2d.getCanvasSizeY());
            int offsetX = (int)((double)cnv2d.getCanvasSizeX() / 2.0 * offsetXd);
            int offsetY = (int)((double)cnv2d.getCanvasSizeY() / 2.0 * offsetYd);
            switch (position) {
                case BOTTOM: 
                case TOP: {
                    w = Math.max(region.width / 2, 80);
                    h = Math.min(Math.max(region.height / 20, 10), 48);
                    h *= scale;
                    x = region.x;
                    x += (double)region.width / 2.0 - (w *= scale) / 2.0;
                    x += (double)offsetX;
                    if (position == ColorBarPosition.BOTTOM) {
                        y = region.y + region.height;
                        y -= h * (double)(1 + numChannel);
                    } else {
                        y = region.y;
                        y += h;
                    }
                    y += (double)offsetY;
                    break;
                }
                default: {
                    w = Math.min(Math.max(region.width / 20, 10), 48);
                    h = Math.max(region.height / 2, 80);
                    w *= scale;
                    h *= scale;
                    if (position == ColorBarPosition.RIGHT) {
                        x = region.x + region.width;
                        x -= w * (double)(1 + numChannel);
                    } else {
                        x = region.x;
                        x += w;
                    }
                    x += (double)offsetX;
                    y = region.y;
                    y += (double)region.height / 2.0 - h / 2.0;
                    y += (double)offsetY;
                }
            }
            int xi = (int)Math.round(x);
            int yi = (int)Math.round(y);
            int wi = (int)Math.round(w);
            int hi = (int)Math.round(h);
            switch (position) {
                case BOTTOM: 
                case TOP: {
                    double ratio = 255.0 / (double)(wi - 1);
                    for (int c = 0; c < numChannel; ++c) {
                        LUT.LUTChannel lutChannel = lut.getLutChannel(c);
                        IcyColorMap colorMap = lutChannel.getColorMap();
                        g2.setColor(Color.white);
                        g2.fillRect(xi, yi, wi + 2, hi + 1);
                        for (int i = 0; i < (int)w; ++i) {
                            int colorInd = (int)Math.round((double)i * ratio);
                            g2.setColor(colorMap.getColor(Math.min(255, Math.max(0, colorInd))));
                            g2.fillRect(xi + 1 + i, yi + 1, 1, hi - 1);
                        }
                        if (displayMinMax) {
                            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                            g2.setColor(colorMap.getDominantColor());
                            Font font = FontUtil.setSize((Font)g2.getFont(), (int)GeneralPreferences.getGuiFontSize());
                            g2.setFont(font);
                            String text = StringUtil.toString((double)MathUtil.round((double)lut.getLutChannel(c).getMin(), (int)2));
                            Rectangle2D textBnd = GraphicsUtil.getStringBounds((Graphics)g2, (String)text);
                            GraphicsUtil.drawString((Graphics)g2, (String)text, (int)(xi - (int)(textBnd.getWidth() + 8.0)), (int)(yi + (hi - (int)textBnd.getHeight()) / 2), (boolean)true);
                            text = StringUtil.toString((double)MathUtil.round((double)lut.getLutChannel(c).getMax(), (int)2));
                            textBnd = GraphicsUtil.getStringBounds((Graphics)g2, (String)text);
                            GraphicsUtil.drawString((Graphics)g2, (String)text, (int)(xi + wi + 8), (int)(yi + (hi - (int)textBnd.getHeight()) / 2), (boolean)true);
                        }
                        yi += hi;
                    }
                    break;
                }
                default: {
                    double ratio = 255.0 / (double)(hi - 1);
                    for (int c = 0; c < numChannel; ++c) {
                        IcyColorMap colorMap = lut.getLutChannel(c).getColorMap();
                        g2.setColor(Color.white);
                        g2.fillRect(xi, yi, wi + 1, hi + 2);
                        for (int i = 0; i < hi; ++i) {
                            int colorInd = (int)Math.round((double)(hi - 1 - i) * ratio);
                            g2.setColor(colorMap.getColor(Math.min(255, Math.max(0, colorInd))));
                            g2.fillRect(xi + 1, yi + 1 + i, wi - 1, 1);
                        }
                        if (displayMinMax) {
                            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                            g2.setColor(colorMap.getDominantColor());
                            Font font = FontUtil.setSize((Font)g2.getFont(), (int)GeneralPreferences.getGuiFontSize());
                            g2.setFont(font);
                            String text = StringUtil.toString((double)MathUtil.round((double)lut.getLutChannel(c).getMin(), (int)2));
                            Rectangle2D textBnd = GraphicsUtil.getStringBounds((Graphics)g2, (String)text);
                            GraphicsUtil.drawString((Graphics)g2, (String)text, (int)(xi + (wi - (int)textBnd.getWidth()) / 2), (int)(yi + hi + 5), (boolean)true);
                            text = StringUtil.toString((double)MathUtil.round((double)lut.getLutChannel(c).getMax(), (int)2));
                            textBnd = GraphicsUtil.getStringBounds((Graphics)g2, (String)text);
                            GraphicsUtil.drawString((Graphics)g2, (String)text, (int)(xi + (wi - (int)textBnd.getWidth()) / 2), (int)(yi - (int)(textBnd.getHeight() + 4.0)), (boolean)true);
                        }
                        xi += wi;
                    }
                }
            }
            g2.dispose();
        }
    }

    public boolean getDisplayMinMax() {
        return this.settingPanel.getDisplayMinMax();
    }

    public void setDisplayMinMax(boolean value) {
        this.settingPanel.setDisplayMinMax(value);
    }

    public double getColorBarOffsetX() {
        return this.settingPanel.getColorBarOffsetX();
    }

    public void setColorBarOffsetX(double value) {
        this.settingPanel.setColorBarOffsetX(value);
    }

    public double getColorBarOffsetY() {
        return this.settingPanel.getColorBarOffsetY();
    }

    public void setColorBarOffsetY(double value) {
        this.settingPanel.setColorBarOffsetY(value);
    }

    public double getColorBarScale() {
        return this.settingPanel.getColorBarScale();
    }

    public void setColorBarScale(double value) {
        this.settingPanel.setColorBarScale(value);
    }

    public ColorBarPosition getPosition() {
        return this.settingPanel.getPosition();
    }

    public void setPosition(ColorBarPosition value) {
        this.settingPanel.setPosition(value);
    }

    @Override
    public void settingChange(PropertyChangeEvent event) {
        if (this.prefs != null) {
            String propertyName = event.getPropertyName();
            Object value = event.getNewValue();
            switch (propertyName) {
                case "displayMinMax": {
                    this.prefs.putBoolean("displayMinMax", ((Boolean)value).booleanValue());
                    break;
                }
                case "offsetX": {
                    this.prefs.putDouble("offsetX", ((Double)value).doubleValue());
                    break;
                }
                case "offsetY": {
                    this.prefs.putDouble("offsetY", ((Double)value).doubleValue());
                    break;
                }
                case "position": {
                    this.prefs.putInt("position", ((ColorBarPosition)((Object)value)).ordinal());
                    break;
                }
                case "scale": {
                    this.prefs.putDouble("scale", ((Double)value).doubleValue());
                }
            }
        }
        this.painterChanged();
    }

    public static enum ColorBarPosition {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

