package plugins.fab.trackmanager.processors;

import icy.main.Icy;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;

import java.awt.Color;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;

import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

/**
 * 
 * @author Fabrice de Chaumont
 *
 * WARNING: BETA Version
 */
public class TrackProcessorROIGate extends PluginTrackManagerProcessor implements ActionListener, SequenceListener { 
	
	String[] colorStrings = { "All colors", "red","orange","yellow","green","blue","pink","white","gray","black" };	
	
	JComboBox roiColor = new JComboBox( colorStrings );
	JCheckBox onlyUseSelectedROICheckBox = new JCheckBox("Only use current selected ROIs", false );
	Color currentSelectedColor = null;
	
	public TrackProcessorROIGate( ) {
		setName("TrackProcessor - Gate (show tracks wich have a detection in current ROI)");
		
		//trackPool.getSequence().addROIChangeListener( this );
//	    panel.add( roiColor );
		panel.add( onlyUseSelectedROICheckBox );
		onlyUseSelectedROICheckBox.addActionListener( this );
//		roiColor.addActionListener( this );				
	}

//	boolean firstStartTest = true;
	
	@Override
	public void Compute() {
		
		if ( trackPool.getDisplaySequence() == null )
			return;
		
		trackPool.getDisplaySequence().removeListener( this );
		
		Sequence displaySequence = trackPool.getDisplaySequence();
		if ( displaySequence != null )
		{
			trackPool.getDisplaySequence().addListener( this );
		}
		
		if ( trackPool.getDisplaySequence() == null ) return;
		
		if ( trackPool.getDisplaySequence().getROIs().size() == 0 ) return;
		
		ArrayList<ROI2D> roiList = new ArrayList<ROI2D>( trackPool.getDisplaySequence().getROI2Ds() );
		if ( onlyUseSelectedROICheckBox.isSelected() )
		{
			for ( int i = roiList.size()-1 ; i >= 0 ; i-- )
			{
				if ( !roiList.get( i).isSelected() )
				{
					roiList.remove( i );
				}
			}
		}
		
		if ( isEnabled() )
		{
			// tracks
			for ( TrackSegment ts : trackPool.getTrackSegmentList() )
			{
				// detections in tracks
				
				boolean isAnyDetectionOftheTrackInROI = false;
				
				for ( Detection d : ts.getDetectionList() )
				if ( d.isEnabled() )
				{						
						// detection is in roi ?
						//for ( int roiindex = 0 ; roiindex < trackPool.getDisplaySequence().getROIs().size() ; roiindex++ )
					//for ( ROI2D roi2d : trackPool.getDisplaySequence().getROI2Ds() )
					for ( ROI2D roi2d : roiList )
						{
						
//							Shape shape = (Shape) trackPool.getDisplaySequence().getROIs().get( roiindex );
//							ROI roi = trackPool.getDisplaySequence().getROIs().get( roiindex );
														
								if ( roi2d.getColor() == currentSelectedColor || currentSelectedColor == null )
								{
									
									if ( roi2d.contains( d.getX() , d.getY() ) )
									{
										isAnyDetectionOftheTrackInROI = true;
										//ts.setAllDetectionEnabled( true );
										break;										
									}
									
								}
							
						}
					
				}
				if ( isAnyDetectionOftheTrackInROI == false )
				{
					ts.setAllDetectionEnabled( false );					
				}
			}
		}
		
	}

	public void actionPerformed(ActionEvent e) {
				
//		switch ( roiColor.getSelectedIndex() )
//		{
//			case 0: currentSelectedColor = null; break;
//			case 1: currentSelectedColor = Color.red; break;
//			case 2: currentSelectedColor = Color.orange; break;
//			case 3: currentSelectedColor = Color.yellow; break;
//			case 4: currentSelectedColor = Color.green; break;
//			case 5: currentSelectedColor = Color.blue; break;
//			case 6: currentSelectedColor = Color.pink; break;
//			case 7: currentSelectedColor = Color.white; break;
//			case 8: currentSelectedColor = Color.gray; break;
//			case 9: currentSelectedColor = Color.black; break;
//		}

		trackPool.fireTrackEditorProcessorChange();

	}

//	public void ROIChanged(ROIChangeEvent ROIe) {
//		trackPool.fireTrackEditorProcessorChange();
//	}

	@Override
	public void Close() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void displaySequenceChanged() {

		for ( Sequence sequence : Icy.getMainInterface().getSequences() )
		{
			sequence.removeListener( this );			
		}
		Sequence displaySequence = trackPool.getDisplaySequence();
		if ( displaySequence !=null )
		{
			trackPool.getDisplaySequence().addListener( this );
		}
	}

	@Override
	public void sequenceChanged(SequenceEvent sequenceEvent) {
		
		if ( sequenceEvent.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI )
		{
			//System.out.println("update ! roi");
			trackPool.fireTrackEditorProcessorChange();
		}
		// TODO Auto-generated method stub
		
	}

	@Override
	public void sequenceClosed(Sequence sequence) {
		// TODO Auto-generated method stub

	}	


	
	
}
