package plugins.tprovoost.note;

import icy.file.xml.XMLPersistent;
import icy.painter.Anchor2D;
import icy.sequence.Sequence;
import icy.util.XMLUtil;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

import org.w3c.dom.Node;

public class Note implements XMLPersistent {

	// VARIABLES
	private String text = "";
	private Anchor2D anchor = null;
	private Font font = new Font("Arial", Font.PLAIN, 12);
	private Color color = Color.BLACK;
	Rectangle boundingRect = new Rectangle(0, 0, 0, 0);
	Sequence attachedSequence;

	// PREFERENCES
	private static String PREF_TEXT = "text";
	private static String PREF_ANCHOR_X = "x";
	private static String PREF_ANCHOR_Y = "y";
	private static String PREF_COLOR = "color";
	private static String PREF_FONT_NAME = "fontName";
	private static String PREF_FONT_STYLE = "fontStyle";
	private static String PREF_FONT_SIZE = "fontSize";

	public Note(Sequence attachedSequence) {
		this.attachedSequence = attachedSequence;
	}

	public Note(Sequence attachedSequence, String text) {
		this.attachedSequence = attachedSequence;
		this.text = text;
	}

	public Note(Sequence attachedSequence, String text, Anchor2D anchor) {
		this.attachedSequence = attachedSequence;
		this.text = text;
		setAnchor(anchor);
	}

	public void setText(String text) {
		this.text = text;
	}

	public void setAnchor(Anchor2D anchor) {
		this.anchor = anchor;
	}

	public Anchor2D getAnchor() {
		return anchor;
	}

	public String getText() {
		return text;
	}

	public void setFont(Font font) {
		if (font != null)
			this.font = font;
	}

	public void refreshROI() {
		if (anchor != null)
			anchor.changed();
	}

	public void setColor(Color color) {
		if (color != null)
			this.color = color;
		else
			this.color = Color.BLACK;
	}

	public Font getFont() {
		return font;
	}

	public Color getColor() {
		return color;
	}

	/**
	 * Creates a layer containing the note at the specific location
	 * 
	 * @param text
	 *            : Text to be displayed.
	 * @param s
	 *            : Sequence that will contain the text.
	 * @param x
	 *            : x coordinate of anchor point
	 * @param y
	 *            : y coordinate of anchor point
	 * @param f
	 *            : Font used for the text.
	 * @param color
	 *            : Color used for the text.
	 */
	public static void createNote(String text, Sequence s, double x, double y, Font f, Color color) {
		createNote(text, s, x, y, f, color, null);
	}

	/**
	 * Add a note containing the text at the specific location in the
	 * PainterNotes given as parameter. If null, creates a new painter.
	 * 
	 * @param text
	 *            : Text to be displayed.
	 * @param seq
	 *            : Sequence that will contain the text.
	 * @param x
	 *            : x coordinate of anchor point
	 * @param y
	 *            : y coordinate of anchor point
	 * @param f
	 *            : Font used for the text.
	 * @param color
	 *            : Color used for the text.
	 * @param pn
	 *            : Note will be added to this painter. If null, a painter is
	 *            created.
	 */
	public static void createNote(String text, Sequence seq, double x, double y, Font f, Color color, PainterNotes pn) {
		Note note = new Note(seq, text, new Anchor2D(new Point2D.Double(x, y)));
		note.setFont(f);
		note.setColor(color);
		if (pn == null) {
			pn = new PainterNotes();
			seq.addPainter(pn);
			AnnotationFrame.renamePainter(pn, "Painter Note");
		}
		pn.addNote(note);
	}

	@Override
	public boolean loadFromXML(Node node) {
		if (node == null)
			return false;

		anchor = new Anchor2D();
		text = XMLUtil.getElementValue(node, PREF_TEXT, "Error");
		anchor.setX(XMLUtil.getElementDoubleValue(node, PREF_ANCHOR_X, 0));
		anchor.setY(XMLUtil.getElementDoubleValue(node, PREF_ANCHOR_Y, 0));
		color = new Color(XMLUtil.getElementIntValue(node, PREF_COLOR, 0));
		String fontName = XMLUtil.getElementValue(node, PREF_FONT_NAME, "Arial");
		int fontStyle = XMLUtil.getElementIntValue(node, PREF_FONT_STYLE, Font.PLAIN);
		int fontSize = XMLUtil.getElementIntValue(node, PREF_FONT_SIZE, 12);
		setFont(new Font(fontName, fontStyle, fontSize));

		AnnotationFrame.getAnnotationFrame();

		if (text.equals("Error"))
			return false;

		return true;
	}

	@Override
	public boolean saveToXML(Node node) {
		if (node == null)
			return false;

		XMLUtil.setElementValue(node, PREF_TEXT, text);
		XMLUtil.setElementDoubleValue(node, PREF_ANCHOR_X, anchor.getX());
		XMLUtil.setElementDoubleValue(node, PREF_ANCHOR_Y, anchor.getY());
		XMLUtil.setElementIntValue(node, PREF_COLOR, color.getRGB());
		XMLUtil.setElementValue(node, PREF_FONT_NAME, font.getFontName());
		XMLUtil.setElementIntValue(node, PREF_FONT_STYLE, font.getStyle());
		XMLUtil.setElementIntValue(node, PREF_FONT_SIZE, font.getSize());

		return true;
	}

	@Override
	public String toString() {
		return "[text=" + text + ",pos=(" + anchor.getX() + "," + anchor.getY() + ")]";
	}
}
