package plugins.vannary.morphomaths;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import icy.file.FileUtil;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.collection.array.Array1DUtil;
import jxl.Workbook;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;


public class AnalyzeSkeleton extends EzPlug implements Block {

	private EzVarSequence in = new EzVarSequence ("Sequence in ");
	
	private EzVarFile fileXls = new EzVarFile ("Xls File", FileUtil.getApplicationDirectory());
	private EzVarSequence out = new EzVarSequence("Sequence out");
	private EzVarInteger ezMeltingAngle = new EzVarInteger("melting angle", 0, 180, 1);
	private EzVarBoolean drawROI = new EzVarBoolean("draw ROI", false);
	private Sequence seq;

	@Override
	protected void initialize() {
		super.addEzComponent(this.in);
		super.addEzComponent(fileXls);
		super.addEzComponent(ezMeltingAngle);
		super.addEzComponent(drawROI);
	}

	@Override
	protected void execute() {
		seq=SequenceUtil.getCopy(in.getValue());
		ArrayList<Edge> edges = null;
		if (seq.getSizeZ()>1) {
			edges = analyzeSkeleton3D(seq);
		} else {
			edges =	analyzeSkeleton(seq, 0);
		}
		addSequence(seq);

		if (drawROI.getValue()) drawROIOnEdges(edges);
		
		if (fileXls.getValue()!=null) {
			
			//System.out.println(" Not yet implemented");
			saveResult2ExcelAurel(fileXls.getValue().getPath(), edges);
		}
	}

	@Override
	public void clean() {

	}

	@Override
	public void declareInput(VarList inputMap) {
		inputMap.add(in.name, in.getVariable());
		inputMap.add(fileXls.name, fileXls.getVariable());
		inputMap.add(ezMeltingAngle.name, ezMeltingAngle.getVariable());
		inputMap.add(drawROI.name, drawROI.getVariable());
	}

	@Override
	public void declareOutput(VarList outputMap) {
		outputMap.add(out.name, out.getVariable());
	}
	
	private double getTabVal(double[] tab, int x, int y, int nc, int nr) {

		if (x < 0 || x >= nc || y < 0 || y >= nr)
			return (0);
		else {
 			double d =(tab[x + nc * y]);
			return d;
		}
	}

	private void setTabVal(double[] tab, int x, int y, double d, int nc, int nr) {
		if (x >= 0 && x < nc && y >= 0 && y < nr)
			tab[x + nc * y] = d;
	}

	private double getTabVal3D(double[][] tab, int x, int y,int z, int nc, int nr, int nz) {
		if (x < 0 || x >= nc || y < 0 || y >= nr || z < 0 || z >= nz)
			return (0);
		else
			return (tab[x + nc * y][z]);
	}

	private void setTabVal3D(double[][] tab, int x, int y,int z,double d, int nc, int nr, int nz) {
		if (x >= 0 && x < nc && y >= 0 && y < nr && z >=  0 && z < nz)
			tab[x + nc * y][z] = d;
	}

	public int getNbNeighbors (double[] tab, int i, int j, int width, int height) {
		int nbNeighbors = 0;
		for (int l = j - 1; l <= j + 1; l++ ) {
			for (int k = i - 1; k <= i + 1; k++) {
				if (!(l==j && k==i)) {
					if (getTabVal(tab,k,l,width, height)== 1) {
						nbNeighbors++;
					}
				}
			}
		}
		return nbNeighbors;
	}

	public ArrayList<Point3DEdge> getNeighbors (double[]tab, int i, int j, int z, int width, int height) {
		ArrayList<Point3DEdge> list = new ArrayList<Point3DEdge>();
		for (int l = j - 1; l <= j + 1; l++ ) {
			for (int k = i - 1; k <= i + 1; k++) {
				if (!(l==j && k==i)) {
					if (getTabVal(tab,k,l,width, height)== 1) {
						list.add(new Point3DEdge(k,l,z));
						//setTabVal(tab, k, l, 2, width, height);
					}
				}
			}
		}
		return list;
	}

	public void groupEdges (ArrayList<Edge> edges) {
		double angle=0;
		double angleMax;
		Point3DEdge pRemove;
		Edge listToMerge;
		double meltingAngle = this.ezMeltingAngle.getValue();
		int i = 0;
		int j ;
		boolean invert = false;
		Point3DEdge vertex1=null;
		Point3DEdge vertex2=null;
		while (i< edges.size()) { 
			
			j = i +1;
			pRemove=null;
			listToMerge=null;
			angleMax = 0;
			if (Distancebetween2Point3D(edges.get(i).getVertex1(), edges.get(i).getVertex2()) < 2) {
				i++;
				continue;
			}
			while (j < edges.size()) {
				if (Distancebetween2Point3D(edges.get(j).getVertex1(), edges.get(j).getVertex2()) < 2) {
					j++;
					continue;
				}
				if (samePoint3D(edges.get(i).getVertex1(),edges.get(j).getVertex1())) {
					angle = angleCalculator(edges.get(i).getVertex1(), edges.get(i).getVertex2(), edges.get(j).getVertex2());
					if (angle >= meltingAngle && angle >= angleMax) {
						angleMax = angle;
						listToMerge = edges.get(j);
						pRemove = listToMerge.getVertex1();
						invert=true;
						vertex1 = edges.get(i).getVertex2();
						vertex2 = edges.get(j).getVertex2();
					}
												
				}
				
				if (samePoint3D(edges.get(i).getVertex1(), edges.get(j).getVertex2())) {
					angle = angleCalculator(edges.get(i).getVertex1(), edges.get(i).getVertex2(), edges.get(j).getVertex1());
					if (angle >= meltingAngle && angle >= angleMax) {
						angleMax = angle;
						listToMerge = edges.get(j);
						pRemove = listToMerge.getVertex2();
						invert = false;
						vertex1 = edges.get(i).getVertex2();
						vertex2 = edges.get(j).getVertex1();
					}
				}
				

				if (samePoint3D(edges.get(i).getVertex2(),edges.get(j).getVertex1())) {
					angle = angleCalculator(edges.get(i).getVertex2(), edges.get(i).getVertex1(), edges.get(j).getVertex2());
					if (angle >= meltingAngle && angle >= angleMax) {
						angleMax = angle;
						listToMerge = edges.get(j);
						pRemove = listToMerge.getVertex1();
						invert = false;
						vertex1 = edges.get(i).getVertex1();
						vertex2 = edges.get(j).getVertex2();
						edges.get(i).invertEdge();
						
					}
				}
				if (samePoint3D(edges.get(i).getVertex2(),edges.get(j).getVertex2())) {
					angle = angleCalculator(edges.get(i).getVertex2(), edges.get(i).getVertex1(), edges.get(j).getVertex1());
					if (angle >= meltingAngle && angle >= angleMax){
						angleMax = angle;
						listToMerge = edges.get(j);
						pRemove = listToMerge.getVertex2();
						invert = true;
						vertex1 = edges.get(i).getVertex1();
						vertex2 = edges.get(j).getVertex1();
					}
				}
				j++;
			}
			if (listToMerge != null) {
				listToMerge.removePoint3DFromList(pRemove);
				edges.get(i).setVertex1(vertex1);
				edges.get(i).setVertex2(vertex2);
				edges.get(i).fuseEdges(listToMerge, invert);
				//edges.get(i).AddAllPoint3D(listToMerge);
				edges.remove(listToMerge);
				i = 0;
				continue;
			}
			i++;
		}
	}
	
	public ArrayList<Edge> analyzeSkeleton (Sequence seq, int z) {
		int t = 0;
		int width = seq.getWidth();
		int height = seq.getHeight();
		IcyBufferedImage img = seq.getImage(t, z);
		ArrayList<Edge> edges = new ArrayList<Edge>();
		double[] tabDouble = Array1DUtil.arrayToDoubleArray(img.getDataXY(0), img.isSignedDataType());
		LinkedList<Point3DEdge> fifo = new LinkedList<Point3DEdge>();
		for (int j = 0; j < height; j++) {
			for (int i = 0; i < width; i++) {
				if (tabDouble[i + j * width] != 0) {
					tabDouble[i+j*width] = 1;
				}
			}
		}
		
		int co = 3; //nb Cc from value 3
		Point3DEdge v1, v2;
		for (int j = 0; j < height; j++) {
			for (int i = 0; i < width; i++) {
				if ((getTabVal(tabDouble, i, j, width, height)==1) && getNbNeighbors(tabDouble, i, j, width, height)==1) {
					fifo.add(new Point3DEdge(i,j,z));
					while (!fifo.isEmpty()) {
						v1 = fifo.poll();
						ArrayList<Point3DEdge> list = new ArrayList<Point3DEdge>();
						list.add(v1);
						int k = (int)v1.getX();
						int l = (int)v1.getY();
						int nbNeighbors = getNbNeighbors(tabDouble, k, l,  width, height);
						setTabVal(tabDouble, k, l, 2, width, height);
						if (nbNeighbors==0) {
							continue;
						}
						Point3DEdge p = getNeighbors(tabDouble, k, l, z, width, height).get(0);
						k = (int)p.getX();
						l = (int)p.getY();
						while ( nbNeighbors==1) { // ajout des points du edge
							setTabVal(tabDouble, k, l, co, width, height);
							list.add(new Point3DEdge(k, l,z));
							p = getNeighbors(tabDouble, k, l, z, width, height).get(0);
							k = (int)p.getX();
							l = (int)p.getY();
							nbNeighbors = getNbNeighbors(tabDouble, k, l,  width, height);
						}

						setTabVal(tabDouble, k, l, 2, width, height);
						v2 = new Point3DEdge(k,l,z);
						
						list.add(v2);
						Edge e = new Edge(v1, v2, list);
						edges.add(e);
						for (int n = 0; n < nbNeighbors; n++) {
							fifo.add(new Point3DEdge(k,l,z));
						}
						//if (getNbNeighbors(tabDouble, k, l, width, height)>1) 
							//fifo.addAll(getNeighbors(tabDouble, k, l, z, width, height));
						co++;
					}					
				}
			}
		}		
		img.setDataXY(0, Array1DUtil.doubleArrayToArray(tabDouble, img.getDataXY(0)));	
		seq.setName(seq.getName()+ "_AnalyzeSkeleton");
		return edges;
	}

	public int getNbNeighbors3D (double[][] tab, int i, int j, int z, int width, int height, int depth) {
		int nbNeighbors = 0;
		for (int m = z - 1; m <= z + 1; m ++) {
			for (int l = j - 1; l <= j + 1; l++ ) {
				for (int k = i - 1; k <= i + 1; k++) {
					if (!(l==j && k==i && m == z)) {
						if (getTabVal3D(tab, k, l, m ,width ,height, depth)== 1) {
							nbNeighbors++;
						}
					}
				}
			}
		}
		return nbNeighbors;
	}

	public ArrayList<Point3DEdge> getNeighbors3D (double[][]tab, int i, int j, int z, int width, int height, int depth) {
		ArrayList<Point3DEdge> list = new ArrayList<Point3DEdge>();
		for (int m = z - 1; m <= z + 1; m ++) {
			for (int l = j - 1; l <= j + 1; l++ ) {
				for (int k = i - 1; k <= i + 1; k++) {
					if (!(l==j && k==i && m == z)) {						
						if (getTabVal3D(tab, k, l,m ,width ,height, depth)== 1) {
							list.add(new Point3DEdge(k,l,m));
							//setTabVal3D(tab, k, l, m, 2, width, height, depth);
						}
					}
				}
			}
		}
		return list;
	}

	public ArrayList<Edge> analyzeSkeleton3D (Sequence seq) {
		int t = 0;
		int width = seq.getWidth();
		int height = seq.getHeight();
		int depth = seq.getSizeZ();
		double[][] tabDouble = new double[width*height][depth];
		for (int z = 0 ; z < depth ; z++) {
			IcyBufferedImage img = seq.getImage(t, z);
			double [] tab = Array1DUtil.arrayToDoubleArray(img.getDataXY(0), img.isSignedDataType());
			for (int i = 0; i < tab.length; i ++) {
				tabDouble[i][z] = tab[i];
			}
		}
		
		ArrayList<Edge> edges = new ArrayList<Edge>();
		LinkedList<Point3DEdge> fifo = new LinkedList<Point3DEdge>();
		for (int z = 0; z < depth; z++) {
			for (int j = 0; j < height; j++) {
				for (int i = 0; i < width; i++) {
					if (tabDouble[i + j * width][z] != 0) {
						tabDouble[i+j*width][z] = 1;
					}
				}
			}
		}
		int co = 3;
		Point3DEdge v1, v2;
		for (int z = 0; z < depth; z++) {
			for (int j = 0; j < height; j++) {
				for (int i = 0; i < width; i++) {
					if ((getTabVal3D(tabDouble, i, j, z, width, height, depth)==1) && getNbNeighbors3D(tabDouble, i, j, z, width, height, depth)==1) {
						fifo.add(new Point3DEdge(i, j, z));
						while (!fifo.isEmpty()) {
							v1 = fifo.poll();
							ArrayList<Point3DEdge> list = new ArrayList<Point3DEdge>();
							list.add(v1);
							int k = (int)v1.getX();
							int l = (int)v1.getY();
							int m = (int)v1.getZ();
							setTabVal3D(tabDouble, k, l, m, 2, width, height, depth);
							if (getNbNeighbors3D(tabDouble, k, l, m, width, height, depth)==0) {
								//v2 = new Point3DEdge.Integer(k, l, m);
								//list.add(v2);
								//Edge e = new Edge(v1, v2, list);
								//edges.add(e);
								//co++;
								continue;
							}
							Point3DEdge p = getNeighbors3D(tabDouble, k, l, m, width, height, depth).get(0);
							k = (int)p.getX();
							l = (int)p.getY();
							m = (int)p.getZ();
							
							while (getNbNeighbors3D(tabDouble, k, l, m, width, height, depth)==1) {
								setTabVal3D(tabDouble, k, l, m, co, width, height, depth);
								list.add(new Point3DEdge(k, l, m));
								p = getNeighbors3D(tabDouble, k, l, m, width, height, depth).get(0);
								k = (int)p.getX();
								l = (int)p.getY();
								m = (int)p.getZ();
							}

							setTabVal3D(tabDouble, k, l, m, 2, width, height, depth);
							v2 = new Point3DEdge(k, l, m);
							
							list.add(v2);
							Edge e = new Edge(v1, v2, list);
							edges.add(e);
							for (int n = 0; n < getNbNeighbors3D(tabDouble, k, l,m, width, height,depth); n++) {
								fifo.add(new Point3DEdge(k,l,m));
							}
							
							co++;
						}					
					}
				}
			}		
		}
		for (int z =0; z < depth; z ++) {
			IcyBufferedImage img =  seq.getImage(t, z);
			double[] tab = new double[tabDouble.length];
			for (int i=0;i<tabDouble.length;i++) {
				tab[i]=tabDouble[i][z];
			}
			img.setDataXY(0, Array1DUtil.doubleArrayToArray(tab, img.getDataXY(0)));	
		}
		return edges;
	}
	

	public String VertexInformation (Point3DEdge p) {
		return ("Point3DEdge[x="+p.getX()+", y="+p.getY()+ ", z="+p.getZ()+"]");
	}

	public double Distancebetween2Point3D (Point3DEdge a, Point3DEdge b) {
		return Math.sqrt((b.getX() - a.getX())*(b.getX() - a.getX()) 
				+ (b.getY() - a.getY())*(b.getY() - a.getY()) 
				+ (b.getZ() - a.getZ())*(b.getZ() - a.getZ()));
	}

	public double realDistancebetween2Point3D (List<Point3DEdge> list) {
		double dr=0;
		int j = 1;
		for (int i = 0; i < list.size(); i ++, j++) {
			if (j<list.size()) {
				dr += Distancebetween2Point3D(list.get(i), list.get(j));
				//System.out.print(i+ " x: "+list.get(i).getX()+ " y: "+list.get(i).getY()+ " z: "+list.get(i).getZ());
				//System.out.println(" "+j+ " x: "+list.get(j).getX()+ " y: "+list.get(j).getY()+ " z: "+list.get(j).getZ());
			}
		}
		return dr;
	}

	

	public double angleCalculator (Point3DEdge p, Point3DEdge p1, Point3DEdge p2) {
		double x1 = (p1.getX() - p.getX());
		double y1 = (p1.getY() - p.getY());
		double z1 = (p1.getZ() - p.getZ());

		double x2 = (p2.getX() - p.getX());
		double y2 = (p2.getY() - p.getY());
		double z2 = (p2.getZ() - p.getZ());
		
		double scalarProduct = x1*x2 + y1*y2 + z1*z2;
		
		double magnitude1 = Distancebetween2Point3D(p, p1);
		double magnitude2 = Distancebetween2Point3D(p,p2);
		if (magnitude1==0 || magnitude2 == 0) return -1;
		return Math.toDegrees(Math.acos(scalarProduct/(magnitude1*magnitude2)));
	}

	public void drawROIOnEdges (List<Edge> edges) {
		for (Edge e : edges) {
			
			ROI2DLine roi = new ROI2DLine(e.getVertex1().getX(), e.getVertex1().getY(), e.getVertex2().getX(), e.getVertex2().getY());
			roi.setReadOnly(false);
			this.seq.addROI(roi);
		}
	}

	public boolean samePoint3D (Point3DEdge p1, Point3DEdge p2) {
		if (p1.getX() == p2.getX() 
			&& p1.getY() == p2.getY()
			&& p1.getZ() == p2.getZ()) return true;
		return false;
	}
	
	public int indexOfPoint3D (List<Point3DEdge> list, Point3DEdge p) {
		for (int i = 0; i < list.size(); i ++) {
			if (samePoint3D(list.get(i), p)) return i;
		}
		return -1;
	}
	
	// Save for Claire
	public void saveResult2Excel (String path, ArrayList<Edge> edges) {
		try {
			WritableWorkbook pageresultat;
			pageresultat = Workbook.createWorkbook(new File( path ));

			WritableSheet page = pageresultat.createSheet("RESULT ", 0);
			page.mergeCells(0, 0, 2, 0);
			page.mergeCells(3, 0, 5, 0);
			// increasing the width of the cell
			//page.setColumnView(0, 40);
			//page.setColumnView(1, 40);
			page.setColumnView(6, 40);
			page.setColumnView(7, 40);

			int row = 0;
			page.addCell(new Label(6, row, seq.getName()));
			row++;
			// Legend
			page.addCell(new Label( 0 , row , "Vertex 1" ));
			page.addCell(new Label( 3 , row , "Vertex 2" ));
			page.addCell(new Label( 6 , row , "Real distance" ));
			page.addCell(new Label( 7 , row , "Distance between the two vertices" ));
			page.addCell(new Label( 8 , row , "Number of pixel from segment" ));
			page.addCell(new Label( 9 , row , "ratio" ));
			

			row++;
			page.addCell(new Label(0 , row , "x"));
			page.addCell(new Label( 1 , row , "y"));
			page.addCell(new Label( 2 , row , "z"));
			page.addCell(new Label( 3 , row , "x"));
			page.addCell(new Label( 4 , row , "y"));
			page.addCell(new Label( 5 , row , "z"));
			row++;
			
			double distance, realDistance;
			Number number;
			// for each edge, filling lines
			for (Edge e : edges) {
				distance = Distancebetween2Point3D(e.getVertex1(), e.getVertex2());
				if (distance <= 10) continue;
				number = new Number( 0 , row , e.getVertex1().getX());
				page.addCell(number);
				number = new Number( 1 , row , e.getVertex1().getY());
				page.addCell(number);
				number = new Number( 2 , row , e.getVertex1().getZ());
				page.addCell(number);
				number = new Number( 3 , row , e.getVertex2().getX());
				page.addCell(number);
				number = new Number( 4 , row , e.getVertex2().getY());
				page.addCell(number);
				number = new Number( 5 , row , e.getVertex2().getZ());
				page.addCell(number);
				realDistance = realDistancebetween2Point3D(e.getEdge());
				if (realDistance > 2)
				number = new Number( 6 , row , realDistance);
				page.addCell(number);
				
				number = new Number( 7 , row , distance );
				page.addCell(number);
				number = new Number (8, row, e.getEdge().size());
				page.addCell(number);
				number = new Number (9,row, realDistance/distance);
				page.addCell(number);
				row++;
			}
			// calcul de la moyenne des ratios
			Formula formule = new Formula(9, row, "MOYENNE(J4:J"+row+")");
			page.addCell(formule);
			
			pageresultat.write();
			pageresultat.close();
		}
		catch(IOException e){
			e.printStackTrace();
		}	
		catch(WriteException we){
			we.printStackTrace();
		}
	}
	
	
	public void saveResult2ExcelAurel (String path, ArrayList<Edge> edges) {
		try {
			WritableWorkbook pageresultat;
			pageresultat = Workbook.createWorkbook(new File( path ));

			WritableSheet page = pageresultat.createSheet("RESULT ", 0);
			

			int row = 0;
			page.addCell(new Label(6, row, seq.getName()));
			row++;
			// Legend
			page.addCell(new Label( 0 , row , "# astocytes" ));
			page.addCell(new Label( 3 , row , "id" ));
			page.addCell(new Label( 6 , row , "# primary process" ));
			page.addCell(new Label( 7 , row , "# secondary process" ));
			page.addCell(new Label( 8 , row , "# third process" ));
			page.addCell(new Label( 9 , row , "branch" ));
			
			
			pageresultat.write();
			pageresultat.close();
		}
		catch(IOException e){
			e.printStackTrace();
		}	
		catch(WriteException we){
			we.printStackTrace();
		}
	}
}