package plugins.spop.simpleoperations;

import icy.gui.dialog.MessageDialog;
import icy.image.IcyBufferedImage;
import icy.math.ArrayMath;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;

public class SimpleOperations extends EzPlug implements Block
{

    EzVarSequence input1 = new EzVarSequence("Input 1");
    EzVarSequence input2 = new EzVarSequence("Input 2");
   
    EzVarText op = new EzVarText("Operation", new String[] {"Addition", "Subtraction","Division", "Multiplication", "Max", "Min", "Mean","------------"
    		,"Absolute Value","Negation","Inversion","Square Root", "Exponential e","Exponential 10","Logarithm e", "Logarithm 10"},1, false);
    EzVarInteger band = new EzVarInteger("Band");
    EzVarSequence output = new EzVarSequence("Output");

    @Override
    public void initialize()
    {
        // TODO Auto-generated method stub
        super.addEzComponent(input1);
        super.addEzComponent(input2);
        super.addEzComponent(op);
        super.addEzComponent(band);
        
        band.setMinValue(0);
        this.input1.addVarChangeListener(new EzVarListener<Sequence>() {
			
			@Override
			public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
				// TODO Auto-generated method stub
				band.setValue(0);
				if(newValue == null)
					band.setEnabled(false);
				else
				{
					int dim_c=newValue.getSizeC();
					band.setMaxValue(dim_c-1);
					band.setEnabled(dim_c!=1);					
				}
				
			}
		});        
       
    }

    @Override
    public void execute()
    {

        // TODO Auto-generated method stub
        int c = band.getValue();
        int op_int = 0;
        Sequence in1 = input1.getValue(true);
        Sequence in2 = input2.getValue(true);
        Sequence out=null;
               
        if (op.getValue().equalsIgnoreCase("------------"))
        {
        	MessageDialog.showDialog("Please select another operation \n above this line : 2 Sequence operations \n under this line : 1 Sequence operations");
        	return;
        }
        if (op.getValue().equalsIgnoreCase("Addition"))
            op_int = 0;
        if (op.getValue().equalsIgnoreCase("Subtraction"))
            op_int = 1;
        if (op.getValue().equalsIgnoreCase("Max"))
            op_int = 2;
        if (op.getValue().equalsIgnoreCase("Min"))
            op_int = 3;
        if (op.getValue().equalsIgnoreCase("Division"))
            op_int = 4;
        if (op.getValue().equalsIgnoreCase("Multiplication"))
            op_int = 5;
        if (op.getValue().equalsIgnoreCase("Mean"))
            op_int = 6;
      //  if (op.getValue().equalsIgnoreCase("And"))
      //      op_int = 7;
        if (op.getValue().equalsIgnoreCase("Absolute Value"))
            op_int = 8;
        if (op.getValue().equalsIgnoreCase("Negation"))
            op_int = 9;
        if (op.getValue().equalsIgnoreCase("Inversion"))
            op_int = 10;        
        if (op.getValue().equalsIgnoreCase("Square Root"))
            op_int = 11;
        if (op.getValue().equalsIgnoreCase("Exponential e"))
            op_int = 12;
        if (op.getValue().equalsIgnoreCase("Exponential 10"))
            op_int = 13;
        if (op.getValue().equalsIgnoreCase("Logarithm e"))
            op_int = 14;
        if (op.getValue().equalsIgnoreCase("Logarithm 10"))
            op_int = 15;
      

        
        out = operation_3D(in1, in2, c, op_int);
        out.setName(op.getValue());
        if(getUI()!=null)
        	addSequence(out);        
        output.setValue(out);

    }

    public void clean()
    {
    }

    public static Sequence operation_3D(Sequence in1, Sequence in2, int band, int op)
    {
        int z = 0;

        Sequence seq = new Sequence();

        int dim_x1 = in1.getSizeX();
        int dim_y1 = in1.getSizeY();

        int dim_z1 = in1.getSizeZ();
        int dim_t1 = in1.getSizeT();

        int dim_x2,dim_y2,dim_z2, dim_t2;
        if(op<7)
        {
            dim_x2 = in2.getSizeX();
	        dim_y2 = in2.getSizeY();
	        dim_z2 = in2.getSizeZ();
	        dim_t2 = in2.getSizeT();
	
	        if (dim_x1 != dim_x2 || dim_y1 != dim_y2 || dim_z1 != dim_z2|| dim_t1 != dim_t2)
	            throw new IllegalArgumentException("Not compatible dimensions");
        }

       

        for (int time_slice = 0; time_slice < dim_t1; time_slice++)
            for (z = 0; z < dim_z1; z++)
            {
            	 double[] tab1 =new double[dim_x1*dim_y1];
            	 Array1DUtil.arrayToDoubleArray(in1.getDataXY(time_slice, z, band), tab1, false);
            	 double[] tab2 =new double[dim_x1*dim_y1];
            	 if(op<7)            	 
	                 Array1DUtil.arrayToDoubleArray(in2.getDataXY(time_slice, z, band), tab2, false);
            	              

                
                IcyBufferedImage Icy = new IcyBufferedImage(dim_x1, dim_y1, 1,  DataType.DOUBLE);
                switch (op)
                {
                    case 0:
                        Icy.setDataXYAsDouble(0, ArrayMath.add(tab1, tab2));
                        break;
                    case 1:
                        Icy.setDataXYAsDouble(0, ArrayMath.subtract(tab1, tab2));
                        break;
                    case 2:
                        Icy.setDataXYAsDouble(0, ArrayMath.max(tab1, tab2));
                        break;
                    case 3:
                        Icy.setDataXYAsDouble(0, ArrayMath.min(tab1, tab2));
                        break;
                    case 4:
                        Icy.setDataXYAsDouble(0, ArrayMath.divide(tab1, tab2));
                        break;
                    case 5:
                        Icy.setDataXYAsDouble(0, ArrayMath.multiply(tab1, tab2));
                        break;
                    case 6:            	
                	{ArrayMath.add(tab1, tab2, tab1);
                	ArrayMath.multiply(tab1, 0.5, tab1);
                	Icy.setDataXY(0, (Object) tab1);}
                    break;
                   /* case 7:
                    {
                        ArrayMath.multiply(ArrayMath.multiply(tab1, tab2), (double) (1.0 / MathUtil.max(tab2, false)), tab1);
                        Icy.setDataXY(0, (Object) tab1);
                    }
                        break;*/
                   case 8:
                        Icy.setDataXYAsDouble(0, ArrayMath.abs(tab1, false));
                       break;
                    case 9:
                        Icy.setDataXYAsDouble(0, ArrayMath.multiply(tab1, -1));
                       break;
                    case 10:
                        Icy.setDataXYAsDouble(0, ArrayMath.divide(1, tab1));
                       break;
                    case 11:
                        Icy.setDataXYAsDouble(0, sq_root(tab1));
                       break;
                    case 12:
                        Icy.setDataXYAsDouble(0, exp_e(tab1));
                    case 13:
                        Icy.setDataXYAsDouble(0, exp_10(tab1));
                       break;
                    case 14:
                        Icy.setDataXYAsDouble(0, log_e(tab1));
                       break;
                    case 15:
                        Icy.setDataXYAsDouble(0, log_10(tab1));
                       break;
                        

                }
                seq.setImage(time_slice, z, Icy);
                System.gc();

            }

        return seq;

    }
    
    static double[] sq_root(double[] in)
    {
    	double[] out=new double[in.length];
    	for(int i=0;i<in.length;i++)
    	{
    		out[i]=0;
    		if(in[i]>0)
    			out[i]=Math.sqrt(in[i]);
    	}
    	return out;
    }
    static double[] exp_e(double[] in)
    {
    	double[] out=new double[in.length];
    	for(int i=0;i<in.length;i++)
    	{
    		out[i]=Math.exp(in[i]);
    	}
    	return out;
    }
    static double[] exp_10(double[] in)
    {
    	double[] out=new double[in.length];
    	for(int i=0;i<in.length;i++)
    	{
    		out[i]=Math.pow(in[i],10);
    	}
    	return out;
    }
    static double[] log_e(double[] in)
    {
    	double[] out=new double[in.length];
    	for(int i=0;i<in.length;i++)
    	{
    		out[i]=0;
    		if(in[i]>0)
    			out[i]=Math.log(in[i]);
    	}
    	return out;
    }
    static double[] log_10(double[] in)
    {
    	double[] out=new double[in.length];
    	for(int i=0;i<in.length;i++)
    	{
    		out[i]=0;
    		if(in[i]>0)
    			out[i]=Math.log10(in[i]);
    	}
    	return out;
    }

	@Override
	public void declareInput(VarList inputMap) {
		// TODO Auto-generated method stub
		inputMap.add(input1.getVariable());
		inputMap.add(input2.getVariable());
	   
		inputMap.add(op.getVariable());
		inputMap.add(band.getVariable());
		
		
	}

	@Override
	public void declareOutput(VarList outputMap) {
		// TODO Auto-generated method stub
		outputMap.add(output.getVariable());
		
	}


}
