/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.shape.priorshapes.shapes;

import plugins.big.bigsnakeutils.icy.snake2D.Snake2DNode;

/**
 * Shape prior with taking the shape of a cross section of the corpus callosum
 * within the brain.
 * 
 * @version November 13, 2013
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class CorpusCallosum extends PriorShape {

	public CorpusCallosum() {
		name_ = new String("Corpus callosum");
		minNumberNodes_ = 16;
		coef_ = new Snake2DNode[minNumberNodes_];
		coef_[0] = new Snake2DNode(691.0, 328.0);
		coef_[1] = new Snake2DNode(731.0, 314.0);
		coef_[2] = new Snake2DNode(729.0, 278.0);
		coef_[3] = new Snake2DNode(683.0, 252.0);
		coef_[4] = new Snake2DNode(632.0, 247.0);
		coef_[5] = new Snake2DNode(589.0, 250.0);
		coef_[6] = new Snake2DNode(552.0, 260.0);
		coef_[7] = new Snake2DNode(522.0, 280.0);
		coef_[8] = new Snake2DNode(483.0, 306.0);
		coef_[9] = new Snake2DNode(506.0, 345.0);
		coef_[10] = new Snake2DNode(526.0, 315.0);
		coef_[11] = new Snake2DNode(547.0, 292.0);
		coef_[12] = new Snake2DNode(580.0, 274.0);
		coef_[13] = new Snake2DNode(619.0, 268.0);
		coef_[14] = new Snake2DNode(665.0, 271.0);
		coef_[15] = new Snake2DNode(707.0, 286.0);
	}
}
