package plugins.ylemontag.sequencecomparator;

import icy.sequence.Sequence;

/**
 * 
 * @author Yoann
 *
 * Compute a global error measure between two sequences 
 */
public abstract class GlobalComparator extends Comparator<ErrorMeasure> 
{
	/**
	 * Constructor
	 */
	public GlobalComparator(String distanceName)
	{
		super(distanceName);
	}
	
	@Override
	protected ErrorMeasure allocateResult()
	{
		return new ErrorMeasure();
	}
	
	/**
	 * Initialize a new ErrorMeasure object, with all error buffers set to the
	 * suitable size and filled with zeros 
	 */
	protected void makeErrorMeasure(Sequence ref, Sequence seq, ErrorMeasure out)
	{
		int sizeZ = seq.getSizeZ();
		int sizeT = seq.getSizeT();
		int sizeC = seq.getSizeC();
		out.errorAll = 0;
		out.errorZ = makeZeroArray(sizeZ);
		out.errorT = makeZeroArray(sizeT);
		out.errorC = makeZeroArray(sizeC);
		out.label = getComparisonLabel(ref, seq);
	}
	
	/**
	 * Create a new array of the given size, and fill it with 0
	 */
	private static double[] makeZeroArray(int size)
	{
		double[] retVal = new double[size];
		for(int k=0; k<size; ++k) {
			retVal[k] = 0;
		}
		return retVal;
	}
}
