package plugins.ylemontag.sequencecomparator.blocks;

import icy.sequence.Sequence;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarSequence;
import plugins.ylemontag.sequencecomparator.ErrorMeasure;
import plugins.ylemontag.sequencecomparator.GlobalComparator;
import plugins.ylemontag.sequencecomparator.LocalComparator;


/**
 * 
 * @author Yoann Le Montagner
 * 
 * Compare two sequences
 */
public class ComparisonBlock extends AbstractComparisonBlock
{
	private VarSequence     _in1       = new VarSequence    ("Seq. 1"       , null);
	private VarSequence     _in2       = new VarSequence    ("Seq. 2"       , null);
	private VarErrorMeasure _outGlobal = new VarErrorMeasure("Error measure", null);
	private VarSequence     _outLocal  = new VarSequence    ("Error map"    , null);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		super.declareInput(inputMap);
		inputMap.add(_in1);
		inputMap.add(_in2);
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_outGlobal);
		outputMap.add(_outLocal );
	}
	
	@Override
	public String getName()
	{
		return "Comparison";
	}
	
	@Override
	public String getDescription()
	{
		return "Compare two sequences";
	}
	
	@Override
	protected void executeComparison(GlobalComparator globalComparator, LocalComparator localComparator)
	{
		Sequence seq1 = _in1.getValue();
		Sequence seq2 = _in2.getValue();
		ErrorMeasure globalResult = globalComparator.compare(seq1, seq2);
		Sequence     localResult  = localComparator .compare(seq1, seq2);
		_outGlobal.setValue(globalResult);
		_outLocal .setValue(localResult );
	}
}
