package plugins.ylemontag.sequencecomparator.gui;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

import plugins.ylemontag.sequencecomparator.ComparatorFactory;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Component displaying a list of available distances
 */
public abstract class ComparatorComponent<T extends ComparatorFactory<?>> extends JComboBox
{
	private static final long serialVersionUID = 1L;
	
	protected DefaultComboBoxModel _model;
	
	/**
	 * Constructor
	 */
	public ComparatorComponent()
	{
		super();
		_model = new DefaultComboBoxModel();
		setModel(_model);
		initModel();
	}
	
	/**
	 * Return the selected object
	 */
	@SuppressWarnings("unchecked")
	public T getSelectedObject()
	{
		return (T)getSelectedItem();
	}
	
	/**
	 * Return the object at a given row
	 */
	@SuppressWarnings("unchecked")
	public T getObjectAt(int index)
	{
		return (T)getItemAt(index);
	}
	
	/**
	 * Set the selected object
	 */
	public void setSelectedObject(T value)
	{
		if(value==null) {
			return;
		}
		int N = getItemCount();
		for(int k=0; k<N; ++k) {
			if(value==getItemAt(k)) {
				setSelectedIndex(k);
				return;
			}
		}
	}
	
	/**
	 * Feed the model with the list of opened sequences
	 */
	protected abstract void initModel();
}
