/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnake.core;

import plugins.big.bigsnake.snake.ESnakeParameters;
import plugins.big.bigsnakeutils.icy.snake2D.Snake2DNode;
import plugins.big.bigsnakeutils.shape.priorshapes.shapes.Custom;

/**
 * Container where the defining nodes and parameters of a snake can be stored.
 * 
 * @version May 3, 2014
 * 
 * @author Emrah Bostan (emrah.bostan@gmail.com)
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class Snake2DClipboard {

	/** Snake execution parameters. */
	private ESnakeParameters parameters_ = null;
	/** Snake-defining control points. */
	private Snake2DNode[] nodes_ = null;
	/** Custom shape that the snake uses as prior. */
	private Custom customPriorShape_ = null;

	// ============================================================================
	// PUBLIC METHODS

	/** Default constructor. */
	public Snake2DClipboard() {
	}

	// ----------------------------------------------------------------------------

	/** Returns the custom prior shape element. */
	public Custom getCustomPriorShape() {
		return customPriorShape_;
	}

	// ----------------------------------------------------------------------------

	/** Returns the spline control points of the snake. */
	public Snake2DNode[] getSnakeNodes() {
		return nodes_;
	}

	// ----------------------------------------------------------------------------

	/** Gets the execution parameters of the E-Snake. */
	public ESnakeParameters getSnakeParameters() {
		return parameters_;
	}

	// ----------------------------------------------------------------------------

	/** Sets the custom prior shape element. */
	public void setCustomPriorShape(Custom customPriorShape) {
		customPriorShape_ = customPriorShape;
	}

	// ----------------------------------------------------------------------------

	/** Sets the spline control points of the snake. */
	public void setSnakeNodes(Snake2DNode[] nodes) {
		nodes_ = nodes;
	}

	// ----------------------------------------------------------------------------

	/** Sets the execution parameters of the E-Snake. */
	public void setSnakeParameters(ESnakeParameters parameters) {
		parameters_ = parameters;
	}

	// ----------------------------------------------------------------------------

	/**
	 * Returns <code>true</code> if there are no snake nodes or snake parameters
	 * in the clipboard. Otherwise, it returns <code>false</code>
	 */
	public boolean isEmpty() {
		if (nodes_ == null || parameters_ == null) {
			return true;
		} else {
			return false;
		}
	}
}