/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.a_experiment;

import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.image.IcyBufferedImage;
import icy.image.ImageUtil;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Vector2d;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS96.series.Registration;
import plugins.fmp.multiSPOTS96.tools.GaspardRigidRegistration;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxExperiment;
import plugins.fmp.multiSPOTS96.tools.canvas2D.Canvas2D_3Transforms;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;

public class CorrectDrift
extends JPanel
implements ViewerListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    int val = 0;
    int min = 0;
    int max = 10000;
    int step = 1;
    int maxLast = 99999999;
    JSpinner referenceFrameJSpinner = new JSpinner(new SpinnerNumberModel(this.val, this.min, this.max, this.step));
    public static final ImageTransformEnums[] TRANSFORMS = new ImageTransformEnums[]{ImageTransformEnums.NONE, ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.RGB_DIFFS, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB, ImageTransformEnums.DERICHE};
    private JComboBox<ImageTransformEnums> transformsComboBox = new JComboBox<ImageTransformEnums>(TRANSFORMS);
    JButton runButton = new JButton("Run");
    JSpinner xSpinner = new JSpinner(new SpinnerNumberModel(0, -500, 500, 1));
    JSpinner ySpinner = new JSpinner(new SpinnerNumberModel(0, -500, 500, 1));
    JButton applyButton1 = new JButton("Apply");
    JButton restoreButton1 = new JButton("Restore 1 step");
    int previousX = 0;
    int previousY = 0;
    int previousT = 0;
    JSpinner oSpinner = new JSpinner(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0));
    JButton applyButton2 = new JButton("Apply");
    private MultiSPOTS96 parent0 = null;
    JComboBoxExperiment editExpList = new JComboBoxExperiment();
    private Registration registration = null;

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.parent0 = parent0;
        this.setLayout(capLayout);
        FlowLayout flowlayout = new FlowLayout(0);
        flowlayout.setVgap(1);
        JPanel panel0 = new JPanel(flowlayout);
        panel0.add(new JLabel("Ref. frame"));
        panel0.add(this.referenceFrameJSpinner);
        panel0.add(new JLabel("filter"));
        panel0.add(this.transformsComboBox);
        panel0.add(this.runButton);
        this.add(panel0);
        JPanel panel1 = new JPanel(flowlayout);
        panel1.add(new JLabel("offset x"));
        panel1.add(this.xSpinner);
        panel1.add(new JLabel("y"));
        panel1.add(this.ySpinner);
        panel1.add(this.applyButton1);
        panel1.add(this.restoreButton1);
        this.add(panel1);
        JPanel panel2 = new JPanel(flowlayout);
        panel2.add(new JLabel("rotate angle"));
        panel2.add(this.oSpinner);
        panel2.add(this.applyButton2);
        this.add(panel2);
        this.restoreButton1.setEnabled(false);
        this.oSpinner.setEnabled(false);
        this.applyButton2.setEnabled(false);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((CorrectDrift)CorrectDrift.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (CorrectDrift.this.runButton.getText().equals("Run")) {
                        CorrectDrift.this.executeRegistration(exp);
                    } else {
                        CorrectDrift.this.stopComputation();
                    }
                }
            }
        });
        this.referenceFrameJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Viewer v;
                Experiment exp = (Experiment)((CorrectDrift)CorrectDrift.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqCamData.getSequence() != null && (v = exp.seqCamData.getSequence().getFirstViewer()) != null) {
                    int newValue = (Integer)CorrectDrift.this.referenceFrameJSpinner.getValue();
                    if (v.getPositionT() != newValue) {
                        v.setPositionT(newValue);
                    }
                }
            }
        });
        this.transformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((CorrectDrift)CorrectDrift.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqCamData.getSequence() != null) {
                    int index = CorrectDrift.this.transformsComboBox.getSelectedIndex();
                    Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
                    CorrectDrift.this.updateTransformFunctionsOfCanvas(exp);
                    canvas.setTransformStep1Index(index + 1);
                }
            }
        });
        this.applyButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((CorrectDrift)CorrectDrift.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqKymos != null) {
                    int x = (Integer)CorrectDrift.this.xSpinner.getValue();
                    int y = (Integer)CorrectDrift.this.ySpinner.getValue();
                    CorrectDrift.this.translateCurrentImage(exp, x, y);
                    CorrectDrift.this.restoreButton1.setEnabled(true);
                    CorrectDrift.this.previousX = x;
                    CorrectDrift.this.previousY = y;
                }
            }
        });
        this.restoreButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((CorrectDrift)CorrectDrift.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqKymos != null) {
                    CorrectDrift.this.translateCurrentImage(exp, -CorrectDrift.this.previousX, -CorrectDrift.this.previousY);
                    CorrectDrift.this.restoreButton1.setEnabled(false);
                    CorrectDrift.this.previousX = 0;
                    CorrectDrift.this.previousY = 0;
                }
            }
        });
    }

    public void resetFrameIndex() {
        this.referenceFrameJSpinner.setValue(0);
    }

    public void viewerChanged(ViewerEvent event) {
        Viewer v;
        int t;
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED && event.getDim() == DimensionId.T && (t = (v = event.getSource()).getPositionT()) >= 0) {
            if (t != this.previousT) {
                this.previousT = t;
                this.previousX = 0;
                this.previousY = 0;
                this.restoreButton1.setEnabled(false);
            }
            this.referenceFrameJSpinner.setValue(t);
        }
    }

    public void viewerClosed(Viewer viewer) {
        viewer.removeListener((ViewerListener)this);
    }

    void executeRegistration(Experiment exp) {
        this.registration = new Registration();
        this.registration.options = this.initParameters(exp);
        this.registration.stopFlag = false;
        this.registration.addPropertyChangeListener(this);
        this.registration.execute();
        this.runButton.setText("STOP");
    }

    private BuildSeriesOptions initParameters(Experiment exp) {
        BuildSeriesOptions options = new BuildSeriesOptions();
        int referenceFrame = (Integer)this.referenceFrameJSpinner.getValue();
        options.fromFrame = 0;
        options.toFrame = referenceFrame - 1;
        options.referenceFrame = referenceFrame;
        options.expList = this.parent0.expListCombo;
        options.transformop = (ImageTransformEnums)((Object)this.transformsComboBox.getSelectedItem());
        return options;
    }

    private void stopComputation() {
        if (this.registration != null && !this.registration.stopFlag) {
            this.registration.stopFlag = true;
        }
        this.runButton.setText("Run");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.runButton.setText("Run");
            this.runButton.removePropertyChangeListener(this);
        }
    }

    private void updateTransformFunctionsOfCanvas(Experiment exp) {
        Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
        if (canvas.getTransformStep1ItemCount() < this.transformsComboBox.getItemCount() + 1) {
            canvas.updateTransformsStep1(TRANSFORMS);
        }
        int index = this.transformsComboBox.getSelectedIndex();
        canvas.setTransformStep1(index + 1, null);
    }

    private void translateCurrentImage(Experiment exp, int x, int y) {
        Vector2d translation = new Vector2d((double)x, (double)y);
        int t = (Integer)this.referenceFrameJSpinner.getValue();
        Sequence seq = exp.seqCamData.getSequence();
        IcyBufferedImage workImage = seq.getImage(t, 0);
        workImage = GaspardRigidRegistration.applyTranslation2D(workImage, -1, translation, true);
        seq.setImage(t, 0, (BufferedImage)workImage);
        String fileName = exp.seqCamData.getFileNameFromImageList(t);
        File outputfile = new File(fileName);
        BufferedImage image = ImageUtil.toRGBImage((Image)workImage);
        boolean success = ImageUtil.save((RenderedImage)image, (String)"jpg", (File)outputfile);
    }
}

