/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.a_experiment;

import icy.gui.viewer.Viewer;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxMs;

public class Intervals
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = -5739112045358747277L;
    Long val = 1L;
    Long min = 0L;
    Long max = 10000L;
    Long step = 1L;
    Long maxLast = 99999999L;
    JSpinner indexFirstImageJSpinner = new JSpinner(new SpinnerNumberModel(this.val, this.min, this.max, this.step));
    JComboBox<String> clipNumberImagesCombo = new JComboBox<String>(new String[]{"up to last frame acquired", "clip number of frames to"});
    JSpinner fixedNumberOfImagesJSpinner = new JSpinner(new SpinnerNumberModel(this.maxLast, this.step, this.maxLast, this.step));
    JSpinner binSizeJSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 1000.0, 1.0));
    JComboBoxMs binUnit = new JComboBoxMs();
    JButton applyButton = new JButton("Apply changes");
    JButton refreshButton = new JButton("Refresh");
    private MultiSPOTS96 parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        int bWidth = 50;
        int bHeight = 21;
        Dimension dimension = new Dimension(bWidth, bHeight);
        this.indexFirstImageJSpinner.setPreferredSize(dimension);
        this.binSizeJSpinner.setPreferredSize(dimension);
        this.fixedNumberOfImagesJSpinner.setPreferredSize(dimension);
        FlowLayout layout1 = new FlowLayout(0);
        layout1.setVgap(1);
        JPanel panel0 = new JPanel(layout1);
        panel0.add(new JLabel("Frame:", 4));
        panel0.add(this.indexFirstImageJSpinner);
        panel0.add(this.clipNumberImagesCombo);
        panel0.add(this.fixedNumberOfImagesJSpinner);
        panel0.add(this.applyButton);
        this.add(panel0);
        JPanel panel1 = new JPanel(layout1);
        panel1.add(new JLabel("Time between frames ", 4));
        panel1.add(this.binSizeJSpinner);
        panel1.add(this.binUnit);
        panel1.add(this.refreshButton);
        this.add(panel1);
        this.fixedNumberOfImagesJSpinner.setVisible(false);
        this.defineActionListeners();
        this.clipNumberImagesCombo.addItemListener(this);
    }

    private void defineActionListeners() {
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Intervals.this.setExperimentParameters(exp);
                }
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Intervals.this.refreshBinSize(exp);
                }
            }
        });
        this.indexFirstImageJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                long newValue = (Long)Intervals.this.indexFirstImageJSpinner.getValue();
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqCamData.getImageLoader().getAbsoluteIndexFirstImage() != newValue) {
                    exp.seqCamData.getImageLoader().setAbsoluteIndexFirstImage(newValue);
                    List<String> imagesList = ExperimentDirectories.getImagesListFromPathV2(exp.seqCamData.getImageLoader().getImagesDirectory(), "jpg");
                    exp.seqCamData.loadImageList(imagesList);
                    long bin_ms = exp.seqCamData.getTimeManager().getBinImage_ms();
                    exp.seqCamData.getTimeManager().setBinFirst_ms(exp.seqCamData.getImageLoader().getAbsoluteIndexFirstImage() * bin_ms);
                    exp.save_MS96_experiment();
                }
            }
        });
        this.fixedNumberOfImagesJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                long newValue = (Long)Intervals.this.fixedNumberOfImagesJSpinner.getValue();
                if (exp != null && exp.seqCamData.getImageLoader().getFixedNumberOfImages() != newValue) {
                    exp.seqCamData.getImageLoader().setFixedNumberOfImages(newValue);
                    ArrayList imagesList = (ArrayList)ExperimentDirectories.getImagesListFromPathV2(exp.seqCamData.getImageLoader().getImagesDirectory(), "jpg");
                    exp.seqCamData.loadImageList(imagesList);
                    long bin_ms = exp.seqCamData.getTimeManager().getBinImage_ms();
                    exp.seqCamData.getTimeManager().setBinLast_ms((Long)Intervals.this.fixedNumberOfImagesJSpinner.getValue() - exp.seqCamData.getImageLoader().getAbsoluteIndexFirstImage() * bin_ms);
                }
            }
        });
        this.binSizeJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    long bin_ms = (long)((Double)Intervals.this.binSizeJSpinner.getValue() * (double)Intervals.this.binUnit.getMsUnitValue());
                    exp.seqCamData.getTimeManager().setBinImage_ms(bin_ms);
                    exp.seqCamData.getTimeManager().setBinFirst_ms(exp.seqCamData.getImageLoader().getAbsoluteIndexFirstImage() * bin_ms);
                    exp.seqCamData.getTimeManager().setBinLast_ms((exp.seqCamData.getImageLoader().getFixedNumberOfImages() - 1L) * bin_ms);
                }
            }
        });
    }

    private void setExperimentParameters(Experiment exp) {
        exp.seqCamData.getTimeManager().setBinImage_ms((long)((Double)this.binSizeJSpinner.getValue() * (double)this.binUnit.getMsUnitValue()));
        long bin_ms = exp.seqCamData.getTimeManager().getBinImage_ms();
        exp.seqCamData.getImageLoader().setAbsoluteIndexFirstImage((Long)this.indexFirstImageJSpinner.getValue());
        exp.seqCamData.getTimeManager().setBinFirst_ms(exp.seqCamData.getImageLoader().getAbsoluteIndexFirstImage() * bin_ms);
        if (exp.seqCamData.getImageLoader().getFixedNumberOfImages() > 0L) {
            exp.seqCamData.getTimeManager().setBinLast_ms((exp.seqCamData.getImageLoader().getFixedNumberOfImages() - 1L) * bin_ms);
        } else {
            exp.seqCamData.getTimeManager().setBinLast_ms((long)(exp.seqCamData.getImageLoader().getNTotalFrames() - 1) * bin_ms);
        }
        Viewer v = exp.seqCamData.getSequence().getFirstViewer();
        if (v != null) {
            v.close();
        }
        this.parent0.dlgBrowse.loadSaveExperiment.closeCurrentExperiment();
        this.parent0.dlgBrowse.loadSaveExperiment.openSelecteExperiment(exp);
    }

    public void getExptParms(Experiment exp) {
        this.refreshBinSize(exp);
        long bin_ms = exp.seqCamData.getTimeManager().getBinImage_ms();
        long dFirst = exp.seqCamData.getImageLoader().getAbsoluteIndexFirstImage();
        this.indexFirstImageJSpinner.setValue(dFirst);
        if (exp.seqCamData.getTimeManager().getBinLast_ms() <= 0L) {
            exp.seqCamData.getTimeManager().setBinLast_ms((long)(exp.seqCamData.getImageLoader().getNTotalFrames() - 1) * bin_ms);
        }
        this.fixedNumberOfImagesJSpinner.setValue(exp.seqCamData.getImageLoader().getFixedNumberOfImages());
    }

    private void refreshBinSize(Experiment exp) {
        exp.loadFileIntervalsFromSeqCamData();
        this.binUnit.setSelectedIndex(1);
        this.binSizeJSpinner.setValue((double)exp.seqCamData.getTimeManager().getBinImage_ms() / (double)this.binUnit.getMsUnitValue());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Experiment exp;
        Object source;
        if (e.getStateChange() == 1 && (source = e.getSource()) instanceof JComboBox && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null) {
            boolean clipped = this.clipNumberImagesCombo.getSelectedIndex() == 1;
            this.fixedNumberOfImagesJSpinner.setVisible(clipped);
            if (!clipped) {
                this.fixedNumberOfImagesJSpinner.setValue(-1L);
            } else {
                this.fixedNumberOfImagesJSpinner.setValue(exp.seqCamData.getImageLoader().getNTotalFrames());
            }
        }
    }
}

