/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.c_kymos;

import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.dlg.c_kymos.EnumStatusComputation;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.sequence.KymographConfiguration;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceKymos;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS96.series.BuildSpotsKymos;

public class Create
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1771360416354320887L;
    private String detectString = "Start";
    JButton startComputationButton = new JButton("Start");
    JCheckBox allSeriesCheckBox = new JCheckBox("ALL series (current to last)", false);
    JCheckBox concurrentDisplayCheckBox = new JCheckBox("concurrent display", false);
    Long val = 0L;
    Long min = 0L;
    Long max = 10000L;
    Long step = 1L;
    Long maxLast = 99999999L;
    JSpinner kymosFrameFirstJSpinner = new JSpinner(new SpinnerNumberModel(this.val, this.min, this.max, this.step));
    JSpinner kymosFrameLastJSpinner = new JSpinner(new SpinnerNumberModel(this.maxLast, this.step, this.maxLast, this.step));
    JSpinner kymosFrameDeltaJSpinner = new JSpinner(new SpinnerNumberModel((Number)1L, Long.valueOf(1L), Long.valueOf(100L), (Number)1L));
    EnumStatusComputation sComputation = EnumStatusComputation.START_COMPUTATION;
    private MultiSPOTS96 parent0 = null;
    private BuildSpotsKymos threadBuildKymo = null;

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel0 = new JPanel(layoutLeft);
        ((FlowLayout)panel0.getLayout()).setVgap(1);
        panel0.add(this.startComputationButton);
        panel0.add(this.allSeriesCheckBox);
        panel0.add(this.concurrentDisplayCheckBox);
        this.add(panel0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(new JLabel("Frame ", 4));
        panel1.add(this.kymosFrameFirstJSpinner);
        panel1.add(new JLabel(" to "));
        panel1.add(this.kymosFrameLastJSpinner);
        this.add(panel1);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(new JLabel("Ratio: 1 to ", 4));
        panel2.add(this.kymosFrameDeltaJSpinner);
        panel2.add(new JLabel(" image(s)"));
        this.add(panel2);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.startComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Create.this.startComputationButton.getText().equals(Create.this.detectString)) {
                    Create.this.startComputation();
                } else {
                    Create.this.stopComputation();
                }
            }
        });
        this.allSeriesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (Create.this.allSeriesCheckBox.isSelected()) {
                    color = Color.RED;
                }
                Create.this.allSeriesCheckBox.setForeground(color);
                Create.this.startComputationButton.setForeground(color);
            }
        });
    }

    private void setExptParms(Experiment exp) {
        long bin_ms = exp.seqCamData.getTimeManager().getBinImage_ms();
        if (exp.seqKymos == null) {
            exp.seqKymos = SequenceKymos.kymographBuilder().withConfiguration(KymographConfiguration.qualityProcessing()).build();
        }
        exp.seqKymos.getImageLoader().setAbsoluteIndexFirstImage((Long)this.kymosFrameFirstJSpinner.getValue());
        exp.seqKymos.getTimeManager().setDeltaImage((Long)this.kymosFrameDeltaJSpinner.getValue());
        exp.seqKymos.getTimeManager().setBinFirst_ms(exp.seqCamData.getImageLoader().getAbsoluteIndexFirstImage() * bin_ms);
        exp.seqKymos.getTimeManager().setBinLast_ms((Long)this.kymosFrameLastJSpinner.getValue() * bin_ms);
    }

    public void getExptParms(Experiment exp) {
        long bin_ms = exp.seqCamData.getTimeManager().getBinImage_ms();
        if (bin_ms == 0L) {
            exp.loadFileIntervalsFromSeqCamData();
            bin_ms = exp.seqCamData.getTimeManager().getBinImage_ms();
        }
        if (exp.seqKymos == null) {
            exp.seqKymos = SequenceKymos.kymographBuilder().withConfiguration(KymographConfiguration.defaultConfiguration()).build();
        }
        long dFirst = exp.seqKymos.getImageLoader().getAbsoluteIndexFirstImage();
        this.kymosFrameFirstJSpinner.setValue(dFirst);
        this.kymosFrameDeltaJSpinner.setValue(exp.seqCamData.getTimeManager().getDeltaImage());
        if (exp.seqCamData.getTimeManager().getBinLast_ms() <= 0L) {
            exp.seqCamData.getTimeManager().setBinLast_ms((long)exp.seqCamData.getImageLoader().getNTotalFrames() * bin_ms);
        }
        long dLast = exp.seqCamData.getTimeManager().getBinLast_ms() / bin_ms;
        this.kymosFrameLastJSpinner.setValue(dLast);
        exp.getFileIntervalsFromSeqCamData();
    }

    private BuildSeriesOptions initBuildParameters(Experiment exp) {
        this.setExptParms(exp);
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allSeriesCheckBox.isSelected() ? this.parent0.expListCombo.getItemCount() - 1 : options.expList.index0;
        options.isFrameFixed = false;
        exp.loadFileIntervalsFromSeqCamData();
        options.t_Ms_First = exp.seqCamData.getFirstImageMs();
        options.t_Ms_Last = exp.seqCamData.getLastImageMs();
        options.t_Ms_BinDuration = exp.seqCamData.getTimeManager().getBinImage_ms();
        options.doCreateBinDir = true;
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.binSubDirectory = "bin_" + options.t_Ms_BinDuration / 1000L;
        options.concurrentDisplay = this.concurrentDisplayCheckBox.isSelected();
        return options;
    }

    private void startComputation() {
        this.sComputation = EnumStatusComputation.STOP_COMPUTATION;
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            exp.saveSpotsArray_file();
        }
        this.threadBuildKymo = new BuildSpotsKymos();
        this.threadBuildKymo.options = this.initBuildParameters(exp);
        this.threadBuildKymo.addPropertyChangeListener(this);
        this.threadBuildKymo.execute();
        this.startComputationButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.threadBuildKymo != null && !this.threadBuildKymo.stopFlag) {
            this.threadBuildKymo.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.startComputationButton.setText(this.detectString);
            this.parent0.dlgKymos.tabDisplay.displayUpdateOnSwingThread2(0, 1);
        }
    }
}

