/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.c_kymos;

import icy.file.Saver;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.FontUtil;
import icy.image.IcyBufferedImage;
import icy.system.thread.ThreadUtil;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import loci.formats.FormatException;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageFileDescriptor;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceKymos;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;

public class LoadSave
extends JPanel {
    private static final long serialVersionUID = -4381802490262298749L;
    private JButton openButtonKymos = new JButton("Load...");
    private JButton saveButtonKymos = new JButton("Save...");
    private MultiSPOTS96 parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        JLabel loadsaveText = new JLabel("-> Kymographs (tiff) ", 4);
        loadsaveText.setFont(FontUtil.setStyle((Font)loadsaveText.getFont(), (int)2));
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(loadsaveText);
        panel1.add(this.openButtonKymos);
        panel1.add(this.saveButtonKymos);
        panel1.validate();
        this.add(panel1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.openButtonKymos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSave)LoadSave.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && LoadSave.this.loadDefaultKymos(exp)) {
                    LoadSave.this.firePropertyChange("KYMOS_OPEN", false, true);
                }
            }
        });
        this.saveButtonKymos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSave)LoadSave.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    String path = exp.getKymosBinFullDirectory();
                    LoadSave.this.saveKymographFiles(path);
                    LoadSave.this.firePropertyChange("KYMOS_SAVE", false, true);
                }
            }
        });
    }

    void saveKymographFiles(String directory) {
        ProgressFrame progress = new ProgressFrame("Save kymographs");
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        SequenceKymos seqKymos = exp.seqKymos;
        if (directory == null) {
            directory = exp.getDirectoryToSaveResults();
            try {
                Files.createDirectories(Paths.get(directory, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        String outputpath = directory;
        JFileChooser f = new JFileChooser(outputpath);
        f.setFileSelectionMode(1);
        int returnedval = f.showSaveDialog(null);
        if (returnedval == 0) {
            outputpath = f.getSelectedFile().getAbsolutePath();
            for (int t = 0; t < seqKymos.getSequence().getSizeT(); ++t) {
                for (Cage cage : exp.cagesArray.cagesList) {
                    final Spot spot = cage.getSpotsArray().getSpotsList().get(t);
                    progress.setMessage("Save kymograph file : " + spot.getRoi().getName());
                    spot.setSpotFilenameTiff(outputpath + File.separator + spot.getRoi().getName() + ".tiff");
                    final File file = new File(spot.getSpotFilenameTiff());
                    final IcyBufferedImage image = seqKymos.getSeqImage(t, 0);
                    ThreadUtil.bgRun((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Saver.saveImage((IcyBufferedImage)image, (File)file, (boolean)true);
                            }
                            catch (IOException | FormatException e) {
                                e.printStackTrace();
                            }
                            System.out.println("LoadSaveKymos:saveKymographFiles() File " + spot.getSpotFilenameTiff() + " saved ");
                        }
                    });
                }
            }
        }
        progress.close();
    }

    public boolean loadDefaultKymos(Experiment exp) {
        boolean flag = false;
        SequenceKymos seqKymos = exp.seqKymos;
        if (seqKymos == null || exp.cagesArray == null) {
            System.out.println("LoadSaveKymos:loadDefaultKymos() no parent sequence or no spots found");
            return flag;
        }
        String localString = this.parent0.expListCombo.stringExpBinSubDirectory;
        if (localString == null) {
            exp.checkKymosDirectory(exp.getBinSubDirectory());
            this.parent0.expListCombo.stringExpBinSubDirectory = exp.getBinSubDirectory();
        } else {
            exp.setBinSubDirectory(localString);
        }
        List<ImageFileDescriptor> myList = exp.seqKymos.createKymographFileList(exp.getKymosBinFullDirectory(), exp.cagesArray);
        int nItems = ImageFileDescriptor.getExistingFileNames(myList);
        if (nItems > 0) {
            flag = seqKymos.loadKymographImagesFromList(myList, true);
            exp.cagesArray.transferSpotsMeasuresToSequenceAsROIs(exp.seqKymos.getSequence());
            this.parent0.dlgKymos.tabDisplay.transferSpotNamesToComboBox(exp);
        } else {
            seqKymos.closeSequence();
        }
        return flag;
    }
}

