/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.cages;

import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import java.util.Optional;
import plugins.fmp.multiSPOTS96.experiment.cages.CageProperties;

public final class CageData {
    private final int kymographIndex;
    private final BooleanMask2D cageMask2D;
    private final CageProperties properties;
    private final boolean valid;
    private final boolean detectEnabled;
    private final boolean initialFlyRemoved;
    private final ROI2D roi;

    private CageData(Builder builder) {
        this.kymographIndex = builder.kymographIndex;
        this.cageMask2D = builder.cageMask2D;
        this.properties = Objects.requireNonNull(builder.properties, "Properties cannot be null");
        this.valid = builder.valid;
        this.detectEnabled = builder.detectEnabled;
        this.initialFlyRemoved = builder.initialFlyRemoved;
        this.roi = Objects.requireNonNull(builder.roi, "ROI cannot be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CageData createValid(ROI2D roi, CageProperties properties) {
        return CageData.builder().withRoi(roi).withProperties(properties).valid(true).detectEnabled(true).build();
    }

    public static CageData createInvalid(ROI2D roi, String reason) {
        return CageData.builder().withRoi(roi).withProperties(new CageProperties()).valid(false).detectEnabled(false).build();
    }

    public int getKymographIndex() {
        return this.kymographIndex;
    }

    public Optional<BooleanMask2D> getCageMask2D() {
        return Optional.ofNullable(this.cageMask2D);
    }

    public CageProperties getProperties() {
        return this.properties;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isDetectEnabled() {
        return this.detectEnabled;
    }

    public boolean isInitialFlyRemoved() {
        return this.initialFlyRemoved;
    }

    public ROI2D getRoi() {
        return this.roi;
    }

    public String getName() {
        return Optional.ofNullable(this.roi.getName()).orElse("unnamed_cage");
    }

    public Rectangle2D getBounds() {
        return this.roi.getBounds2D();
    }

    public Point2D getCenterTop() {
        Rectangle2D rect = this.getBounds();
        return new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY());
    }

    public boolean hasValidBounds() {
        Rectangle2D bounds = this.getBounds();
        return bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0;
    }

    public boolean hasMask() {
        return this.cageMask2D != null;
    }

    public CageData withValidation(boolean valid) {
        return CageData.builder().from(this).valid(valid).build();
    }

    public CageData withDetection(boolean detectEnabled) {
        return CageData.builder().from(this).detectEnabled(detectEnabled).build();
    }

    public CageData withMask(BooleanMask2D mask) {
        return CageData.builder().from(this).withCageMask2D(mask).build();
    }

    public CageData withProperties(CageProperties properties) {
        return CageData.builder().from(this).withProperties(properties).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CageData cageData = (CageData)obj;
        return Objects.equals(this.getName(), cageData.getName()) && Objects.equals(this.properties.cageID, cageData.properties.cageID);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.properties.cageID);
    }

    public String toString() {
        return String.format("CageData{name='%s', cageID=%d, valid=%b, detectEnabled=%b}", this.getName(), this.properties.cageID, this.valid, this.detectEnabled);
    }

    public static class Builder {
        private int kymographIndex = -1;
        private BooleanMask2D cageMask2D;
        private CageProperties properties;
        private boolean valid = true;
        private boolean detectEnabled = true;
        private boolean initialFlyRemoved = false;
        private ROI2D roi;

        public Builder withKymographIndex(int kymographIndex) {
            this.kymographIndex = kymographIndex;
            return this;
        }

        public Builder withCageMask2D(BooleanMask2D cageMask2D) {
            this.cageMask2D = cageMask2D;
            return this;
        }

        public Builder withProperties(CageProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public Builder detectEnabled(boolean detectEnabled) {
            this.detectEnabled = detectEnabled;
            return this;
        }

        public Builder initialFlyRemoved(boolean initialFlyRemoved) {
            this.initialFlyRemoved = initialFlyRemoved;
            return this;
        }

        public Builder withRoi(ROI2D roi) {
            this.roi = roi;
            return this;
        }

        public Builder from(CageData cageData) {
            this.kymographIndex = cageData.kymographIndex;
            this.cageMask2D = cageData.cageMask2D;
            this.properties = cageData.properties;
            this.valid = cageData.valid;
            this.detectEnabled = cageData.detectEnabled;
            this.initialFlyRemoved = cageData.initialFlyRemoved;
            this.roi = cageData.roi;
            return this;
        }

        public CageData build() {
            return new CageData(this);
        }
    }
}

