/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.cages;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import icy.util.XMLUtil;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.cages.EnumCageMeasures;
import plugins.fmp.multiSPOTS96.experiment.cages.FlyPositions;
import plugins.fmp.multiSPOTS96.experiment.sequence.ROIOperation;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;
import plugins.fmp.multiSPOTS96.experiment.sequence.TIntervalsArray;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotString;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotsArray;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS96.tools.Comparators;
import plugins.fmp.multiSPOTS96.tools.JComponents.Dialog;
import plugins.fmp.multiSPOTS96.tools.JComponents.exceptions.FileDialogException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class CagesArray {
    public ArrayList<Cage> cagesList = new ArrayList();
    private TIntervalsArray cagesListTimeIntervals = null;
    public int nCagesAlongX = 6;
    public int nCagesAlongY = 8;
    public int nColumnsPerCage = 2;
    public int nRowsPerCage = 1;
    public long detectFirst_Ms = 0L;
    public long detectLast_Ms = 0L;
    public long detectBin_Ms = 60000L;
    public int detect_threshold = 0;
    public int detect_nframes = 0;
    private final String ID_CAGES = "Cages";
    private final String ID_NCAGES = "n_cages";
    private final String ID_NCAGESALONGX = "N_cages_along_X";
    private final String ID_NCAGESALONGY = "N_cages_along_Y";
    private final String ID_NCOLUMNSPERCAGE = "N_columns_per_cage";
    private final String ID_NROWSPERCAGE = "N_rows_per_cage";
    private final String ID_MCDROSOTRACK_XML = "MCdrosotrack.xml";
    public final String ID_MS96_cages_XML = "MS96_cages.xml";
    public final String ID_MS96_spotsMeasures_XML = "MS96_spotsMeasures.xml";
    public final String ID_MS96_fliesPositions_XML = "MS96_fliesPositions.xml";
    final String csvSep = ";";

    public CagesArray() {
    }

    public CagesArray(ArrayList<Cage> cagesListFrom) {
        this.copyCagesInfos(cagesListFrom);
    }

    public CagesArray(int ncolumns, int nrows) {
        this.nCagesAlongX = ncolumns;
        this.nCagesAlongY = nrows;
        this.cagesList = new ArrayList(ncolumns * nrows);
    }

    public void clearAllMeasures(int option_detectCage) {
        for (Cage cage : this.cagesList) {
            if (option_detectCage >= 0 && option_detectCage != cage.getProperties().getCageID()) continue;
            cage.clearMeasures();
        }
    }

    public void removeCages() {
        this.cagesList.clear();
    }

    public void mergeLists(CagesArray cageArrayToMerge) {
        for (Cage cageAdded : cageArrayToMerge.cagesList) {
            if (this.isPresent(cageAdded)) continue;
            this.cagesList.add(cageAdded);
        }
    }

    public void copyCagesInfos(ArrayList<Cage> cagesListFrom) {
        this.copyCages(cagesListFrom, false);
    }

    public void copyCages(ArrayList<Cage> cagesListFrom, boolean bMeasures) {
        this.cagesList.clear();
        this.nCagesAlongX = 0;
        this.nCagesAlongY = 0;
        for (Cage cageFrom : cagesListFrom) {
            Cage cage = new Cage();
            cage.copyCage(cageFrom, bMeasures);
            this.cagesList.add(cage);
            if (this.nCagesAlongX < cageFrom.getProperties().getArrayColumn()) {
                this.nCagesAlongX = cageFrom.getProperties().getArrayColumn();
            }
            if (this.nCagesAlongY >= cageFrom.getProperties().getArrayRow()) continue;
            this.nCagesAlongY = cageFrom.getProperties().getArrayRow();
        }
    }

    public void pasteCagesInfos(ArrayList<Cage> cagesListTo) {
        this.pasteCages(cagesListTo, false);
    }

    public void pasteCages(ArrayList<Cage> cagesListTo, boolean bMeasures) {
        block0: for (Cage cageTo : cagesListTo) {
            int fromID = cageTo.getProperties().getCageID();
            for (Cage cage : this.cagesList) {
                if (cage.getProperties().getCageID() != fromID) continue;
                cage.pasteCage(cageTo, bMeasures);
                continue block0;
            }
        }
    }

    public boolean saveCagesMeasures(String directory) {
        this.csvSaveCagesMeasures(directory);
        String tempName = directory + File.separator + "MCdrosotrack.xml";
        this.xmlWriteCagesToFileNoQuestion(tempName);
        return true;
    }

    public boolean loadCagesMeasures(String directory) {
        String tempName = directory + File.separator + "MCdrosotrack.xml";
        this.xmlReadCagesFromFileNoQuestion(tempName);
        return true;
    }

    private boolean csvSaveCagesMeasures(String directory) {
        try {
            FileWriter csvWriter = new FileWriter(directory + File.separator + "CagesMeasures.csv");
            this.csvSaveDescriptionSection(csvWriter);
            this.csvSaveMeasuresSection(csvWriter, EnumCageMeasures.POSITION);
            csvWriter.flush();
            csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSaveDescriptionSection(FileWriter csvWriter) {
        try {
            csvWriter.append("#;DESCRIPTION;Cages data\n");
            csvWriter.append("n cages=;" + Integer.toString(this.cagesList.size()) + "\n");
            if (this.cagesList.size() > 0) {
                for (Cage cage : this.cagesList) {
                    csvWriter.append(cage.csvExportCageDescription(";"));
                }
            }
            csvWriter.append("#;#\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSaveMeasuresSection(FileWriter csvWriter, EnumCageMeasures measuresType) {
        try {
            csvWriter.append("#;#\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean xmlReadCagesFromFile(Experiment exp) {
        String[] filedummy = null;
        String filename = exp.getResultsDirectory();
        File file = new File(filename);
        String directory = file.getParentFile().getAbsolutePath();
        try {
            filedummy = Dialog.selectFiles(directory, "xml");
        }
        catch (FileDialogException e) {
            e.printStackTrace();
        }
        boolean wasOk = false;
        if (filedummy != null) {
            for (int i = 0; i < filedummy.length; ++i) {
                String csFile = filedummy[i];
                wasOk &= this.xmlReadCagesFromFileNoQuestion(csFile);
            }
        }
        return wasOk;
    }

    public boolean xmlReadCagesFromFileNoQuestion(String tempname) {
        if (tempname == null) {
            return false;
        }
        Document doc = XMLUtil.loadDocument((String)tempname);
        if (doc == null) {
            return false;
        }
        if (this.xmlLoadCages(XMLUtil.getRootElement((Document)doc))) {
            return true;
        }
        System.out.println("Cages:xmlReadCagesFromFileNoQuestion() failed to load cages from file");
        return false;
    }

    public boolean xmlWriteCagesToFileNoQuestion(String tempname) {
        if (tempname == null) {
            return false;
        }
        Document doc = XMLUtil.createDocument((boolean)true);
        if (doc == null) {
            return false;
        }
        Element node = XMLUtil.getRootElement((Document)doc);
        this.xmlSaveCages(node);
        return XMLUtil.saveDocument((Document)doc, (String)tempname);
    }

    private boolean xmlSaveCages(Node node) {
        int index = 0;
        Element xmlVal = XMLUtil.addElement((Node)node, (String)"Cages");
        int ncages = this.cagesList.size();
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"n_cages", (int)ncages);
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"N_cages_along_X", (int)this.nCagesAlongX);
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"N_cages_along_Y", (int)this.nCagesAlongY);
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"N_columns_per_cage", (int)this.nColumnsPerCage);
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"N_rows_per_cage", (int)this.nRowsPerCage);
        for (Cage cage : this.cagesList) {
            cage.xmlSaveCage(xmlVal, index);
            ++index;
        }
        return true;
    }

    private boolean xmlLoadCages(Node node) {
        this.cagesList.clear();
        Element xmlVal = XMLUtil.getElement((Node)node, (String)"Cages");
        if (xmlVal == null) {
            return false;
        }
        int ncages = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"n_cages", (int)0);
        this.nCagesAlongX = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"N_cages_along_X", (int)this.nCagesAlongX);
        this.nCagesAlongY = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"N_cages_along_Y", (int)this.nCagesAlongY);
        this.nColumnsPerCage = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"N_columns_per_cage", (int)this.nColumnsPerCage);
        this.nRowsPerCage = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"N_rows_per_cage", (int)this.nRowsPerCage);
        for (int index = 0; index < ncages; ++index) {
            Cage cage = new Cage();
            cage.xmlLoadCage(xmlVal, index);
            this.cagesList.add(cage);
        }
        return true;
    }

    private boolean isPresent(Cage cagenew) {
        boolean flag = false;
        for (Cage cage : this.cagesList) {
            if (!cage.getRoi().getName().contentEquals(cagenew.getRoi().getName())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void addMissingCages(List<ROI2D> roiList) {
        for (ROI2D roi : roiList) {
            boolean found = false;
            if (roi.getName() == null) break;
            for (Cage cage : this.cagesList) {
                if (cage.getRoi() == null) break;
                if (!roi.getName().equals(cage.getRoi().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Cage cage = new Cage();
            cage.setRoi((ROI2DShape)roi);
            this.cagesList.add(cage);
        }
    }

    private void removeOrphanCages(List<ROI2D> roiList) {
        Iterator<Cage> iterator = this.cagesList.iterator();
        while (iterator.hasNext()) {
            Cage cage = iterator.next();
            boolean found = false;
            if (cage.getRoi() != null) {
                String cageRoiName = cage.getRoi().getName();
                for (ROI2D roi : roiList) {
                    if (!roi.getName().equals(cageRoiName)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public List<ROI2D> getROIsWithCageName(SequenceCamData seqCamData) {
        ArrayList roiList = seqCamData.getSequence().getROI2Ds();
        ArrayList<ROI2D> roisCageList = new ArrayList<ROI2D>();
        for (ROI2D roi : roiList) {
            String csName = roi.getName();
            if (!(roi instanceof ROI2DPolygon) && !(roi instanceof ROI2DArea) || (csName.length() <= 4 || !csName.substring(0, 4).contains("cage")) && !csName.contains("Polygon2D")) continue;
            roisCageList.add(roi);
        }
        return roisCageList;
    }

    public Cage getCageFromRowColCoordinates(int row, int column) {
        Cage cage_found = null;
        for (Cage cage : this.cagesList) {
            if (cage.getProperties().getArrayColumn() != column || cage.getProperties().getArrayRow() != row) continue;
            cage_found = cage;
            break;
        }
        return cage_found;
    }

    public Cage findFirstSelectedCage() {
        Cage cageFound = null;
        for (Cage cage : this.cagesList) {
            ROI2D roi = cage.getRoi();
            if (!roi.isSelected()) continue;
            cageFound = cage;
            break;
        }
        return cageFound;
    }

    public Cage findFirstCageWithSelectedSpot() {
        Cage cageFound = null;
        for (Cage cage : this.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                ROI2D roi = spot.getRoi();
                if (!roi.isSelected()) continue;
                return cage;
            }
        }
        return cageFound;
    }

    public Cage getCageFromNumber(int number) {
        Cage cageFound = null;
        for (Cage cage : this.cagesList) {
            if (number != cage.getProperties().getCageID()) continue;
            cageFound = cage;
            break;
        }
        return cageFound;
    }

    public Cage getCageFromID(int cageID) {
        for (Cage cage : this.cagesList) {
            if (cage.getProperties().getCageID() != cageID) continue;
            return cage;
        }
        return null;
    }

    public Cage getCageFromName(String name) {
        for (Cage cage : this.cagesList) {
            if (!cage.getRoi().getName().equals(name)) continue;
            return cage;
        }
        return null;
    }

    public Cage getCageFromSpotName(String name) {
        int cageID = SpotString.getCageIDFromSpotName(name);
        return this.getCageFromID(cageID);
    }

    public Cage getCageFromSpotROIName(String name) {
        for (Cage cage : this.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                if (!spot.getRoi().getName().contains(name)) continue;
                return cage;
            }
        }
        return null;
    }

    public void transferCagesToSequenceAsROIs(SequenceCamData seqCamData) {
        seqCamData.processROIs(ROIOperation.removeROIs("cage"));
        ArrayList<ROI2D> cageROIList = new ArrayList<ROI2D>(this.cagesList.size());
        for (Cage cage : this.cagesList) {
            cageROIList.add(cage.getRoi());
        }
        Sequence sequence = seqCamData.getSequence();
        if (sequence != null) {
            sequence.addROIs(cageROIList, true);
        }
    }

    public void transferROIsFromSequenceToCages(SequenceCamData seqCamData) {
        List<ROI2D> roiList = seqCamData.findROIs("cage");
        Collections.sort(roiList, new Comparators.ROI2D_Name());
        this.addMissingCages(roiList);
        this.removeOrphanCages(roiList);
        Collections.sort(this.cagesList, new Comparators.Cage_Name());
    }

    public void removeAllRoiDetFromSequence(SequenceCamData seqCamData) {
        ArrayList seqlist = seqCamData.getSequence().getROI2Ds();
        for (ROI2D roi : seqlist) {
            if (!(roi instanceof ROI2DShape) || !roi.getName().contains("det")) continue;
            seqCamData.getSequence().removeROI((ROI)roi);
        }
    }

    public List<ROI2D> getPositionsAsListOfROI2DRectanglesAtT(int t) {
        ArrayList<ROI2D> roiRectangleList = new ArrayList<ROI2D>(this.cagesList.size());
        for (Cage cage : this.cagesList) {
            ROI2DRectangle roiRectangle = cage.getRoiRectangleFromPositionAtT(t);
            if (roiRectangle == null) continue;
            roiRectangleList.add((ROI2D)roiRectangle);
        }
        return roiRectangleList;
    }

    public void orderFlyPositions() {
        for (Cage cage : this.cagesList) {
            Collections.sort(cage.flyPositions.flyPositionList, new Comparators.XYTaValue_Tindex());
        }
    }

    public void initFlyPositions(int option_cagenumber) {
        int nbcages = this.cagesList.size();
        for (int i = 0; i < nbcages; ++i) {
            Cage cage = this.cagesList.get(i);
            if (option_cagenumber != -1 && cage.getProperties().getCageID() != option_cagenumber || cage.getProperties().getCageNFlies() <= 0) continue;
            cage.flyPositions = new FlyPositions();
            cage.flyPositions.ensureCapacity(this.detect_nframes);
        }
    }

    public void computeBooleanMasksForCages() {
        for (Cage cage : this.cagesList) {
            try {
                cage.computeCageBooleanMask2D();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int getLastIntervalFlyAlive(int cagenumber) {
        int flypos = -1;
        for (Cage cage : this.cagesList) {
            String cagenumberString = cage.getRoi().getName().substring(4);
            if (Integer.valueOf(cagenumberString) != cagenumber) continue;
            flypos = cage.flyPositions.getLastIntervalAlive();
            break;
        }
        return flypos;
    }

    public boolean isFlyAlive(int cagenumber) {
        boolean isalive = false;
        for (Cage cage : this.cagesList) {
            String cagenumberString = cage.getRoi().getName().substring(4);
            if (Integer.valueOf(cagenumberString) != cagenumber) continue;
            isalive = cage.flyPositions.getLastIntervalAlive() > 0;
            break;
        }
        return isalive;
    }

    public boolean isDataAvailable(int cagenumber) {
        boolean isavailable = false;
        for (Cage cage : this.cagesList) {
            String cagenumberString = cage.getRoi().getName().substring(4);
            if (Integer.valueOf(cagenumberString) != cagenumber) continue;
            isavailable = true;
            break;
        }
        return isavailable;
    }

    public int getHorizontalSpanOfCages() {
        int leftPixel = -1;
        int rightPixel = -1;
        for (Cage cage : this.cagesList) {
            ROI2D roiCage = cage.getRoi();
            Rectangle2D rect = roiCage.getBounds2D();
            int left = (int)rect.getX();
            int right = left + (int)rect.getWidth();
            if (leftPixel < 0 || left < leftPixel) {
                leftPixel = left;
            }
            if (right <= rightPixel) continue;
            rightPixel = right;
        }
        return rightPixel - leftPixel;
    }

    public Polygon2D getPolygon2DEnclosingAllCages() {
        if (this.cagesList.size() < 1 || this.cagesList.get(0).getRoi() == null) {
            return null;
        }
        Polygon2D polygon = this.getROIPolygon2D(this.cagesList.get(0).getRoi());
        for (Cage cage : this.cagesList) {
            int col = cage.getProperties().getArrayColumn();
            int row = cage.getProperties().getArrayRow();
            Polygon2D n = this.getROIPolygon2D(cage.getRoi());
            if (col == 0 && row == 0) {
                this.transferPointToPolygon(0, polygon, n);
                continue;
            }
            if (col >= this.nCagesAlongX - 1 && row == 0) {
                this.transferPointToPolygon(3, polygon, n);
                continue;
            }
            if (col == this.nCagesAlongX - 1 && row == this.nCagesAlongY - 1) {
                this.transferPointToPolygon(2, polygon, n);
                continue;
            }
            if (col != 0 || row < this.nCagesAlongY - 1) continue;
            this.transferPointToPolygon(1, polygon, n);
        }
        return polygon;
    }

    private void transferPointToPolygon(int i, Polygon2D dest, Polygon2D source) {
        dest.xpoints[i] = source.xpoints[i];
        dest.ypoints[i] = source.ypoints[i];
    }

    private Polygon2D getROIPolygon2D(ROI2D roi) {
        Polygon2D polygon = null;
        if (roi instanceof ROI2DPolygon) {
            polygon = ((ROI2DPolygon)roi).getPolygon2D();
        } else {
            Rectangle rect = roi.getBounds();
            polygon = new Polygon2D((Rectangle2D)rect);
        }
        return polygon;
    }

    public void transferCageSpotsToSequenceAsROIs(SequenceCamData seqCamData) {
        if (this.cagesList.size() > 0) {
            ArrayList<ROI2D> spotROIList = new ArrayList<ROI2D>(this.cagesList.get((int)0).spotsArray.getSpotsList().size() * this.cagesList.size());
            for (Cage cage : this.cagesList) {
                for (Spot spot : cage.spotsArray.getSpotsList()) {
                    spotROIList.add(spot.getRoi());
                }
            }
            Collections.sort(spotROIList, new Comparators.ROI2D_Name());
            seqCamData.getSequence().addROIs(spotROIList, true);
        }
    }

    public void transferROIsFromSequenceToCageSpots(SequenceCamData seqCamData) {
        List<ROI2D> listSeqRois = seqCamData.findROIs("spot");
        Collections.sort(listSeqRois, new Comparators.ROI_Name());
        for (Cage cage : this.cagesList) {
            Iterator<Spot> iteratorSpots = cage.spotsArray.getSpotsList().iterator();
            while (iteratorSpots.hasNext()) {
                Spot spot = iteratorSpots.next();
                String spotRoiName = spot.getRoi().getName();
                boolean found = false;
                Iterator<ROI2D> iteratorSeqRois = listSeqRois.iterator();
                while (iteratorSeqRois.hasNext()) {
                    ROI2D roi = iteratorSeqRois.next();
                    String roiName = roi.getName();
                    if (!roiName.equals(spotRoiName)) continue;
                    spot.setRoi((ROI2DShape)roi);
                    found = true;
                    iteratorSeqRois.remove();
                    break;
                }
                if (found) continue;
                iteratorSpots.remove();
            }
        }
    }

    public Spot getSpotFromROIName(String name) {
        for (Cage cage : this.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                if (!spot.getRoi().getName().contains(name)) continue;
                return spot;
            }
        }
        return null;
    }

    public void initCagesAndSpotsWithNFlies(int nflies) {
        for (Cage cage : this.cagesList) {
            cage.getProperties().setCageNFlies(nflies);
            cage.setNFlies(nflies);
        }
    }

    public ArrayList<Spot> getSpotsEnclosed(ROI2DPolygon envelopeRoi) {
        if (envelopeRoi == null) {
            return this.getSpotsSelected();
        }
        ArrayList<Spot> enclosedSpots = new ArrayList<Spot>();
        for (Cage cage : this.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                try {
                    if (!envelopeRoi.contains((ROI)spot.getRoi())) continue;
                    spot.getRoi().setSelected(true);
                    enclosedSpots.add(spot);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return enclosedSpots;
    }

    public ArrayList<Spot> getSpotsSelected() {
        ArrayList<Spot> enclosedSpots = new ArrayList<Spot>();
        for (Cage cage : this.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                if (!spot.getRoi().isSelected()) continue;
                enclosedSpots.add(spot);
            }
        }
        return enclosedSpots;
    }

    public SpotsArray getAllSpotsArray() {
        SpotsArray spotsArray = new SpotsArray();
        for (Cage cage : this.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                spotsArray.getSpotsList().add(spot);
            }
        }
        return spotsArray;
    }

    public Spot getSpotAtGlobalIndex(int indexT) {
        int i = 0;
        for (Cage cage : this.cagesList) {
            int count = cage.spotsArray.getSpotsList().size();
            if (i + count - 1 < indexT) {
                i += count;
                continue;
            }
            Spot spot = cage.getSpotsArray().getSpotsList().get(indexT - i);
            return spot;
        }
        return null;
    }

    public int getSpotGlobalPosition(Spot spot) {
        int i = 0;
        int cageID = spot.getProperties().getCageID();
        for (Cage cage : this.cagesList) {
            int count = cage.getSpotsArray().getSpotsList().size();
            if (cageID != cage.getProperties().getCageID()) {
                i += count;
                continue;
            }
            String name = spot.getRoi().getName();
            for (int j = 0; j < cage.getSpotsArray().getSpotsList().size(); ++j) {
                if (!name.equals(cage.getSpotsArray().getSpotsList().get(j).getRoi().getName())) continue;
                return i + j;
            }
        }
        return 0;
    }

    public int getTotalNumberOfSpots() {
        int nspots = 0;
        for (Cage cage : this.cagesList) {
            nspots += cage.getSpotsArray().getSpotsList().size();
        }
        return nspots;
    }

    public TIntervalsArray getCagesListTimeIntervals() {
        return this.cagesListTimeIntervals;
    }

    public void mergeSpotsLists(CagesArray arrayToMerge) {
        for (Cage cage : this.cagesList) {
            for (Cage cageToMerge : arrayToMerge.cagesList) {
                if (cage.getProperties().getCagePosition() != cageToMerge.getProperties().getCagePosition()) continue;
                cage.getSpotsArray().mergeSpots(cageToMerge.getSpotsArray());
            }
        }
    }

    public void setFilterOfSpotsToAnalyze(boolean setFilter, BuildSeriesOptions options) {
        for (Cage cage : this.cagesList) {
            cage.getSpotsArray().setFilterOfSpotsToAnalyze(setFilter, options);
        }
    }

    public void medianFilterFromSumToSumClean() {
        for (Cage cage : this.cagesList) {
            cage.getSpotsArray().medianFilterFromSumToSumClean();
        }
    }

    public void transferMeasuresToLevel2D() {
        for (Cage cage : this.cagesList) {
            cage.getSpotsArray().transferMeasuresToLevel2D();
        }
    }

    public void initLevel2DMeasures() {
        for (Cage cage : this.cagesList) {
            cage.getSpotsArray().initializeLevel2DMeasures();
        }
    }

    public boolean zzload_Spots(String resultsDirectory) {
        return false;
    }

    public void transferROIsMeasuresFromSequenceToSpots() {
        for (Cage cage : this.cagesList) {
            for (Spot spot : cage.getSpotsArray().getSpotsList()) {
                spot.transferRoiMeasuresToLevel2D();
            }
        }
    }

    public void transferSpotsMeasuresToSequenceAsROIs(Sequence seq) {
        List seqRoisList = seq.getROI2Ds(false);
        ROI2DUtilities.removeROI2DsMissingChar(seqRoisList, '_');
        ArrayList<ROI2D> newRoisList = new ArrayList<ROI2D>();
        int height = seq.getHeight();
        int i = 0;
        for (Cage cage : this.cagesList) {
            for (Spot spot : cage.getSpotsArray().getSpotsList()) {
                List<ROI2D> listOfRois = spot.transferMeasuresToRois(height);
                for (ROI2D roi : listOfRois) {
                    if (roi == null) continue;
                    roi.setT(i);
                }
                newRoisList.addAll(listOfRois);
                ++i;
            }
        }
        ROI2DUtilities.mergeROI2DsListNoDuplicate(seqRoisList, newRoisList, seq);
        seq.removeAllROI();
        seq.addROIs((Collection)seqRoisList, false);
    }

    public boolean load_SpotsMeasures(String directory) {
        SpotsArray spotsArray = this.getSpotsArrayFromAllCages();
        boolean flag = spotsArray.loadSpotsMeasures(directory);
        return flag;
    }

    public boolean load_SpotsAll(String directory) {
        boolean flag = this.getSpotsArrayFromAllCages().loadSpotsAll(directory);
        return flag;
    }

    public boolean save_SpotsAll(String directory) {
        boolean flag = this.getSpotsArrayFromAllCages().saveSpotsAll(directory);
        return flag;
    }

    public boolean save_SpotsMeasures(String directory) {
        if (directory == null) {
            return false;
        }
        SpotsArray localSpotsArray = this.getSpotsArrayFromAllCages();
        localSpotsArray.saveSpotsMeasures(directory);
        return true;
    }

    public SpotsArray getSpotsArrayFromAllCages() {
        SpotsArray spotsArray = new SpotsArray();
        if (this.cagesList.size() > 0) {
            for (Cage cage : this.cagesList) {
                List<Spot> spotsList = cage.getSpotsArray().getSpotsList();
                spotsArray.getSpotsList().addAll(spotsList);
            }
        }
        return spotsArray;
    }

    public void mapSpotsToCagesColumnRow() {
        for (Cage cage : this.cagesList) {
            cage.mapSpotsToCageColumnRow();
        }
    }

    public void cleanUpSpotNames() {
        for (Cage cage : this.cagesList) {
            cage.cleanUpSpotNames();
        }
    }
}

