/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import java.awt.image.BufferedImage;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.BuildSeries;
import plugins.fmp.multiSPOTS96.series.DetectSpotsTools;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class DetectSpotsOutline
extends BuildSeries {
    public boolean buildBackground = true;
    public boolean detectFlies = true;
    public DetectSpotsTools find_spots = new DetectSpotsTools();

    @Override
    void analyzeExperiment(Experiment exp) {
        if (!this.loadSeqCamDataAndCages(exp)) {
            return;
        }
        if (!this.checkBoundsForCages(exp)) {
            return;
        }
        this.openFlyDetectViewers(exp);
        this.runSpotsDetect(exp);
        if (!this.stopFlag) {
            exp.save_MS96_cages();
        }
        exp.seqCamData.closeSequence();
        this.closeSequence(this.seqNegative);
    }

    private void runSpotsDetect(Experiment exp) {
        ImageTransformOptions transformOptions = new ImageTransformOptions();
        transformOptions.transformOption = this.options.transformop;
        ImageTransformInterface transformFunction = this.options.transformop.getFunction();
        int t_from = this.options.fromFrame;
        String fileName = exp.seqCamData.getFileNameFromImageList(t_from);
        ProgressFrame progressBar = new ProgressFrame("Detecting spots from " + fileName);
        IcyBufferedImage sourceImage = this.imageIORead(fileName);
        IcyBufferedImage workImage = transformFunction.getTransformedImage(sourceImage, transformOptions);
        this.seqNegative.setImage(0, 0, (BufferedImage)workImage);
        this.vNegative.setTitle("frame " + t_from);
        try {
            this.find_spots.findSpots(exp, this.seqNegative, this.options, workImage);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        progressBar.close();
    }
}

