/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.JComponents;

import icy.file.FileUtil;
import icy.gui.dialog.ConfirmDialog;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import plugins.fmp.multiSPOTS96.tools.JComponents.exceptions.FileDialogException;

public final class Dialog {
    private static final Logger logger = Logger.getLogger(Dialog.class.getName());

    private Dialog() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static String saveFileAs(String defaultName, String directory, String extension) throws FileDialogException {
        Dialog.validateExtension(extension);
        try {
            int returnValue;
            JFileChooser fileChooser = Dialog.createFileChooser(directory, extension, false);
            if (defaultName != null && !defaultName.trim().isEmpty()) {
                fileChooser.setSelectedFile(new File(defaultName));
            }
            if ((returnValue = fileChooser.showSaveDialog(null)) == 0) {
                return Dialog.processSaveSelection(fileChooser.getSelectedFile(), extension);
            }
            return null;
        }
        catch (Exception e) {
            logger.severe("Error in saveFileAs: " + e.getMessage());
            throw new FileDialogException("Failed to open save dialog", "save_file_as", extension, e);
        }
    }

    public static String[] selectFiles(String directory, String extension) throws FileDialogException {
        Dialog.validateExtension(extension);
        try {
            JFileChooser fileChooser = Dialog.createFileChooser(directory, extension, true);
            int returnValue = fileChooser.showDialog(null, "Load");
            if (returnValue == 0) {
                return Dialog.processMultipleSelection(fileChooser.getSelectedFiles());
            }
            return null;
        }
        catch (Exception e) {
            logger.severe("Error in selectFiles: " + e.getMessage());
            throw new FileDialogException("Failed to open file selection dialog", "select_files", extension, e);
        }
    }

    private static JFileChooser createFileChooser(String directory, String extension, boolean multiSelection) {
        File dir;
        JFileChooser fileChooser = new JFileChooser();
        if (directory != null && !directory.trim().isEmpty() && (dir = new File(directory)).exists() && dir.isDirectory()) {
            fileChooser.setCurrentDirectory(dir);
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(multiSelection);
        String filterDescription = extension + " files";
        FileNameExtensionFilter filter = new FileNameExtensionFilter(filterDescription, extension);
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        return fileChooser;
    }

    private static String processSaveSelection(File selectedFile, String extension) throws FileDialogException {
        try {
            String filePath = selectedFile.getAbsolutePath();
            String normalizedExtension = Dialog.normalizeExtension(extension);
            if (!filePath.toLowerCase().endsWith(normalizedExtension.toLowerCase())) {
                filePath = filePath + normalizedExtension;
                selectedFile = new File(filePath);
            }
            if (selectedFile.exists()) {
                if (ConfirmDialog.confirm((String)"Overwrite existing file ?")) {
                    if (!FileUtil.delete((File)selectedFile, (boolean)true)) {
                        throw new FileDialogException("Failed to delete existing file", "delete_existing", filePath);
                    }
                } else {
                    return null;
                }
            }
            return filePath;
        }
        catch (Exception e) {
            throw new FileDialogException("Failed to process save selection", "process_save", selectedFile.getName(), e);
        }
    }

    private static String[] processMultipleSelection(File[] selectedFiles) {
        if (selectedFiles == null || selectedFiles.length == 0) {
            return new String[0];
        }
        String[] filePaths = new String[selectedFiles.length];
        for (int i = 0; i < selectedFiles.length; ++i) {
            filePaths[i] = selectedFiles[i].getAbsolutePath();
        }
        return filePaths;
    }

    private static void validateExtension(String extension) throws FileDialogException {
        if (extension == null || extension.trim().isEmpty()) {
            throw new FileDialogException("File extension cannot be null or empty", "validate_extension", "null_extension");
        }
    }

    private static String normalizeExtension(String extension) {
        if (extension.startsWith(".")) {
            return extension;
        }
        return "." + extension;
    }
}

