/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools;

import java.util.logging.Logger;

public class MaxMinDouble {
    private static final Logger LOGGER = Logger.getLogger(MaxMinDouble.class.getName());
    private double max = 0.0;
    private double min = 0.0;
    private boolean hasValues = false;

    public MaxMinDouble() {
        this.max = 0.0;
        this.min = 0.0;
        this.hasValues = false;
    }

    public MaxMinDouble(double val1, double val2) {
        if (val1 >= val2) {
            this.max = val1;
            this.min = val2;
        } else {
            this.min = val1;
            this.max = val2;
        }
        this.hasValues = true;
    }

    public MaxMinDouble getMaxMin(double value1, double value2) {
        this.getMaxMin(value1);
        this.getMaxMin(value2);
        return this;
    }

    public MaxMinDouble getMaxMin(MaxMinDouble val) {
        if (val == null) {
            throw new IllegalArgumentException("MaxMinDouble cannot be null");
        }
        this.getMaxMin(val.min);
        this.getMaxMin(val.max);
        return this;
    }

    public MaxMinDouble getMaxMin(double value) {
        if (!this.hasValues) {
            this.max = value;
            this.min = value;
            this.hasValues = true;
        } else {
            if (value > this.max) {
                this.max = value;
            }
            if (value < this.min) {
                this.min = value;
            }
        }
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getRange() {
        return this.max - this.min;
    }

    public double getMidpoint() {
        return (this.min + this.max) / 2.0;
    }

    public boolean hasValues() {
        return this.hasValues;
    }

    public boolean isValid() {
        return this.min <= this.max;
    }

    public boolean contains(double value) {
        return value >= this.min && value <= this.max;
    }

    public void reset() {
        this.max = 0.0;
        this.min = 0.0;
        this.hasValues = false;
    }

    public String toString() {
        if (!this.hasValues) {
            return "MaxMinDouble[no values]";
        }
        return String.format("MaxMinDouble[min=%.6f, max=%.6f, range=%.6f]", this.min, this.max, this.getRange());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaxMinDouble other = (MaxMinDouble)obj;
        return Double.compare(this.min, other.min) == 0 && Double.compare(this.max, other.max) == 0 && this.hasValues == other.hasValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Double.hashCode(this.min);
        result = 31 * result + Double.hashCode(this.max);
        result = 31 * result + Boolean.hashCode(this.hasValues);
        return result;
    }
}

