/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.overlay;

import icy.image.colormap.IcyColorMap;
import icy.util.ColorUtil;
import java.awt.Color;

public abstract class OverlayColorMapBase
extends IcyColorMap {
    protected static final int ALPHA_TRANSPARENT = 0;
    protected static final int ALPHA_OPAQUE = 255;
    protected static final String DEFAULT_MAP_NAME = "overlay";

    public OverlayColorMapBase(String mapName, Color colorMask, Color colorBackground) {
        this(mapName, colorMask, colorBackground, IcyColorMap.IcyColorMapType.RGB);
    }

    public OverlayColorMapBase(String mapName, Color colorMask, Color colorBackground, IcyColorMap.IcyColorMapType type) {
        super(OverlayColorMapBase.validateMapName(mapName), OverlayColorMapBase.validateType(type));
        if (colorMask == null) {
            throw new IllegalArgumentException("Color mask cannot be null");
        }
        if (colorBackground == null) {
            throw new IllegalArgumentException("Background color cannot be null");
        }
        this.initializeColorMap(colorMask, colorBackground);
    }

    private void initializeColorMap(Color colorMask, Color colorBackground) {
        this.beginUpdate();
        try {
            this.setupColorChannels(colorMask, colorBackground);
        }
        finally {
            this.endUpdate();
        }
    }

    private void setupColorChannels(Color colorMask, Color colorBackground) {
        int maskPosition = 255;
        boolean flatStart = false;
        int flatEnd = 254;
        this.setColorChannelValues(0, colorBackground, 0);
        this.setColorChannelValues(254, colorBackground, 0);
        this.setMaskColorValues(255, colorMask, colorBackground);
    }

    private void setColorChannelValues(int position, Color color, int alphaValue) {
        this.red.setControlPoint(position, color.getRed());
        this.green.setControlPoint(position, color.getGreen());
        this.blue.setControlPoint(position, color.getBlue());
        this.gray.setControlPoint(position, ColorUtil.getGrayMix((Color)color));
        this.alpha.setControlPoint(position, alphaValue);
    }

    private void setMaskColorValues(int position, Color colorMask, Color colorBackground) {
        this.red.setValue(position, colorMask.getRed());
        this.green.setValue(position, colorMask.getGreen());
        this.blue.setValue(position, colorMask.getBlue());
        this.gray.setValue(position, ColorUtil.getGrayMix((Color)colorBackground));
        this.alpha.setValue(position, 255);
    }

    private static String validateMapName(String mapName) {
        if (mapName == null || mapName.trim().isEmpty()) {
            throw new IllegalArgumentException("Map name cannot be null or empty");
        }
        return mapName;
    }

    private static IcyColorMap.IcyColorMapType validateType(IcyColorMap.IcyColorMapType type) {
        if (type == null) {
            throw new IllegalArgumentException("Color map type cannot be null");
        }
        return type;
    }
}

