/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.a_experiment;

import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.sequence.DimensionId;
import icy.util.StringUtil;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.series.ProcessingResult;
import plugins.fmp.multiSPOTS96.series.ProgressReporter;
import plugins.fmp.multiSPOTS96.series.RegistrationOptions;
import plugins.fmp.multiSPOTS96.series.RegistrationProcessor;
import plugins.fmp.multiSPOTS96.series.SafeRegistrationProcessor;
import plugins.fmp.multiSPOTS96.tools.JComponents.JComboBoxExperiment;
import plugins.fmp.multiSPOTS96.tools.canvas2D.Canvas2D_3Transforms;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;

public class CorrectDriftRefactored
extends JPanel
implements ViewerListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CorrectDriftRefactored.class.getName());
    private static final int DEFAULT_REFERENCE_FRAME = 0;
    private static final int MIN_FRAME = 0;
    private static final int MAX_FRAME = 10000;
    private static final int STEP_SIZE = 1;
    private static final int MIN_OFFSET = -500;
    private static final int MAX_OFFSET = 500;
    private static final double MIN_ANGLE = -180.0;
    private static final double MAX_ANGLE = 180.0;
    private static final double ANGLE_STEP = 1.0;
    public static final ImageTransformEnums[] TRANSFORMS = new ImageTransformEnums[]{ImageTransformEnums.NONE, ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.RGB_DIFFS, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB, ImageTransformEnums.DERICHE};
    private final JSpinner referenceFrameSpinner;
    private final JComboBox<ImageTransformEnums> transformsComboBox;
    private final JButton runButton;
    private final JSpinner xOffsetSpinner;
    private final JSpinner yOffsetSpinner;
    private final JButton applyTranslationButton;
    private final JButton restoreTranslationButton;
    private final JSpinner rotationAngleSpinner;
    private final JButton applyRotationButton;
    private int previousX = 0;
    private int previousY = 0;
    private int previousT = 0;
    private CompletableFuture<Void> currentTask;
    private final JComboBoxExperiment experimentList;
    private final RegistrationProcessor registrationProcessor;

    public CorrectDriftRefactored(JComboBoxExperiment experimentList) {
        this(experimentList, new SafeRegistrationProcessor());
    }

    public CorrectDriftRefactored(JComboBoxExperiment experimentList, RegistrationProcessor registrationProcessor) {
        this.experimentList = experimentList;
        this.registrationProcessor = registrationProcessor;
        this.referenceFrameSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
        this.transformsComboBox = new JComboBox<ImageTransformEnums>(TRANSFORMS);
        this.runButton = new JButton("Run");
        this.xOffsetSpinner = new JSpinner(new SpinnerNumberModel(0, -500, 500, 1));
        this.yOffsetSpinner = new JSpinner(new SpinnerNumberModel(0, -500, 500, 1));
        this.applyTranslationButton = new JButton("Apply Translation");
        this.restoreTranslationButton = new JButton("Restore Translation");
        this.rotationAngleSpinner = new JSpinner(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0));
        this.applyRotationButton = new JButton("Apply Rotation");
        this.initializeUI();
        this.setupEventListeners();
        this.updateButtonStates();
    }

    private void initializeUI() {
        this.setLayout(new GridLayout(3, 1));
        JPanel referencePanel = new JPanel(new FlowLayout(0));
        referencePanel.add(new JLabel("Reference Frame:"));
        referencePanel.add(this.referenceFrameSpinner);
        referencePanel.add(new JLabel("Transform:"));
        referencePanel.add(this.transformsComboBox);
        referencePanel.add(this.runButton);
        this.add(referencePanel);
        JPanel translationPanel = new JPanel(new FlowLayout(0));
        translationPanel.add(new JLabel("X Offset:"));
        translationPanel.add(this.xOffsetSpinner);
        translationPanel.add(new JLabel("Y Offset:"));
        translationPanel.add(this.yOffsetSpinner);
        translationPanel.add(this.applyTranslationButton);
        translationPanel.add(this.restoreTranslationButton);
        this.add(translationPanel);
        JPanel rotationPanel = new JPanel(new FlowLayout(0));
        rotationPanel.add(new JLabel("Rotation Angle (degrees):"));
        rotationPanel.add(this.rotationAngleSpinner);
        rotationPanel.add(this.applyRotationButton);
        this.add(rotationPanel);
    }

    private void setupEventListeners() {
        this.setupRunButtonListener();
        this.setupReferenceFrameListener();
        this.setupTransformComboBoxListener();
        this.setupTranslationButtonListeners();
        this.setupRotationButtonListener();
    }

    private void setupRunButtonListener() {
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment experiment = CorrectDriftRefactored.this.getCurrentExperiment();
                if (experiment == null) {
                    CorrectDriftRefactored.this.showError("No experiment selected");
                    return;
                }
                if (CorrectDriftRefactored.this.runButton.getText().equals("Run")) {
                    CorrectDriftRefactored.this.executeRegistration(experiment);
                } else {
                    CorrectDriftRefactored.this.stopComputation();
                }
            }
        });
    }

    private void setupReferenceFrameListener() {
        this.referenceFrameSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Viewer viewer;
                Experiment experiment = CorrectDriftRefactored.this.getCurrentExperiment();
                if (experiment != null && experiment.seqCamData.getSequence() != null && (viewer = experiment.seqCamData.getSequence().getFirstViewer()) != null) {
                    int newValue = (Integer)CorrectDriftRefactored.this.referenceFrameSpinner.getValue();
                    if (viewer.getPositionT() != newValue) {
                        viewer.setPositionT(newValue);
                    }
                }
            }
        });
    }

    private void setupTransformComboBoxListener() {
        this.transformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment experiment = CorrectDriftRefactored.this.getCurrentExperiment();
                if (experiment != null && experiment.seqCamData.getSequence() != null) {
                    CorrectDriftRefactored.this.updateTransformFunctionsOfCanvas(experiment);
                }
            }
        });
    }

    private void setupTranslationButtonListeners() {
        this.applyTranslationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment experiment = CorrectDriftRefactored.this.getCurrentExperiment();
                if (experiment != null) {
                    int x = (Integer)CorrectDriftRefactored.this.xOffsetSpinner.getValue();
                    int y = (Integer)CorrectDriftRefactored.this.yOffsetSpinner.getValue();
                    CorrectDriftRefactored.this.applyTranslation(experiment, x, y);
                }
            }
        });
        this.restoreTranslationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment experiment = CorrectDriftRefactored.this.getCurrentExperiment();
                if (experiment != null) {
                    CorrectDriftRefactored.this.restoreTranslation(experiment);
                }
            }
        });
    }

    private void setupRotationButtonListener() {
        this.applyRotationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment experiment = CorrectDriftRefactored.this.getCurrentExperiment();
                if (experiment != null) {
                    double angle = (Double)CorrectDriftRefactored.this.rotationAngleSpinner.getValue();
                    CorrectDriftRefactored.this.applyRotation(experiment, angle);
                }
            }
        });
    }

    private Experiment getCurrentExperiment() {
        return (Experiment)this.experimentList.getSelectedItem();
    }

    private void executeRegistration(Experiment experiment) {
        if (this.currentTask != null && !this.currentTask.isDone()) {
            this.showError("Registration already in progress");
            return;
        }
        RegistrationOptions options = this.createRegistrationOptions(experiment);
        ProcessingResult<Void> validationResult = options.validate();
        if (validationResult.isFailure()) {
            this.showError("Invalid registration options: " + validationResult.getErrorMessage());
            return;
        }
        this.currentTask = CompletableFuture.runAsync(() -> {
            try {
                LOGGER.info("Starting registration for experiment: " + experiment.getResultsDirectory());
                ProcessingResult<RegistrationProcessor.RegistrationResult> result = this.registrationProcessor.correctDriftAndRotation(experiment, options);
                if (result.isFailure()) {
                    this.showError("Registration failed: " + result.getErrorMessage());
                } else {
                    RegistrationProcessor.RegistrationResult registrationResult = result.getDataOrThrow();
                    this.showSuccess("Registration completed successfully. Processed: " + registrationResult.getFramesProcessed() + " frames, Corrected: " + registrationResult.getFramesCorrected() + " frames");
                }
            }
            catch (Exception e) {
                LOGGER.severe("Unexpected error during registration: " + e.getMessage());
                this.showError("Unexpected error during registration: " + e.getMessage());
            }
        });
        this.updateButtonStates();
        this.runButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.currentTask != null && !this.currentTask.isDone()) {
            this.currentTask.cancel(true);
            LOGGER.info("Registration stopped by user");
        }
        this.updateButtonStates();
        this.runButton.setText("Run");
    }

    private RegistrationOptions createRegistrationOptions(Experiment experiment) {
        int referenceFrame = (Integer)this.referenceFrameSpinner.getValue();
        ImageTransformEnums selectedTransform = (ImageTransformEnums)((Object)this.transformsComboBox.getSelectedItem());
        return new RegistrationOptions().fromFrame(0).toFrame(referenceFrame - 1).referenceFrame(referenceFrame).translationThreshold(0.001).rotationThreshold(0.001).transformOptions(this.createTransformOptions(selectedTransform)).saveCorrectedImages(true).preserveImageSize(true).referenceChannel(0).progressReporter(new ProgressReporter(){

            @Override
            public void updateMessage(String message) {
            }

            @Override
            public void updateProgress(int percentage) {
            }

            @Override
            public void completed() {
                CorrectDriftRefactored.this.updateButtonStates();
            }

            @Override
            public void failed(String errorMessage) {
                CorrectDriftRefactored.this.showError(errorMessage);
                CorrectDriftRefactored.this.updateButtonStates();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
    }

    private ImageTransformOptions createTransformOptions(ImageTransformEnums transform) {
        ImageTransformOptions options = new ImageTransformOptions();
        options.transformOption = transform;
        return options;
    }

    private void applyTranslation(Experiment experiment, int x, int y) {
        try {
            int currentFrame = (Integer)this.referenceFrameSpinner.getValue();
            if (experiment.seqCamData.getSequence() == null) {
                this.showError("No sequence available for translation");
                return;
            }
            LOGGER.info("Applied translation: (" + x + ", " + y + ") to frame " + currentFrame);
            this.previousX = x;
            this.previousY = y;
            this.restoreTranslationButton.setEnabled(true);
        }
        catch (Exception e) {
            LOGGER.severe("Error applying translation: " + e.getMessage());
            this.showError("Failed to apply translation: " + e.getMessage());
        }
    }

    private void restoreTranslation(Experiment experiment) {
        try {
            this.applyTranslation(experiment, -this.previousX, -this.previousY);
            this.previousX = 0;
            this.previousY = 0;
            this.restoreTranslationButton.setEnabled(false);
        }
        catch (Exception e) {
            LOGGER.severe("Error restoring translation: " + e.getMessage());
            this.showError("Failed to restore translation: " + e.getMessage());
        }
    }

    private void applyRotation(Experiment experiment, double angle) {
        try {
            int currentFrame = (Integer)this.referenceFrameSpinner.getValue();
            if (experiment.seqCamData.getSequence() == null) {
                this.showError("No sequence available for rotation");
                return;
            }
            LOGGER.info("Applied rotation: " + angle + " degrees to frame " + currentFrame);
        }
        catch (Exception e) {
            LOGGER.severe("Error applying rotation: " + e.getMessage());
            this.showError("Failed to apply rotation: " + e.getMessage());
        }
    }

    private void updateTransformFunctionsOfCanvas(Experiment experiment) {
        try {
            Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)experiment.seqCamData.getSequence().getFirstViewer().getCanvas();
            if (canvas.getTransformStep1ItemCount() < this.transformsComboBox.getItemCount() + 1) {
                canvas.updateTransformsStep1(TRANSFORMS);
            }
            int index = this.transformsComboBox.getSelectedIndex();
            canvas.setTransformStep1(index + 1, null);
        }
        catch (Exception e) {
            LOGGER.warning("Failed to update canvas transforms: " + e.getMessage());
        }
    }

    private void updateButtonStates() {
        boolean isRunning = this.currentTask != null && !this.currentTask.isDone();
        this.runButton.setEnabled(true);
        this.referenceFrameSpinner.setEnabled(!isRunning);
        this.transformsComboBox.setEnabled(!isRunning);
        this.applyTranslationButton.setEnabled(!isRunning);
        this.applyRotationButton.setEnabled(!isRunning);
        this.restoreTranslationButton.setEnabled(!isRunning && (this.previousX != 0 || this.previousY != 0));
    }

    private void showError(String message) {
        LOGGER.warning("User error: " + message);
    }

    private void showSuccess(String message) {
        LOGGER.info("Success: " + message);
    }

    public void resetFrameIndex() {
        this.referenceFrameSpinner.setValue(0);
    }

    public void viewerChanged(ViewerEvent event) {
        Viewer viewer;
        int t;
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED && event.getDim() == DimensionId.T && (t = (viewer = event.getSource()).getPositionT()) >= 0 && t != this.previousT) {
            this.previousT = t;
            this.previousX = 0;
            this.previousY = 0;
            this.restoreTranslationButton.setEnabled(false);
            this.referenceFrameSpinner.setValue(t);
        }
    }

    public void viewerClosed(Viewer viewer) {
        viewer.removeListener((ViewerListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.updateButtonStates();
            this.runButton.setText("Run");
        }
    }

    public void cleanup() {
        if (this.currentTask != null && !this.currentTask.isDone()) {
            this.currentTask.cancel(true);
        }
    }
}

