/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.b_spots;

import icy.gui.frame.IcyFrame;
import icy.roi.ROI;
import icy.roi.ROI2D;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotProperties;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotTable;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotsArray;

public class InfosSpotTable
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -8611587540329642259L;
    IcyFrame dialogFrame = null;
    private SpotTable spotTable = null;
    private JButton copyButton = new JButton("Copy table");
    private JButton pasteButton = new JButton("Paste");
    private JButton getNPixelsButton = new JButton("Get n pixels");
    private JButton selectedSpotButton = new JButton("Locate selected spot");
    private JButton duplicateRowAtCagePositionButton = new JButton("Row at cage pos");
    private JButton duplicatePreviousButton = new JButton("Row above");
    private JButton duplicateNextButton = new JButton("Row below");
    private JButton duplicateCageButton = new JButton("Cage to all");
    private JButton duplicateAllButton = new JButton("Cell to all");
    private MultiSPOTS96 parent0 = null;
    private SpotsArray allSpotsCopy = null;

    public void initialize(MultiSPOTS96 parent0) {
        this.parent0 = parent0;
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.copyButton);
        panel1.add(this.pasteButton);
        panel1.add(this.getNPixelsButton);
        panel1.add(this.selectedSpotButton);
        topPanel.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(new JLabel("Duplicate:"));
        panel2.add(this.duplicateRowAtCagePositionButton);
        panel2.add(this.duplicateAllButton);
        panel2.add(this.duplicateCageButton);
        panel2.add(this.duplicatePreviousButton);
        panel2.add(this.duplicateNextButton);
        topPanel.add(panel2);
        JPanel tablePanel = new JPanel();
        this.spotTable = new SpotTable(parent0);
        tablePanel.add(new JScrollPane(this.spotTable));
        this.spotTable.getSelectionModel().addListSelectionListener(this);
        this.dialogFrame = new IcyFrame("Spots properties", true, true);
        this.dialogFrame.add((Component)topPanel, (Object)"North");
        this.dialogFrame.add((Component)tablePanel, (Object)"Center");
        this.dialogFrame.pack();
        this.dialogFrame.addToDesktopPane();
        this.dialogFrame.requestFocus();
        this.dialogFrame.setLocation(new Point(5, 5));
        this.dialogFrame.setVisible(true);
        this.defineActionListeners();
        this.pasteButton.setEnabled(false);
    }

    private void defineActionListeners() {
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosSpotTable)InfosSpotTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosSpotTable.this.allSpotsCopy = exp.cagesArray.getAllSpotsArray();
                    InfosSpotTable.this.pasteButton.setEnabled(true);
                }
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosSpotTable)InfosSpotTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotsArray spotsArray = exp.cagesArray.getAllSpotsArray();
                    InfosSpotTable.this.allSpotsCopy.pasteSpotsInfo(spotsArray);
                }
            }
        });
        this.getNPixelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosSpotTable)InfosSpotTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosSpotTable.this.measureNPixelsForAllSpots(exp);
                }
            }
        });
        this.duplicateRowAtCagePositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosSpotTable)InfosSpotTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosSpotTable.this.duplicatePos(exp);
                }
            }
        });
        this.duplicateCageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosSpotTable)InfosSpotTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosSpotTable.this.duplicateCage(exp);
                }
            }
        });
        this.duplicatePreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosSpotTable)InfosSpotTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosSpotTable.this.duplicateRelativeRow(exp, -1);
                }
            }
        });
        this.duplicateNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosSpotTable)InfosSpotTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosSpotTable.this.duplicateRelativeRow(exp, 1);
                }
            }
        });
        this.duplicateAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosSpotTable)InfosSpotTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosSpotTable.this.duplicateAll(exp);
                }
            }
        });
        this.selectedSpotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosSpotTable)InfosSpotTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosSpotTable.this.locateSelectedROI(exp);
                }
            }
        });
        this.spotTable.spotTableModel.fireTableDataChanged();
    }

    void close() {
        this.dialogFrame.close();
    }

    private void locateSelectedROI(Experiment exp) {
        ArrayList roiList = exp.seqCamData.getSequence().getSelectedROIs();
        if (roiList.size() > 0) {
            Spot spot = null;
            for (ROI roi : roiList) {
                String name = roi.getName();
                if (name.contains("spot")) {
                    spot = exp.cagesArray.getSpotFromROIName(name);
                    continue;
                }
                if (!name.contains("cage")) continue;
                Cage cage = exp.cagesArray.getCageFromName(name);
                spot = cage.spotsArray.getSpotsList().get(0);
                break;
            }
            if (spot != null) {
                this.selectRowFromSpot(spot);
            }
        }
    }

    private void measureNPixelsForAllSpots(Experiment exp) {
        int columnIndex = 1;
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                try {
                    int value = (int)spot.getRoi().getNumberOfPoints();
                    int iID = exp.cagesArray.getSpotGlobalPosition(spot);
                    this.spotTable.spotTableModel.setValueAt(value, iID, columnIndex);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void transferFromSpot(Experiment exp, Spot spotTo, Spot spotFrom) {
        int iID = exp.cagesArray.getSpotGlobalPosition(spotTo);
        int columnIndex = 2;
        SpotProperties prop = spotFrom.getProperties();
        this.spotTable.spotTableModel.setValueAt(prop.getSpotVolume(), iID, columnIndex);
        columnIndex = 5;
        this.spotTable.spotTableModel.setValueAt(prop.getCageRow(), iID, columnIndex);
        columnIndex = 7;
        this.spotTable.spotTableModel.setValueAt(prop.getStimulus(), iID, columnIndex);
        columnIndex = 8;
        this.spotTable.spotTableModel.setValueAt(prop.getConcentration(), iID, columnIndex);
        columnIndex = 9;
        this.spotTable.spotTableModel.setValueAt(prop.getColor(), iID, columnIndex);
    }

    private void duplicatePos(Experiment exp) {
        int rowIndex = this.spotTable.getSelectedRow();
        if (rowIndex < 0) {
            return;
        }
        String spotName = (String)this.spotTable.getValueAt(rowIndex, 0);
        Spot spotFrom = exp.cagesArray.getSpotFromROIName(spotName);
        if (spotFrom == null) {
            System.out.println("spot not found: " + spotName);
            return;
        }
        SpotProperties prop = spotFrom.getProperties();
        int cagePosition = prop.getCagePosition();
        int cageID = prop.getCageID();
        for (Cage cage : exp.cagesArray.cagesList) {
            if (cage.getProperties().getCageID() == cageID) continue;
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                if (spot.getProperties().getCagePosition() != cagePosition) continue;
                this.transferFromSpot(exp, spot, spotFrom);
            }
        }
    }

    private void duplicateRelativeRow(Experiment exp, int delta) {
        int rowTo = this.spotTable.getSelectedRow();
        if (rowTo < 0) {
            return;
        }
        int rowFrom = rowTo + delta;
        if (rowFrom < 0 || rowFrom > this.spotTable.getRowCount()) {
            return;
        }
        String spotName = (String)this.spotTable.getValueAt(rowFrom, 0);
        Spot spotFrom = exp.cagesArray.getSpotFromROIName(spotName);
        if (spotFrom == null) {
            System.out.println("spot not found or invalid: " + spotName);
            return;
        }
        spotName = (String)this.spotTable.getValueAt(rowTo, 0);
        Spot spotTo = exp.cagesArray.getSpotFromROIName(spotName);
        if (spotTo == null) {
            System.out.println("spot not found or invalid: " + spotName);
            return;
        }
        this.transferFromSpot(exp, spotTo, spotFrom);
    }

    private void duplicateAll(Experiment exp) {
        int columnIndex = this.spotTable.getSelectedColumn();
        int rowIndex = this.spotTable.getSelectedRow();
        if (rowIndex < 0) {
            return;
        }
        Object value = this.spotTable.spotTableModel.getValueAt(rowIndex, columnIndex);
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                int iID = exp.cagesArray.getSpotGlobalPosition(spot);
                this.spotTable.spotTableModel.setValueAt(value, iID, columnIndex);
            }
        }
    }

    private void duplicateCage(Experiment exp) {
        int rowIndex = this.spotTable.getSelectedRow();
        if (rowIndex < 0) {
            return;
        }
        Spot spotFromSelectedRow = exp.cagesArray.getSpotAtGlobalIndex(rowIndex);
        int cageIDFrom = spotFromSelectedRow.getProperties().getCageID();
        Cage cageFrom = exp.cagesArray.getCageFromSpotName(spotFromSelectedRow.getRoi().getName());
        for (Cage cage : exp.cagesArray.cagesList) {
            if (cage.getProperties().getCageID() == cageIDFrom) continue;
            for (int i = 0; i < cage.spotsArray.getSpotsList().size(); ++i) {
                Spot spot = cage.spotsArray.getSpotsList().get(i);
                if (i >= cageFrom.spotsArray.getSpotsList().size()) continue;
                Spot spotFrom = cageFrom.spotsArray.getSpotsList().get(i);
                this.transferFromSpot(exp, spot, spotFrom);
            }
        }
    }

    public void selectRowFromSpot(Spot spot) {
        String spotName = spot.getRoi().getName();
        int nrows = this.spotTable.getRowCount();
        int selectedRow = -1;
        for (int i = 0; i < nrows; ++i) {
            String name = (String)this.spotTable.getValueAt(i, 0);
            if (!name.equals(spotName)) continue;
            selectedRow = i;
            break;
        }
        if (selectedRow >= 0) {
            this.spotTable.setRowSelectionInterval(selectedRow, selectedRow);
            Rectangle rect = new Rectangle(this.spotTable.getCellRect(selectedRow, 0, true));
            rect.height *= 2;
            this.spotTable.scrollRectToVisible(rect);
        }
    }

    void selectSpot(Spot spot) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            Cage cage;
            String name = spot.getName();
            ROI2D roiSpot = spot.getRoi();
            if (name == null) {
                name = roiSpot.getName();
            }
            if ((cage = exp.cagesArray.getCageFromSpotROIName(name)) != null) {
                ROI2D cageRoi = cage.getRoi();
                if (cageRoi != null) {
                    exp.seqCamData.centerDisplayOnRoi(cageRoi);
                } else {
                    System.out.println("cage roi not found");
                }
            } else {
                System.out.println("cage is null");
            }
            exp.seqCamData.getSequence().setFocusedROI((ROI)roiSpot);
            roiSpot.setSelected(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        int minIndex = lsm.getMinSelectionIndex();
        this.selectSpot(this.spotTable.spotTableModel.getSpotAt(minIndex));
    }
}

