/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment;

import icy.image.IcyBufferedImage;
import icy.image.ImageUtil;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.util.XMLUtil;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS96.experiment.EnumStatus;
import plugins.fmp.multiSPOTS96.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS96.experiment.ExperimentProperties;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.cages.CagesArray;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageAdjustmentOptions;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageFileDescriptor;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageLoader;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageProcessingResult;
import plugins.fmp.multiSPOTS96.experiment.sequence.KymographConfiguration;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceKymos;
import plugins.fmp.multiSPOTS96.experiment.sequence.TimeManager;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.Directories;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;

public class Experiment {
    public static final String RESULTS = "results";
    public static final String BIN = "bin_";
    private String camDataImagesDirectory = null;
    private String resultsDirectory = null;
    private String binSubDirectory = null;
    public SequenceCamData seqCamData = null;
    public SequenceKymos seqKymos = null;
    public Sequence seqReference = null;
    public CagesArray cagesArray = new CagesArray();
    public FileTime firstImage_FileTime;
    public FileTime lastImage_FileTime;
    private ExperimentProperties prop = new ExperimentProperties();
    public int col = -1;
    public Experiment chainToPreviousExperiment = null;
    public Experiment chainToNextExperiment = null;
    public long chainImageFirst_ms = 0L;
    public int experimentID = 0;
    private static final String ID_VERSION = "version";
    private static final String ID_VERSIONNUM = "1.0.0";
    private static final String ID_FRAMEFIRST = "indexFrameFirst";
    private static final String ID_NFRAMES = "nFrames";
    private static final String ID_FRAMEDELTA = "indexFrameDelta";
    private static final String ID_TIMEFIRSTIMAGEMS = "fileTimeImageFirstMs";
    private static final String ID_TIMELASTIMAGEMS = "fileTimeImageLastMs";
    private static final String ID_FIRSTKYMOCOLMS = "firstKymoColMs";
    private static final String ID_LASTKYMOCOLMS = "lastKymoColMs";
    private static final String ID_BINKYMOCOLMS = "binKymoColMs";
    private static final String ID_IMAGESDIRECTORY = "imagesDirectory";
    private static final String ID_MCEXPERIMENT = "MCexperiment";
    private final String ID_MS96_experiment_XML = "MS96_experiment.xml";
    private static final String ID_MCDROSOTRACK_XML = "MCdrosotrack.xml";
    private static final int EXPT_DIRECTORY = 1;
    private static final int IMG_DIRECTORY = 2;
    private static final int BIN_DIRECTORY = 3;
    final String csvSep = ";";

    public Experiment() {
        this.seqCamData = SequenceCamData.builder().withStatus(EnumStatus.FILESTACK).build();
        this.seqKymos = SequenceKymos.kymographBuilder().withConfiguration(KymographConfiguration.defaultConfiguration()).build();
    }

    public Experiment(String expDirectory) {
        this.seqCamData = SequenceCamData.builder().withStatus(EnumStatus.FILESTACK).build();
        this.seqKymos = SequenceKymos.kymographBuilder().withConfiguration(KymographConfiguration.defaultConfiguration()).build();
        this.resultsDirectory = expDirectory;
    }

    public Experiment(SequenceCamData seqCamData) {
        this.seqCamData = seqCamData;
        this.seqKymos = SequenceKymos.kymographBuilder().withConfiguration(KymographConfiguration.defaultConfiguration()).build();
        this.resultsDirectory = this.seqCamData.getImagesDirectory() + File.separator + RESULTS;
        this.getFileIntervalsFromSeqCamData();
        this.load_MS96_experiment(this.concatenateExptDirectoryWithSubpathAndName(null, "MS96_experiment.xml"));
    }

    public Experiment(ExperimentDirectories eADF) {
        this.camDataImagesDirectory = eADF.getCameraImagesDirectory();
        this.resultsDirectory = eADF.getResultsDirectory();
        this.binSubDirectory = eADF.getBinSubDirectory();
        this.seqCamData = SequenceCamData.builder().withStatus(EnumStatus.FILESTACK).build();
        String fileName = this.concatenateExptDirectoryWithSubpathAndName(null, "MS96_experiment.xml");
        this.load_MS96_experiment(fileName);
        ImageLoader imgLoader = this.seqCamData.getImageLoader();
        imgLoader.setImagesDirectory(eADF.getCameraImagesDirectory());
        List<String> imagesList = ExperimentDirectories.getImagesListFromPathV2(imgLoader.getImagesDirectory(), "jpg");
        this.seqCamData.loadImageList(imagesList);
        if (eADF.cameraImagesList.size() > 1) {
            this.getFileIntervalsFromSeqCamData();
        }
        if (eADF.kymosImagesList != null && eADF.kymosImagesList.size() > 0) {
            this.seqKymos = SequenceKymos.kymographBuilder().withImageList(eADF.kymosImagesList).withConfiguration(KymographConfiguration.qualityProcessing()).build();
        }
    }

    public String getResultsDirectory() {
        return this.resultsDirectory;
    }

    public String toString() {
        return this.resultsDirectory;
    }

    public void setResultsDirectory(String fileName) {
        this.resultsDirectory = ExperimentDirectories.getParentIf(fileName, BIN);
    }

    public String getKymosBinFullDirectory() {
        String filename = this.resultsDirectory;
        if (this.binSubDirectory != null) {
            filename = filename + File.separator + this.binSubDirectory;
        }
        return filename;
    }

    public void setBinSubDirectory(String bin) {
        this.binSubDirectory = bin;
    }

    public String getBinSubDirectory() {
        return this.binSubDirectory;
    }

    public boolean createDirectoryIfDoesNotExist(String directory) {
        Path pathDir = Paths.get(directory, new String[0]);
        if (Files.notExists(pathDir, new LinkOption[0])) {
            try {
                Files.createDirectory(pathDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Experiment:createDirectoryIfDoesNotExist() Creating directory failed: " + directory);
                return false;
            }
        }
        return true;
    }

    public void checkKymosDirectory(String kymosSubDirectory) {
        if (kymosSubDirectory == null) {
            List<String> listTIFFlocations = Directories.getSortedListOfSubDirectoriesWithTIFF(this.getResultsDirectory());
            if (listTIFFlocations.size() < 1) {
                return;
            }
            boolean found = false;
            for (String subDir : listTIFFlocations) {
                String test = subDir.toLowerCase();
                if (test.contains(BIN)) {
                    kymosSubDirectory = subDir;
                    found = true;
                    break;
                }
                if (!test.contains(RESULTS)) continue;
                found = true;
                break;
            }
            if (!found) {
                int lowest = this.getBinStepFromDirectoryName(listTIFFlocations.get(0)) + 1;
                for (String subDir : listTIFFlocations) {
                    int val = this.getBinStepFromDirectoryName(subDir);
                    if (val >= lowest) continue;
                    lowest = val;
                    kymosSubDirectory = subDir;
                }
            }
        }
        this.setBinSubDirectory(kymosSubDirectory);
    }

    public void setCameraImagesDirectory(String name) {
        this.camDataImagesDirectory = name;
    }

    public String getCameraImagesDirectory() {
        return this.camDataImagesDirectory;
    }

    public void closeSequences() {
        if (this.seqKymos != null) {
            this.seqKymos.closeSequence();
        }
        if (this.seqCamData != null) {
            this.seqCamData.closeSequence();
        }
        if (this.seqReference != null) {
            this.seqReference.close();
        }
    }

    public boolean zopenPositionsMeasures() {
        if (this.seqCamData == null) {
            this.seqCamData = SequenceCamData.builder().withStatus(EnumStatus.FILESTACK).build();
        }
        this.load_MS96_experiment();
        this.getFileIntervalsFromSeqCamData();
        if (this.seqKymos == null) {
            this.seqKymos = SequenceKymos.kymographBuilder().withConfiguration(KymographConfiguration.defaultConfiguration()).build();
        }
        return this.zxmlReadDrosoTrack(null);
    }

    private String getRootWithNoResultNorBinString(String directoryName) {
        String name = directoryName.toLowerCase();
        while (name.contains(RESULTS) || name.contains(BIN)) {
            name = Paths.get(this.resultsDirectory, new String[0]).getParent().toString();
        }
        return name;
    }

    private SequenceCamData loadImagesForSequenceCamData(String filename) {
        this.camDataImagesDirectory = ExperimentDirectories.getImagesDirectoryAsParentFromFileName(filename);
        List<String> imagesList = ExperimentDirectories.getImagesListFromPathV2(this.camDataImagesDirectory, "jpg");
        this.seqCamData = null;
        if (imagesList.size() > 0) {
            this.seqCamData = SequenceCamData.builder().withImagesDirectory(this.camDataImagesDirectory).withStatus(EnumStatus.FILESTACK).build();
            this.seqCamData.setImagesList(imagesList);
            this.seqCamData.attachSequence(this.seqCamData.getImageLoader().loadSequenceFromImagesList(imagesList));
        }
        return this.seqCamData;
    }

    public boolean loadCamDataSpots() {
        this.load_MS96_cages();
        if (this.seqCamData != null && this.seqCamData.getSequence() != null) {
            this.seqCamData.removeROIsContainingString("spot");
            this.cagesArray.transferCageSpotsToSequenceAsROIs(this.seqCamData);
        }
        return this.seqCamData != null && this.seqCamData.getSequence() != null;
    }

    public SequenceCamData openSequenceCamData() {
        this.loadImagesForSequenceCamData(this.camDataImagesDirectory);
        if (this.seqCamData != null) {
            this.load_MS96_experiment();
            this.getFileIntervalsFromSeqCamData();
        }
        return this.seqCamData;
    }

    public void getFileIntervalsFromSeqCamData() {
        if (this.seqCamData != null && (this.seqCamData.getFirstImageMs() < 0L || this.seqCamData.getLastImageMs() < 0L || this.seqCamData.getTimeManager().getBinImage_ms() < 0L)) {
            this.loadFileIntervalsFromSeqCamData();
        }
    }

    public void loadFileIntervalsFromSeqCamData() {
        if (this.seqCamData != null) {
            this.seqCamData.setImagesDirectory(this.camDataImagesDirectory);
            int t0 = (int)this.seqCamData.getImageLoader().getAbsoluteIndexFirstImage();
            this.firstImage_FileTime = this.seqCamData.getFileTimeFromStructuredName(t0);
            int t1 = this.seqCamData.getImageLoader().getNTotalFrames() - 1;
            this.lastImage_FileTime = this.seqCamData.getFileTimeFromStructuredName(t1);
            if (this.firstImage_FileTime != null && this.lastImage_FileTime != null) {
                this.seqCamData.setFirstImageMs(this.firstImage_FileTime.toMillis());
                this.seqCamData.setLastImageMs(this.lastImage_FileTime.toMillis());
                if (this.seqCamData.getImageLoader().getNTotalFrames() > 1) {
                    long binMs = (this.seqCamData.getLastImageMs() - this.seqCamData.getFirstImageMs()) / (long)t1;
                    this.seqCamData.getTimeManager().setBinImage_ms(binMs);
                }
                if (this.seqCamData.getTimeManager().getBinImage_ms() == 0L) {
                    System.out.println("Experiment:loadFileIntervalsFromSeqCamData() error / file interval size");
                }
            } else {
                System.out.println("Experiment:loadFileIntervalsFromSeqCamData() error / file intervals of " + this.seqCamData.getImagesDirectory());
            }
        }
    }

    public String getBinNameFromKymoFrameStep() {
        return BIN + this.seqCamData.getTimeManager().getBinDurationMs() / 1000L;
    }

    public String getDirectoryToSaveResults() {
        String directory;
        Path dir = Paths.get(this.resultsDirectory, new String[0]);
        if (this.binSubDirectory != null) {
            dir = dir.resolve(this.binSubDirectory);
        }
        if (!this.createDirectoryIfDoesNotExist(directory = dir.toAbsolutePath().toString())) {
            directory = null;
        }
        return directory;
    }

    public boolean load_MS96_experiment() {
        if (this.resultsDirectory == null && this.seqCamData != null) {
            this.camDataImagesDirectory = this.seqCamData.getImagesDirectory();
            this.resultsDirectory = this.camDataImagesDirectory + File.separator + RESULTS;
        }
        String csFileName = this.concatenateExptDirectoryWithSubpathAndName(null, "MS96_experiment.xml");
        return this.load_MS96_experiment(csFileName);
    }

    private boolean load_MS96_experiment(String csFileName) {
        Document doc = XMLUtil.loadDocument((String)csFileName);
        if (doc == null) {
            return false;
        }
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_MCEXPERIMENT);
        if (node == null) {
            return false;
        }
        String version = XMLUtil.getElementValue((Node)node, (String)ID_VERSION, (String)ID_VERSIONNUM);
        if (!version.equals(ID_VERSIONNUM)) {
            return false;
        }
        ImageLoader imgLoader = this.seqCamData.getImageLoader();
        long frameFirst = XMLUtil.getElementLongValue((Node)node, (String)ID_FRAMEFIRST, (long)0L);
        if (frameFirst < 0L) {
            frameFirst = 0L;
        }
        imgLoader.setAbsoluteIndexFirstImage(frameFirst);
        long nImages = XMLUtil.getElementLongValue((Node)node, (String)ID_NFRAMES, (long)-1L);
        imgLoader.setFixedNumberOfImages(nImages);
        imgLoader.setNTotalFrames((int)(nImages - frameFirst));
        TimeManager timeManager = this.seqCamData.getTimeManager();
        long firstMs = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMEFIRSTIMAGEMS, (long)0L);
        timeManager.setFirstImageMs(firstMs);
        long lastMs = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMELASTIMAGEMS, (long)0L);
        timeManager.setLastImageMs(lastMs);
        long durationMs = lastMs - firstMs;
        timeManager.setDurationMs(durationMs);
        long frameDelta = XMLUtil.getElementLongValue((Node)node, (String)ID_FRAMEDELTA, (long)1L);
        timeManager.setDeltaImage(frameDelta);
        long binFirstMs = XMLUtil.getElementLongValue((Node)node, (String)ID_FIRSTKYMOCOLMS, (long)-1L);
        timeManager.setBinFirst_ms(binFirstMs);
        long binLastMs = XMLUtil.getElementLongValue((Node)node, (String)ID_LASTKYMOCOLMS, (long)-1L);
        timeManager.setBinLast_ms(binLastMs);
        long binDurationMs = XMLUtil.getElementLongValue((Node)node, (String)ID_BINKYMOCOLMS, (long)-1L);
        timeManager.setBinDurationMs(binDurationMs);
        this.ugly_checkOffsetValues();
        this.prop.loadXML_Properties(node);
        return true;
    }

    public boolean save_MS96_experiment() {
        Document doc = XMLUtil.createDocument((boolean)true);
        if (doc != null) {
            Element xmlRoot = XMLUtil.getRootElement((Document)doc, (boolean)true);
            Element node = XMLUtil.setElement((Node)xmlRoot, (String)ID_MCEXPERIMENT);
            if (node == null) {
                return false;
            }
            XMLUtil.setElementValue((Node)node, (String)ID_VERSION, (String)ID_VERSIONNUM);
            ImageLoader imgLoader = this.seqCamData.getImageLoader();
            XMLUtil.setElementLongValue((Node)node, (String)ID_FRAMEFIRST, (long)imgLoader.getAbsoluteIndexFirstImage());
            XMLUtil.setElementLongValue((Node)node, (String)ID_NFRAMES, (long)imgLoader.getFixedNumberOfImages());
            TimeManager timeManager = this.seqCamData.getTimeManager();
            XMLUtil.setElementLongValue((Node)node, (String)ID_TIMEFIRSTIMAGEMS, (long)timeManager.getFirstImageMs());
            XMLUtil.setElementLongValue((Node)node, (String)ID_TIMELASTIMAGEMS, (long)timeManager.getLastImageMs());
            XMLUtil.setElementLongValue((Node)node, (String)ID_FRAMEDELTA, (long)timeManager.getDeltaImage());
            XMLUtil.setElementLongValue((Node)node, (String)ID_FIRSTKYMOCOLMS, (long)timeManager.getBinFirst_ms());
            XMLUtil.setElementLongValue((Node)node, (String)ID_LASTKYMOCOLMS, (long)timeManager.getBinLast_ms());
            XMLUtil.setElementLongValue((Node)node, (String)ID_BINKYMOCOLMS, (long)timeManager.getBinDurationMs());
            this.prop.saveXML_Properties(node);
            if (this.camDataImagesDirectory == null) {
                this.camDataImagesDirectory = this.seqCamData.getImagesDirectory();
            }
            XMLUtil.setElementValue((Node)node, (String)ID_IMAGESDIRECTORY, (String)this.camDataImagesDirectory);
            String tempname = this.concatenateExptDirectoryWithSubpathAndName(null, "MS96_experiment.xml");
            return XMLUtil.saveDocument((Document)doc, (String)tempname);
        }
        return false;
    }

    private void ugly_checkOffsetValues() {
        if (this.seqCamData.getFirstImageMs() < 0L) {
            this.seqCamData.setFirstImageMs(0L);
        }
        if (this.seqCamData.getLastImageMs() < 0L) {
            this.seqCamData.setLastImageMs(0L);
        }
        if (this.seqCamData.getTimeManager().getBinFirst_ms() < 0L) {
            this.seqCamData.getTimeManager().setBinFirst_ms(0L);
        }
        if (this.seqCamData.getTimeManager().getBinLast_ms() < 0L) {
            this.seqCamData.getTimeManager().setBinLast_ms(0L);
        }
        if (this.seqCamData.getTimeManager().getBinDurationMs() < 0L) {
            this.seqCamData.getTimeManager().setBinDurationMs(60000L);
        }
    }

    private String getXML_MS96_cages_Location(String XMLfileName) {
        String fileName = this.findFile_3Locations(XMLfileName, 1, 3, 2);
        if (fileName == null) {
            fileName = this.concatenateExptDirectoryWithSubpathAndName(null, XMLfileName);
        }
        return fileName;
    }

    public boolean load_MS96_cages() {
        String fileName = this.getXML_MS96_cages_Location(this.cagesArray.ID_MS96_cages_XML);
        return this.cagesArray.xmlReadCagesFromFileNoQuestion(fileName);
    }

    public boolean save_MS96_cages() {
        String fileName = this.getXML_MS96_cages_Location(this.cagesArray.ID_MS96_cages_XML);
        return this.cagesArray.xmlWriteCagesToFileNoQuestion(fileName);
    }

    public boolean load_MS96_spotsMeasures() {
        return this.cagesArray.load_SpotsMeasures(this.getResultsDirectory());
    }

    public boolean save_MS96_spotsMeasures() {
        return this.cagesArray.save_SpotsMeasures(this.getResultsDirectory());
    }

    public boolean load_MS96_fliesPositions() {
        return false;
    }

    public boolean save_MS96_fliesPositions() {
        return false;
    }

    public boolean load_MS96_kymographs() {
        return false;
    }

    public boolean save_MS96_kymographs() {
        return false;
    }

    public boolean zloadKymographs() {
        if (this.seqKymos == null) {
            this.seqKymos = SequenceKymos.kymographBuilder().withConfiguration(KymographConfiguration.qualityProcessing()).build();
        }
        List<ImageFileDescriptor> fileList = this.seqKymos.createKymographFileList(this.getKymosBinFullDirectory(), this.cagesArray);
        ImageFileDescriptor.getExistingFileNames(fileList);
        Rectangle maxDimensions = this.seqKymos.calculateMaxDimensions(fileList);
        ImageProcessingResult result = this.seqKymos.loadKymographs(fileList, ImageAdjustmentOptions.withSizeAdjustment(maxDimensions));
        return result.isSuccess();
    }

    public Experiment getFirstChainedExperiment(boolean globalValue) {
        Experiment exp = this;
        if (globalValue && this.chainToPreviousExperiment != null) {
            exp = this.chainToPreviousExperiment.getFirstChainedExperiment(globalValue);
        }
        return exp;
    }

    public Experiment getLastChainedExperiment(boolean globalValue) {
        Experiment exp = this;
        if (globalValue && this.chainToNextExperiment != null) {
            exp = this.chainToNextExperiment.getLastChainedExperiment(globalValue);
        }
        return exp;
    }

    public void setFileTimeImageFirst(FileTime fileTimeImageFirst) {
        this.firstImage_FileTime = fileTimeImageFirst;
    }

    public void setFileTimeImageLast(FileTime fileTimeImageLast) {
        this.lastImage_FileTime = fileTimeImageLast;
    }

    public void getFieldValues(EnumXLSColumnHeader fieldEnumCode, List<String> textList) {
        switch (fieldEnumCode) {
            case EXP_STIM: 
            case EXP_CONC: 
            case EXP_EXPT: 
            case EXP_BOXID: 
            case EXP_STRAIN: 
            case EXP_SEX: 
            case EXP_COND1: 
            case EXP_COND2: {
                this.addValue(this.prop.getExperimentField(fieldEnumCode), textList);
                break;
            }
            case SPOT_STIM: 
            case SPOT_CONC: 
            case SPOT_VOLUME: {
                this.addSpotsValues(fieldEnumCode, textList);
                break;
            }
            case CAGE_SEX: 
            case CAGE_STRAIN: 
            case CAGE_AGE: {
                this.addCagesValues(fieldEnumCode, textList);
                break;
            }
        }
    }

    public boolean replaceExperimentFieldIfEqualOld(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        boolean flag = this.prop.getExperimentField(fieldEnumCode).equals(oldValue);
        if (flag) {
            this.prop.setExperimentFieldNoTest(fieldEnumCode, newValue);
        }
        return flag;
    }

    public void replaceFieldValue(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        switch (fieldEnumCode) {
            case EXP_STIM: 
            case EXP_CONC: 
            case EXP_EXPT: 
            case EXP_BOXID: 
            case EXP_STRAIN: 
            case EXP_SEX: 
            case EXP_COND1: 
            case EXP_COND2: {
                this.replaceExperimentFieldIfEqualOld(fieldEnumCode, oldValue, newValue);
                break;
            }
            case SPOT_STIM: 
            case SPOT_CONC: 
            case SPOT_VOLUME: {
                this.replaceSpotsFieldValueWithNewValueIfOld(fieldEnumCode, oldValue, newValue);
                break;
            }
            case CAGE_SEX: 
            case CAGE_STRAIN: 
            case CAGE_AGE: {
                this.replaceCageFieldValueWithNewValueIfOld(fieldEnumCode, oldValue, newValue);
                break;
            }
        }
    }

    public boolean loadReferenceImage() {
        BufferedImage image = null;
        File inputfile = new File(this.getReferenceImageFullName());
        boolean exists = inputfile.exists();
        if (!exists) {
            return false;
        }
        image = ImageUtil.load((File)inputfile, (boolean)true);
        if (image == null) {
            System.out.println("Experiment:loadReferenceImage() image not loaded / not found");
            return false;
        }
        this.seqCamData.setReferenceImage(IcyBufferedImage.createFrom((BufferedImage)image));
        this.seqReference = new Sequence(this.seqCamData.getReferenceImage());
        this.seqReference.setName("referenceImage");
        return true;
    }

    public boolean saveReferenceImage(IcyBufferedImage referenceImage) {
        File outputfile = new File(this.getReferenceImageFullName());
        BufferedImage image = ImageUtil.toRGBImage((Image)referenceImage);
        return ImageUtil.save((RenderedImage)image, (String)"jpg", (File)outputfile);
    }

    public void cleanPreviousDetectedFliesROIs() {
        ArrayList list = this.seqCamData.getSequence().getROI2Ds();
        for (ROI2D roi : list) {
            if (!roi.getName().contains("det")) continue;
            this.seqCamData.getSequence().removeROI((ROI)roi);
        }
    }

    public String zgetMCDrosoTrackFullName() {
        return this.resultsDirectory + File.separator + ID_MCDROSOTRACK_XML;
    }

    public void updateROIsAt(int t) {
        this.seqCamData.getSequence().beginUpdate();
        ArrayList rois = this.seqCamData.getSequence().getROI2Ds();
        for (ROI2D roi : rois) {
            if (!roi.getName().contains("det")) continue;
            this.seqCamData.getSequence().removeROI((ROI)roi);
        }
        this.seqCamData.getSequence().addROIs(this.cagesArray.getPositionsAsListOfROI2DRectanglesAtT(t), false);
        this.seqCamData.getSequence().endUpdate();
    }

    public void saveDetRoisToPositions() {
        ArrayList detectedROIsList = this.seqCamData.getSequence().getROI2Ds();
        for (Cage cage : this.cagesArray.cagesList) {
            cage.transferRoisToPositions(detectedROIsList);
        }
    }

    private int getBinStepFromDirectoryName(String resultsPath) {
        int step = -1;
        if (resultsPath.contains(BIN)) {
            step = resultsPath.length() < BIN.length() + 1 ? (int)this.seqCamData.getTimeManager().getBinDurationMs() : Integer.valueOf(resultsPath.substring(BIN.length())) * 1000;
        }
        return step;
    }

    private boolean zxmlReadDrosoTrack(String filename) {
        if (filename == null && (filename = this.getXML_MS96_cages_Location(this.cagesArray.ID_MS96_cages_XML)) == null) {
            return false;
        }
        return this.cagesArray.xmlReadCagesFromFileNoQuestion(filename);
    }

    private String findFile_3Locations(String xmlFileName, int first, int second, int third) {
        String xmlFullFileName = this.findFile_1Location(xmlFileName, first);
        if (xmlFullFileName == null) {
            xmlFullFileName = this.findFile_1Location(xmlFileName, second);
        }
        if (xmlFullFileName == null) {
            xmlFullFileName = this.findFile_1Location(xmlFileName, third);
        }
        return xmlFullFileName;
    }

    private String findFile_1Location(String xmlFileName, int item) {
        String xmlFullFileName = File.separator + xmlFileName;
        block0 : switch (item) {
            case 2: {
                this.camDataImagesDirectory = this.getRootWithNoResultNorBinString(this.resultsDirectory);
                xmlFullFileName = this.camDataImagesDirectory + File.separator + xmlFileName;
                break;
            }
            case 3: {
                Path dirPath = Paths.get(this.resultsDirectory, new String[0]);
                List<Path> subFolders = Directories.getAllSubPathsOfDirectory(this.resultsDirectory, 1);
                if (subFolders == null) {
                    return null;
                }
                List<String> resultsDirList = Directories.getPathsContainingString(subFolders, RESULTS);
                List<String> binDirList = Directories.getPathsContainingString(subFolders, BIN);
                resultsDirList.addAll(binDirList);
                for (String resultsSub : resultsDirList) {
                    Path dir = dirPath.resolve(resultsSub + File.separator + xmlFileName);
                    if (Files.notExists(dir, new LinkOption[0])) continue;
                    xmlFullFileName = dir.toAbsolutePath().toString();
                    break block0;
                }
                break;
            }
            default: {
                xmlFullFileName = this.resultsDirectory + xmlFullFileName;
            }
        }
        if (xmlFullFileName != null && this.fileExists(xmlFullFileName)) {
            if (item == 2) {
                this.camDataImagesDirectory = this.getRootWithNoResultNorBinString(this.resultsDirectory);
                ExperimentDirectories.moveAndRename(xmlFileName, this.camDataImagesDirectory, xmlFileName, this.resultsDirectory);
                xmlFullFileName = this.resultsDirectory + xmlFullFileName;
            }
            return xmlFullFileName;
        }
        return null;
    }

    private boolean fileExists(String fileName) {
        File f = new File(fileName);
        return f.exists() && !f.isDirectory();
    }

    private boolean replaceSpotsFieldValueWithNewValueIfOld(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        this.load_MS96_cages();
        boolean flag = false;
        for (Cage cage : this.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                if (!spot.getField(fieldEnumCode).equals(oldValue)) continue;
                spot.setField(fieldEnumCode, newValue);
                flag = true;
            }
        }
        if (flag) {
            this.save_MS96_cages();
        }
        return flag;
    }

    private boolean replaceCageFieldValueWithNewValueIfOld(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        this.load_MS96_cages();
        boolean flag = false;
        for (Cage cage : this.cagesArray.cagesList) {
            if (!cage.getField(fieldEnumCode).equals(oldValue)) continue;
            cage.setField(fieldEnumCode, newValue);
            flag = true;
        }
        if (flag) {
            this.save_MS96_cages();
        }
        return flag;
    }

    private String concatenateExptDirectoryWithSubpathAndName(String subpath, String name) {
        if (subpath != null) {
            return this.resultsDirectory + File.separator + subpath + File.separator + name;
        }
        return this.resultsDirectory + File.separator + name;
    }

    private void addSpotsValues(EnumXLSColumnHeader fieldEnumCode, List<String> textList) {
        this.load_MS96_cages();
        for (Cage cage : this.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                this.addValue(spot.getField(fieldEnumCode), textList);
            }
        }
    }

    private void addCagesValues(EnumXLSColumnHeader fieldEnumCode, List<String> textList) {
        this.load_MS96_cages();
        for (Cage cage : this.cagesArray.cagesList) {
            this.addValue(cage.getField(fieldEnumCode), textList);
        }
    }

    private void addValue(String text, List<String> textList) {
        if (!this.isFound(text, textList)) {
            textList.add(text);
        }
    }

    private boolean isFound(String pattern, List<String> names) {
        boolean found;
        block1: {
            String name;
            found = false;
            if (names.size() <= 0) break block1;
            Iterator<String> iterator = names.iterator();
            while (iterator.hasNext() && !(found = (name = iterator.next()).equals(pattern))) {
            }
        }
        return found;
    }

    private String getReferenceImageFullName() {
        return this.resultsDirectory + File.separator + "referenceImage.jpg";
    }

    public void transferCagesROI_toSequence() {
        this.seqCamData.removeROIsContainingString("cage");
        this.cagesArray.transferCagesToSequenceAsROIs(this.seqCamData);
    }

    public void transferSpotsROI_toSequence() {
        this.seqCamData.removeROIsContainingString("spot");
        this.cagesArray.transferCageSpotsToSequenceAsROIs(this.seqCamData);
    }

    public boolean saveCagesArray_File() {
        this.cagesArray.transferROIsFromSequenceToCages(this.seqCamData);
        this.save_MS96_cages();
        return this.save_MS96_spotsMeasures();
    }

    public boolean saveSpotsArray_file() {
        this.cagesArray.transferROIsFromSequenceToCageSpots(this.seqCamData);
        boolean flag = this.save_MS96_cages();
        return flag &= this.save_MS96_spotsMeasures();
    }

    public ExperimentProperties getProperties() {
        return this.prop;
    }
}

