/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.sequence;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import plugins.fmp.multiSPOTS96.experiment.sequence.FileNameTimePattern;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageLoader;

public class TimeManager {
    private static final Logger LOGGER = Logger.getLogger(TimeManager.class.getName());
    private int indexTimePattern = -1;
    private long firstImage_ms = 0L;
    private long lastImage_ms = 0L;
    private long duration_ms = 0L;
    private long binImage_ms = 0L;
    private long[] camImages_time_ms = null;
    private double[] camImages_time_min = null;
    private long binFirst_ms = 0L;
    private long binLast_ms = 0L;
    private long binDuration_ms = 60000L;
    private long deltaImage;
    private FileNameTimePattern[] timePatternArray = new FileNameTimePattern[]{new FileNameTimePattern(), new FileNameTimePattern("yyyy-MM-dd_HH-mm-ss", "\\d{4}-\\d{2}-\\d{2}_\\d{2}\\-\\d{2}\\-\\d{2}"), new FileNameTimePattern("yy-MM-dd_HH-mm-ss", "\\d{2}-\\d{2}-\\d{2}_\\d{2}\\-\\d{2}\\-\\d{2}"), new FileNameTimePattern("yy.MM.dd_HH.mm.ss", "\\d{2}.\\d{2}.\\d{2}_\\d{2}\\.\\d{2}\\.\\d{2}")};

    public FileTime getFileTimeFromStructuredName(ImageLoader imageLoader, int t) {
        long timeInMs = 0L;
        String fileName = this.fileComponent(imageLoader.getFileNameFromImageList(t));
        if (fileName == null) {
            timeInMs = this.timePatternArray[0].getDummyTime(t);
        } else {
            if (this.indexTimePattern < 0) {
                this.indexTimePattern = this.findProperFilterIfAny(fileName);
            }
            FileNameTimePattern tp = this.timePatternArray[this.indexTimePattern];
            timeInMs = tp.getTimeFromString(fileName, t);
        }
        return FileTime.fromMillis(timeInMs);
    }

    public FileTime getFileTimeFromFileAttributes(ImageLoader imageLoader, int t) {
        String filename = imageLoader.getFileNameFromImageList(t);
        if (filename == null) {
            LOGGER.warning("Null filename for index " + t);
            return null;
        }
        FileTime filetime = null;
        try {
            File file = new File(filename);
            Path filePath = file.toPath();
            BasicFileAttributes attributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            long milliseconds = attributes.creationTime().to(TimeUnit.MILLISECONDS);
            if (milliseconds > Long.MIN_VALUE && milliseconds < Long.MAX_VALUE) {
                Date creationDate = new Date(attributes.creationTime().to(TimeUnit.MILLISECONDS));
                filetime = FileTime.fromMillis(creationDate.getTime());
            }
        }
        catch (IOException e) {
            LOGGER.warning("Failed to get file attributes: " + e.getMessage());
        }
        return filetime;
    }

    public FileTime getFileTimeFromJPEGMetaData(ImageLoader imageLoader, int t) {
        String filename = imageLoader.getFileNameFromImageList(t);
        if (filename == null) {
            LOGGER.warning("Null filename for index " + t);
            return null;
        }
        FileTime filetime = null;
        try {
            File file = new File(filename);
            Metadata metadata = ImageMetadataReader.readMetadata((File)file);
            ExifSubIFDDirectory directory = (ExifSubIFDDirectory)metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
            if (directory != null && directory.containsTag(36867)) {
                Date date = directory.getDate(36867);
                filetime = FileTime.fromMillis(date.getTime());
            } else {
                LOGGER.warning("EXIF data not found in file: " + filename);
            }
        }
        catch (ImageProcessingException e) {
            LOGGER.warning("Image processing error: " + e.getMessage());
        }
        catch (IOException e) {
            LOGGER.warning("IO error reading metadata: " + e.getMessage());
        }
        catch (Exception e) {
            LOGGER.warning("Error reading JPEG metadata: " + e.getMessage());
        }
        return filetime;
    }

    public void build_MsTimeArray_From_FileNamesList(ImageLoader imageLoader) {
        int nFrames = imageLoader.getNTotalFrames();
        this.camImages_time_ms = new long[nFrames];
        FileTime firstImage_FileTime = this.getFileTimeFromStructuredName(imageLoader, 0);
        long firstImage_ms = firstImage_FileTime.toMillis();
        for (int i = 0; i < nFrames; ++i) {
            long image_ms;
            FileTime image_FileTime = this.getFileTimeFromStructuredName(imageLoader, i);
            this.camImages_time_ms[i] = image_ms = image_FileTime.toMillis() - firstImage_ms;
        }
    }

    public int findNearestIntervalWithBinarySearch(long value, int low, int high) {
        int mid;
        int result = -1;
        result = high - low > 1 ? (this.camImages_time_ms[mid = (low + high) / 2] > value ? this.findNearestIntervalWithBinarySearch(value, low, mid) : (this.camImages_time_ms[mid] < value ? this.findNearestIntervalWithBinarySearch(value, mid, high) : mid)) : (Math.abs(value - this.camImages_time_ms[low]) < Math.abs(value - this.camImages_time_ms[high]) ? low : high);
        return result;
    }

    private int findProperFilterIfAny(String fileName) {
        for (int i = 1; i < this.timePatternArray.length; ++i) {
            if (!this.timePatternArray[i].findMatch(fileName)) continue;
            return i;
        }
        return 0;
    }

    private String fileComponent(String fname) {
        if (fname == null) {
            return null;
        }
        int pos = fname.lastIndexOf("/");
        if (pos > -1) {
            return fname.substring(pos + 1);
        }
        pos = fname.lastIndexOf("\\");
        if (pos > -1) {
            return fname.substring(pos + 1);
        }
        return fname;
    }

    public long getBinImage_ms() {
        return this.binImage_ms;
    }

    public void setBinImage_ms(long value) {
        this.binImage_ms = value;
    }

    public long getBinFirst_ms() {
        return this.binFirst_ms;
    }

    public void setBinFirst_ms(long time_ms) {
        this.binFirst_ms = time_ms;
    }

    public long getBinLast_ms() {
        return this.binLast_ms;
    }

    public void setBinLast_ms(long time_ms) {
        this.binLast_ms = time_ms;
    }

    public long getFirstImageMs() {
        return this.firstImage_ms;
    }

    public void setFirstImageMs(long timeMs) {
        this.firstImage_ms = timeMs;
    }

    public long getLastImageMs() {
        return this.lastImage_ms;
    }

    public void setLastImageMs(long timeMs) {
        this.lastImage_ms = timeMs;
    }

    public long getDurationMs() {
        return this.duration_ms;
    }

    public void setDurationMs(long timeMs) {
        this.duration_ms = timeMs;
    }

    public long getBinDurationMs() {
        return this.binDuration_ms;
    }

    public void setBinDurationMs(long durationMs) {
        this.binDuration_ms = durationMs;
    }

    public long[] getCamImagesTime_Ms() {
        return this.camImages_time_ms;
    }

    public double[] getCamImagesTime_Minutes() {
        int nFrames = this.camImages_time_ms.length;
        if (this.camImages_time_min == null || this.camImages_time_min.length != nFrames) {
            this.camImages_time_min = new double[nFrames];
        }
        double factor = 60000.0;
        for (int i = 0; i < nFrames; ++i) {
            this.camImages_time_min[i] = (double)this.camImages_time_ms[i] / factor;
        }
        return this.camImages_time_min;
    }

    public void setCamImagesTime_Ms(long[] imagesArray) {
        this.camImages_time_ms = imagesArray;
    }

    public long getDeltaImage() {
        return this.deltaImage;
    }

    public void setDeltaImage(long value) {
        this.deltaImage = value;
    }
}

