/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.spots;

import icy.roi.ROI2D;
import icy.type.geom.Polyline2D;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import plugins.fmp.multiSPOTS96.tools.polyline.Level2D;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class SpotMeasure {
    private static final double DEFAULT_FACTOR = 1.0;
    private Level2D level2D;
    private Level2D level2DOld;
    private double[] values;
    private int[] isPresent;
    private ROI2DPolyLine roi;
    private double factor;
    private int measuredFromNSpots = 1;
    private String name;

    public SpotMeasure(String name) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
        this.factor = 1.0;
        this.level2D = new Level2D();
        this.level2DOld = new Level2D();
    }

    public SpotMeasure(String name, List<Point2D> limit) {
        this(name);
        if (limit != null && !limit.isEmpty()) {
            this.setLevel2D(new Level2D(limit));
        }
    }

    public void copyLevel2D(SpotMeasure source) {
        if (source != null && source.getLevel2D() != null) {
            this.setLevel2D(source.getLevel2D().clone());
        }
    }

    public void copyMeasures(SpotMeasure source) {
        if (source == null) {
            return;
        }
        this.copyLevel2D(source);
        if (source.values != null && source.values.length > 0) {
            this.values = Arrays.copyOf(source.values, source.values.length);
        }
        if (source.isPresent != null && source.isPresent.length > 0) {
            this.isPresent = Arrays.copyOf(source.isPresent, source.isPresent.length);
        }
    }

    public void addMeasures(SpotMeasure source) {
        if (source == null) {
            return;
        }
        if (this.level2D != null && source.level2D != null) {
            this.level2D.add_Y(source.level2D);
        }
        if (source.values != null && source.values.length > 0) {
            this.addValues(source.values);
        }
        if (source.isPresent != null && source.isPresent.length > 0) {
            this.addPresence(source.isPresent);
        }
        ++this.measuredFromNSpots;
    }

    public void computePI(SpotMeasure measure1, SpotMeasure measure2) {
        if (measure1 == null || measure2 == null) {
            return;
        }
        if (this.level2D != null && measure1.level2D != null && measure2.level2D != null) {
            if (this.level2D.npoints != measure1.level2D.npoints) {
                this.level2D = new Level2D(measure1.level2D.npoints);
            }
            this.level2D.computePI_Y(measure1.level2D, measure2.level2D);
        }
        if (measure1.values != null && measure1.values.length > 0 && measure2.values != null && measure2.values.length > 0) {
            this.values = new double[measure1.values.length];
            for (int i = 0; i < measure1.values.length; ++i) {
                double value1 = measure1.values[i];
                double value2 = measure2.values[i];
                double sum = value1 + value2;
                this.values[i] = sum > 0.0 ? (value1 - value2) / sum : 0.0;
            }
        }
    }

    public void computeSUM(SpotMeasure measure1, SpotMeasure measure2) {
        if (measure1 == null || measure2 == null) {
            return;
        }
        if (this.level2D != null && measure1.level2D != null && measure2.level2D != null) {
            if (this.level2D.npoints != measure1.level2D.npoints) {
                this.level2D = new Level2D(measure1.level2D.npoints);
            }
            this.level2D.computeSUM_Y(measure1.level2D, measure2.level2D);
        }
        if (measure1.values != null && measure1.values.length > 0 && measure2.values != null && measure2.values.length > 0) {
            this.values = new double[measure1.values.length];
            for (int i = 0; i < measure1.values.length; ++i) {
                this.values[i] = measure1.values[i] + measure2.values[i];
            }
        }
    }

    public void combineIsPresent(SpotMeasure measure1, SpotMeasure measure2) {
        if (measure1 == null || measure2 == null) {
            return;
        }
        if (this.level2D != null && measure1.level2D != null && measure2.level2D != null) {
            if (this.level2D.npoints != measure1.level2D.npoints) {
                this.level2D = new Level2D(measure1.level2D.npoints);
            }
            this.level2D.computeIsPresent_Y(measure1.level2D, measure2.level2D);
        }
    }

    public void clearLevel2D() {
        this.setLevel2D(new Level2D());
    }

    public void transferValuesToLevel2D() {
        if (this.values == null || this.values.length == 0) {
            return;
        }
        int npoints = this.values.length;
        double[] xpoints = new double[npoints];
        double[] ypoints = new double[npoints];
        for (int i = 0; i < npoints; ++i) {
            xpoints[i] = i;
            ypoints[i] = this.values[i];
        }
        this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
    }

    public void transferIsPresentToLevel2D() {
        if (this.isPresent == null || this.isPresent.length == 0) {
            return;
        }
        int npoints = this.isPresent.length;
        double[] xpoints = new double[npoints];
        double[] ypoints = new double[npoints];
        for (int i = 0; i < npoints; ++i) {
            xpoints[i] = i;
            ypoints[i] = this.isPresent[i] > 0 ? 1.0 : 0.0;
        }
        this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
    }

    public int getLevel2DNPoints() {
        return this.level2D != null ? this.level2D.npoints : 0;
    }

    public Level2D getLevel2D() {
        return this.level2D;
    }

    public void setLevel2D(Level2D level2D) {
        this.level2D = level2D;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
    }

    public ROI2DPolyLine getRoi() {
        return this.roi;
    }

    public void setRoi(ROI2DPolyLine roi) {
        this.roi = roi;
    }

    public boolean isThereAnyMeasuresDone() {
        return this.level2D != null && this.level2D.npoints > 0;
    }

    public double[] getValuesArray() {
        return this.values;
    }

    public void setValueAt(int index, double value) {
        if (this.values != null && index >= 0 && index < this.values.length) {
            this.values[index] = value;
        }
    }

    public double getValueAt(int index) {
        return this.values[index];
    }

    public void setValuesArray(double[] values) {
        this.values = values;
    }

    public int[] getIsPresentArray() {
        return this.isPresent;
    }

    public void setIsPresentArray(int[] isPresent) {
        this.isPresent = isPresent;
    }

    public void setIsPresent(int index, int value) {
        if (this.isPresent != null && index >= 0 && index < this.isPresent.length) {
            this.isPresent[index] = value;
        }
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public int getMeasuredFromNSpots() {
        return this.measuredFromNSpots;
    }

    public void setMeasuredFromNSpots(int n) {
        this.measuredFromNSpots = n;
    }

    public List<Double> getLevel2DYAsSubsampledList(long seriesBinMs, long outputBinMs) {
        if (this.level2D == null || this.level2D.npoints == 0) {
            return new ArrayList<Double>();
        }
        long maxMs = (long)(this.level2D.ypoints.length - 1) * seriesBinMs;
        long npoints = maxMs / outputBinMs + 1L;
        ArrayList<Double> result = new ArrayList<Double>();
        for (long i = 0L; i < npoints; ++i) {
            long timeMs = i * outputBinMs;
            int index = (int)(timeMs / seriesBinMs);
            if (index < this.level2D.ypoints.length) {
                result.add(this.level2D.ypoints[index]);
                continue;
            }
            result.add(0.0);
        }
        return result;
    }

    public List<Double> getLevel2DYAsList() {
        if (this.level2D == null || this.level2D.ypoints == null) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> result = new ArrayList<Double>();
        for (double value : this.level2D.ypoints) {
            result.add(value);
        }
        return result;
    }

    public void adjustLevel2DToImageWidth(int imageWidth) {
        if (this.level2D == null) {
            return;
        }
        if (this.level2DOld == null || this.level2DOld.npoints == 0) {
            this.level2DOld = this.level2D.clone();
        }
        if (this.level2D.npoints > imageWidth) {
            this.level2D.cropPolylineToNewWidth(imageWidth);
        }
    }

    public void cropLevel2DToNPoints(int npoints) {
        if (this.level2D != null) {
            this.level2D.cropPolylineToNewWidth(npoints);
        }
    }

    public int restoreCroppedLevel2D() {
        if (this.level2DOld != null && this.level2DOld.npoints > 0) {
            this.level2D = this.level2DOld.clone();
            return this.level2DOld.npoints;
        }
        return 0;
    }

    public ROI2DPolyLine getROIForImage(String name, int time, int imageHeight) {
        if (this.level2D == null || this.level2D.npoints == 0) {
            return null;
        }
        Polyline2D polyline = this.getPolyline2DFromLevel2D(this.level2D, imageHeight);
        if (polyline == null) {
            return null;
        }
        ROI2DPolyLine result = new ROI2DPolyLine(polyline);
        result.setName(name);
        this.setROI2DColorAndStrokeFromName(result);
        return result;
    }

    public Polyline2D getPolyline2DFromLevel2D(Level2D level2D, int imageHeight) {
        if (level2D == null || level2D.npoints == 0) {
            return null;
        }
        return level2D.expandPolylineToNewWidth(imageHeight);
    }

    private void setROI2DColorAndStrokeFromName(ROI2DPolyLine roi) {
        if (roi == null) {
            return;
        }
        if (this.name.contains("sum")) {
            roi.setColor(Color.RED);
            roi.setStroke(2.0);
        } else if (this.name.contains("clean")) {
            roi.setColor(Color.GREEN);
            roi.setStroke(1.0);
        } else if (this.name.contains("flyPresent")) {
            roi.setColor(Color.BLUE);
            roi.setStroke(1.0);
        } else {
            roi.setColor(Color.YELLOW);
            roi.setStroke(1.0);
        }
    }

    public void transferROItoLevel2D() {
        if (this.roi == null) {
            return;
        }
        Polyline2D polyline = this.roi.getPolyline2D();
        if (polyline != null) {
            this.level2D = new Level2D(polyline);
        }
    }

    public void buildRunningMedianFromValuesArray(int span, double[] yvalues) {
        if (yvalues == null || yvalues.length == 0) {
            return;
        }
        int npoints = yvalues.length;
        for (int i = 0; i < npoints; ++i) {
            int start = Math.max(0, i - span / 2);
            int end = Math.min(npoints - 1, i + span / 2);
            int count = end - start + 1;
            double[] window = new double[count];
            for (int j = 0; j < count; ++j) {
                window[j] = yvalues[start + j];
            }
            Arrays.sort(window);
            this.level2D.ypoints[i] = window[count / 2];
        }
    }

    public void compensateOffsetUsingSelectedRoi(ROI2D roi, boolean add) {
        if (roi == null || this.level2D == null) {
            return;
        }
    }

    public void cutAndInterpolatePointsEnclosedInSelectedRoi(ROI2D roi) {
        if (roi == null || this.level2D == null) {
            return;
        }
    }

    public boolean exportXYDataToCsv(StringBuilder sbf, String separator) {
        if (this.level2D == null || this.level2D.npoints == 0) {
            return false;
        }
        sbf.append(this.level2D.ypoints.length);
        sbf.append(separator);
        for (int i = 0; i < this.level2D.npoints; ++i) {
            if (i > 0) {
                sbf.append(separator);
            }
            sbf.append(this.level2D.xpoints[i]).append(separator).append(this.level2D.ypoints[i]);
        }
        return true;
    }

    public boolean exportYDataToCsv(StringBuilder sbf, String separator) {
        if (this.level2D == null || this.level2D.ypoints == null) {
            return false;
        }
        sbf.append(this.level2D.ypoints.length);
        sbf.append(separator);
        for (int i = 0; i < this.level2D.ypoints.length; ++i) {
            if (i > 0) {
                sbf.append(separator);
            }
            sbf.append(this.level2D.ypoints[i]);
        }
        return true;
    }

    public boolean importXYDataFromCsv(String[] data, int startAt) {
        if (data == null || data.length < startAt + 2) {
            return false;
        }
        try {
            int npoints = (data.length - startAt) / 2;
            double[] xpoints = new double[npoints];
            double[] ypoints = new double[npoints];
            for (int i = 0; i < npoints; ++i) {
                xpoints[i] = Double.parseDouble(data[startAt + i * 2]);
                ypoints[i] = Double.parseDouble(data[startAt + i * 2 + 1]);
            }
            this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean importYDataFromCsv(String[] data, int startAt) {
        if (data == null || data.length < startAt + 1) {
            return false;
        }
        try {
            int npoints = data.length - startAt;
            double[] ypoints = new double[npoints];
            for (int i = 0; i < npoints; ++i) {
                ypoints[i] = Double.parseDouble(data[startAt + i]);
            }
            double[] xpoints = new double[npoints];
            for (int i = 0; i < npoints; ++i) {
                xpoints[i] = i;
            }
            this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void addValues(double[] sourceValues) {
        if (this.values == null) {
            this.values = new double[sourceValues.length];
        }
        for (int i = 0; i < sourceValues.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] + sourceValues[i];
        }
    }

    private void addPresence(int[] sourcePresence) {
        if (this.isPresent == null) {
            this.isPresent = new int[sourcePresence.length];
        }
        for (int i = 0; i < sourcePresence.length; ++i) {
            int n = i;
            this.isPresent[n] = this.isPresent[n] + sourcePresence[i];
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpotMeasure other = (SpotMeasure)obj;
        return Objects.equals(this.name, other.name) && Double.compare(this.factor, other.factor) == 0 && Objects.equals((Object)this.level2D, (Object)other.level2D) && Arrays.equals(this.values, other.values) && Arrays.equals(this.isPresent, other.isPresent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.factor, this.level2D, Arrays.hashCode(this.values), Arrays.hashCode(this.isPresent)});
    }

    public String toString() {
        return String.format("SpotMeasure{name='%s', factor=%.2f, level2DPoints=%d, hasValues=%b, hasPresence=%b}", this.name, this.factor, this.getLevel2DNPoints(), this.values != null, this.isPresent != null);
    }
}

