/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.JComponents;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public class JComboBoxModelSorted
extends DefaultComboBoxModel<String> {
    private static final long serialVersionUID = -729889390560323340L;

    public JComboBoxModelSorted() {
    }

    public JComboBoxModelSorted(String[] items) {
        if (items != null && items.length > 0) {
            Arrays.sort(items);
            for (String item : items) {
                super.addElement(item);
            }
            this.setSelectedItem(items[0]);
        }
    }

    public JComboBoxModelSorted(List<String> items) {
        if (items != null && !items.isEmpty()) {
            Collections.sort(items);
            for (String item : items) {
                super.addElement(item);
            }
            this.setSelectedItem(items.get(0));
        }
    }

    @Override
    public void addElement(String text) {
        this.insertElementAt(text, this.findInsertionIndex(text));
    }

    @Override
    public void insertElementAt(String text, int index) {
        if (text == null) {
            return;
        }
        int correctIndex = this.findInsertionIndex(text);
        super.insertElementAt(text, correctIndex);
        this.fireContentsChanged(this, correctIndex, correctIndex);
    }

    private int findInsertionIndex(String text) {
        int size = this.getSize();
        int low = 0;
        int high = size;
        while (low < high) {
            int mid = (low + high) / 2;
            String midElement = (String)this.getElementAt(mid);
            if (midElement == null || midElement.compareTo(text) > 0) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    public boolean removeElement(String text) {
        if (text == null) {
            return false;
        }
        boolean removed = false;
        int initialSize = this.getSize();
        while (this.getIndexOf(text) != -1) {
            super.removeElement(text);
            removed = true;
        }
        return removed;
    }
}

