/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.ROI2D;

import icy.file.xml.XMLPersistent;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.util.XMLUtil;
import java.awt.Point;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DProcessingException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidator;

public class ROI2DWithMask
implements XMLPersistent {
    private static final Logger logger = Logger.getLogger(ROI2DWithMask.class.getName());
    private ROI2D inputRoi = null;
    private BooleanMask2D inputMask = null;
    private BooleanMask2D inputMaskNoFly = null;
    private Point[] maskPoints = null;
    private int yMax = 0;
    private int yMin = 0;

    public ROI2DWithMask(ROI2D roi) throws ROI2DValidationException {
        this.setInputRoi(roi);
    }

    public ROI2DWithMask() {
    }

    public ROI2D getInputRoi() {
        return this.inputRoi;
    }

    public void setInputRoi(ROI2D roi) throws ROI2DValidationException {
        if (roi != null) {
            ROI2DValidator.validateROI2D((ROI)roi, "roi");
            this.inputRoi = (ROI2D)roi.getCopy();
        } else {
            this.inputRoi = null;
        }
        this.clearMaskData();
    }

    public BooleanMask2D getInputMask() {
        return this.inputMask;
    }

    public BooleanMask2D getInputMaskNoFly() {
        return this.inputMaskNoFly;
    }

    public void setInputMaskNoFly(BooleanMask2D inputMaskNoFly) {
        this.inputMaskNoFly = inputMaskNoFly;
    }

    public Point[] getMaskPoints() {
        return this.maskPoints != null ? (Point[])this.maskPoints.clone() : null;
    }

    public int getYMax() {
        return this.yMax;
    }

    public int getYMin() {
        return this.yMin;
    }

    public void buildMask2DFromInputRoi() throws ROI2DProcessingException {
        if (this.inputRoi == null) {
            throw new ROI2DProcessingException("buildMask2D", "Input ROI is not set");
        }
        try {
            this.inputMask = this.inputRoi.getBooleanMask2D(0, 0, 1, true);
            this.maskPoints = this.inputMask.getPoints();
            this.calculateYBounds();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ROI2DProcessingException("buildMask2D", "Operation was interrupted", e);
        }
        catch (Exception e) {
            throw new ROI2DProcessingException("buildMask2D", "Failed to build mask from ROI", e);
        }
    }

    public int getMask2DHeight() throws ROI2DProcessingException {
        if (this.maskPoints == null || this.maskPoints.length == 0) {
            throw new ROI2DProcessingException("getMask2DHeight", "Mask points are not available. Call buildMask2DFromInputRoi() first");
        }
        this.calculateYBounds();
        return this.yMax - this.yMin + 1;
    }

    private void calculateYBounds() {
        if (this.maskPoints == null || this.maskPoints.length == 0) {
            this.yMax = 0;
            this.yMin = 0;
            return;
        }
        this.yMin = this.yMax = this.maskPoints[0].y;
        for (int i = 1; i < this.maskPoints.length; ++i) {
            if (this.maskPoints[i].y < this.yMin) {
                this.yMin = this.maskPoints[i].y;
            }
            if (this.maskPoints[i].y <= this.yMax) continue;
            this.yMax = this.maskPoints[i].y;
        }
    }

    private void clearMaskData() {
        this.inputMask = null;
        this.inputMaskNoFly = null;
        this.maskPoints = null;
        this.yMax = 0;
        this.yMin = 0;
    }

    public boolean hasMaskData() {
        return this.inputMask != null && this.maskPoints != null;
    }

    public String getSummary() {
        return String.format("ROI2DWithMask[ hasMask=%s, points=%d]", this.hasMaskData(), this.maskPoints != null ? this.maskPoints.length : 0);
    }

    public boolean loadFromXML(Node node) {
        try {
            Element nodeMeta = XMLUtil.getElement((Node)node, (String)"metaT");
            if (nodeMeta == null) {
                logger.warning("No metadata node found in XML");
                return false;
            }
            this.inputRoi = ROI2DUtilities.loadFromXML_ROI(nodeMeta);
            this.clearMaskData();
            return true;
        }
        catch (Exception e) {
            logger.severe("Failed to load ROI2DAlongT from XML: " + e.getMessage());
            return false;
        }
    }

    public boolean saveToXML(Node node) {
        try {
            Element nodeMeta = XMLUtil.setElement((Node)node, (String)"metaT");
            if (nodeMeta == null) {
                logger.warning("Failed to create metadata node in XML");
                return false;
            }
            if (this.inputRoi != null) {
                ROI2DUtilities.saveToXML_ROI(nodeMeta, this.inputRoi);
            }
            return true;
        }
        catch (Exception e) {
            logger.severe("Failed to save ROI2DAlongT to XML: " + e.getMessage());
            return false;
        }
    }

    public String toString() {
        return this.getSummary();
    }
}

