/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.imageTransform;

public class ImageTransformException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String transformName;
    private final String context;

    public ImageTransformException(String message) {
        this(message, null, null, null);
    }

    public ImageTransformException(String message, Throwable cause) {
        this(message, cause, null, null);
    }

    public ImageTransformException(String message, String transformName, String context) {
        this(message, null, transformName, context);
    }

    public ImageTransformException(String message, Throwable cause, String transformName, String context) {
        super(ImageTransformException.buildMessage(message, transformName, context), cause);
        this.transformName = transformName;
        this.context = context;
    }

    public String getTransformName() {
        return this.transformName;
    }

    public String getContext() {
        return this.context;
    }

    private static String buildMessage(String message, String transformName, String context) {
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message);
        }
        if (transformName != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("[Transform: ").append(transformName).append("]");
        }
        if (context != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("[Context: ").append(context).append("]");
        }
        return sb.toString();
    }
}

