/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.polyline;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Bresenham {
    private static final Logger LOGGER = Logger.getLogger(Bresenham.class.getName());
    private static final int X_INDEX = 0;
    private static final int Y_INDEX = 1;
    private static final int DOUBLE_SHIFT = 1;
    private static final int MIN_POLYLINE_SIZE = 2;
    private static final int MAX_COORDINATE = 0x1FFFFFFF;
    private static final int MIN_COORDINATE = -536870912;

    private Bresenham() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static ArrayList<int[]> getPixelsBetween2Points(int x1, int y1, int x2, int y2) {
        Bresenham.validateCoordinates(x1, y1, x2, y2);
        try {
            ArrayList<int[]> linePixels = new ArrayList<int[]>();
            int deltaX = Math.abs(x2 - x1);
            int deltaY = Math.abs(y2 - y1);
            int incrementX = x2 >= x1 ? 1 : -1;
            int incrementY = y2 >= y1 ? 1 : -1;
            int currentX = x1;
            int currentY = y1;
            if (deltaX >= deltaY) {
                Bresenham.generateLineXPrimary(linePixels, currentX, currentY, x2, deltaX, deltaY, incrementX, incrementY);
            } else {
                Bresenham.generateLineYPrimary(linePixels, currentX, currentY, y2, deltaX, deltaY, incrementX, incrementY);
            }
            return linePixels;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error generating line pixels", e);
            return new ArrayList<int[]>();
        }
    }

    public static ArrayList<int[]> getPixelsAlongLineFromROI2D(ArrayList<Point2D> pointsList) {
        if (pointsList == null) {
            throw new IllegalArgumentException("Points list cannot be null");
        }
        if (pointsList.size() < 2) {
            throw new IllegalArgumentException("Points list must contain at least 2 points, got: " + pointsList.size());
        }
        try {
            ArrayList<int[]> allLinePixels = new ArrayList<int[]>();
            for (int i = 1; i < pointsList.size(); ++i) {
                Point2D currentPoint = pointsList.get(i - 1);
                Point2D nextPoint = pointsList.get(i);
                if (currentPoint == null || nextPoint == null) {
                    LOGGER.warning("Skipping null point at index " + (currentPoint == null ? i - 1 : i));
                    continue;
                }
                ArrayList<int[]> segmentPixels = Bresenham.getPixelsBetween2Points((int)currentPoint.getX(), (int)currentPoint.getY(), (int)nextPoint.getX(), (int)nextPoint.getY());
                allLinePixels.addAll(segmentPixels);
            }
            return allLinePixels;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error generating polyline pixels", e);
            return new ArrayList<int[]>();
        }
    }

    public static ArrayList<int[]> getPixelsAlongPolyline(List<Point2D> pointsList) {
        if (pointsList == null) {
            throw new IllegalArgumentException("Points list cannot be null");
        }
        ArrayList<Object> arrayList = pointsList instanceof ArrayList ? (ArrayList<Object>)pointsList : new ArrayList<Point2D>(pointsList);
        return Bresenham.getPixelsAlongLineFromROI2D((ArrayList<Point2D>)arrayList);
    }

    public static int getLinePixelCount(int x1, int y1, int x2, int y2) {
        Bresenham.validateCoordinates(x1, y1, x2, y2);
        int deltaX = Math.abs(x2 - x1);
        int deltaY = Math.abs(y2 - y1);
        return Math.max(deltaX, deltaY) + 1;
    }

    private static void validateCoordinates(int x1, int y1, int x2, int y2) {
        if (x1 < -536870912 || x1 > 0x1FFFFFFF) {
            throw new IllegalArgumentException("x1 coordinate out of range: " + x1);
        }
        if (y1 < -536870912 || y1 > 0x1FFFFFFF) {
            throw new IllegalArgumentException("y1 coordinate out of range: " + y1);
        }
        if (x2 < -536870912 || x2 > 0x1FFFFFFF) {
            throw new IllegalArgumentException("x2 coordinate out of range: " + x2);
        }
        if (y2 < -536870912 || y2 > 0x1FFFFFFF) {
            throw new IllegalArgumentException("y2 coordinate out of range: " + y2);
        }
    }

    private static void generateLineXPrimary(ArrayList<int[]> linePixels, int currentX, int currentY, int targetX, int deltaX, int deltaY, int incrementX, int incrementY) {
        int doubleDeltaY = deltaY << 1;
        int balance = doubleDeltaY - deltaX;
        int doubleDeltaX = deltaX << 1;
        while (currentX != targetX) {
            linePixels.add(new int[]{currentX, currentY});
            if (balance >= 0) {
                currentY += incrementY;
                balance -= doubleDeltaX;
            }
            balance += doubleDeltaY;
            currentX += incrementX;
        }
        linePixels.add(new int[]{currentX, currentY});
    }

    private static void generateLineYPrimary(ArrayList<int[]> linePixels, int currentX, int currentY, int targetY, int deltaX, int deltaY, int incrementX, int incrementY) {
        int doubleDeltaX = deltaX << 1;
        int balance = doubleDeltaX - deltaY;
        int doubleDeltaY = deltaY << 1;
        while (currentY != targetY) {
            linePixels.add(new int[]{currentX, currentY});
            if (balance >= 0) {
                currentX += incrementX;
                balance -= doubleDeltaY;
            }
            balance += doubleDeltaX;
            currentY += incrementY;
        }
        linePixels.add(new int[]{currentX, currentY});
    }
}

