/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.polyline;

import icy.type.geom.Polyline2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Level2D
extends Polyline2D {
    private static final Logger LOGGER = Logger.getLogger(Level2D.class.getName());
    private static final int GROWTH_FACTOR = 2;
    private static final double MIN_THRESHOLD = 0.0;
    private static final double MAX_THRESHOLD = 1.0;
    private static final double EPSILON = 1.0E-10;

    public Level2D() {
    }

    public Level2D(int numPoints) {
        if (numPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative: " + numPoints);
        }
        this.npoints = numPoints;
        this.xpoints = new double[numPoints];
        this.ypoints = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            this.xpoints[i] = i;
        }
    }

    public Level2D(Polyline2D polyline) {
        if (polyline == null) {
            throw new IllegalArgumentException("Source polyline cannot be null");
        }
        this.npoints = polyline.npoints;
        this.xpoints = new double[this.npoints];
        this.ypoints = new double[this.npoints];
        System.arraycopy(polyline.xpoints, 0, this.xpoints, 0, this.npoints);
        System.arraycopy(polyline.ypoints, 0, this.ypoints, 0, this.npoints);
    }

    public Level2D(double[] xPoints, double[] yPoints, int numPoints) {
        if (xPoints == null || yPoints == null) {
            throw new IllegalArgumentException("Coordinate arrays cannot be null");
        }
        if (numPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative: " + numPoints);
        }
        if (xPoints.length < numPoints || yPoints.length < numPoints) {
            throw new IllegalArgumentException("Arrays are too small for the specified number of points");
        }
        this.npoints = numPoints;
        this.xpoints = new double[numPoints];
        this.ypoints = new double[numPoints];
        System.arraycopy(xPoints, 0, this.xpoints, 0, numPoints);
        System.arraycopy(yPoints, 0, this.ypoints, 0, numPoints);
    }

    public Level2D(int[] xPoints, int[] yPoints, int numPoints) {
        if (xPoints == null || yPoints == null) {
            throw new IllegalArgumentException("Coordinate arrays cannot be null");
        }
        if (numPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative: " + numPoints);
        }
        if (xPoints.length < numPoints || yPoints.length < numPoints) {
            throw new IllegalArgumentException("Arrays are too small for the specified number of points");
        }
        this.npoints = numPoints;
        this.xpoints = new double[numPoints];
        this.ypoints = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            this.xpoints[i] = xPoints[i];
            this.ypoints[i] = yPoints[i];
        }
    }

    public Level2D(List<Point2D> pointsList) {
        if (pointsList == null) {
            throw new IllegalArgumentException("Points list cannot be null");
        }
        this.npoints = pointsList.size();
        this.xpoints = new double[this.npoints];
        this.ypoints = new double[this.npoints];
        for (int i = 0; i < this.npoints; ++i) {
            Point2D point = pointsList.get(i);
            if (point == null) {
                throw new IllegalArgumentException("Point at index " + i + " is null");
            }
            this.xpoints[i] = point.getX();
            this.ypoints[i] = point.getY();
        }
    }

    public boolean insertSeriesofYPoints(List<Point2D> points, int start, int end) {
        if (points == null) {
            throw new IllegalArgumentException("Points list cannot be null");
        }
        if (start < 0 || end > this.npoints || start >= end) {
            throw new IllegalArgumentException("Invalid range: start=" + start + ", end=" + end + ", npoints=" + this.npoints);
        }
        int requiredSize = end - start;
        if (points.size() < requiredSize) {
            LOGGER.warning("Points list is too small for the specified range");
            return false;
        }
        try {
            int i = start;
            int j = 0;
            while (i < end) {
                Point2D point = points.get(j);
                if (point != null) {
                    this.ypoints[i] = point.getY();
                }
                ++i;
                ++j;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error inserting Y points", e);
            return false;
        }
    }

    public boolean insertYPoints(int[] points, int start, int end) {
        if (points == null) {
            throw new IllegalArgumentException("Points array cannot be null");
        }
        if (start < 0 || end >= this.npoints || start > end) {
            throw new IllegalArgumentException("Invalid range: start=" + start + ", end=" + end + ", npoints=" + this.npoints);
        }
        int requiredSize = end - start + 1;
        if (points.length < requiredSize) {
            LOGGER.warning("Points array is too small for the specified range");
            return false;
        }
        try {
            int i = start;
            int j = 0;
            while (i <= end) {
                this.ypoints[i] = points[j];
                ++i;
                ++j;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error inserting Y points", e);
            return false;
        }
    }

    public Level2D clone() {
        Level2D cloned = new Level2D(this.npoints);
        System.arraycopy(this.xpoints, 0, cloned.xpoints, 0, this.npoints);
        System.arraycopy(this.ypoints, 0, cloned.ypoints, 0, this.npoints);
        return cloned;
    }

    public Level2D expandPolylineToNewWidth(int imageWidth) {
        if (imageWidth <= 0) {
            throw new IllegalArgumentException("Image width must be positive: " + imageWidth);
        }
        if (this.npoints <= 0) {
            return new Level2D(imageWidth);
        }
        try {
            double[] newXPoints = new double[imageWidth];
            double[] newYPoints = new double[imageWidth];
            for (int j = 0; j < this.npoints; ++j) {
                int startIndex = j * imageWidth / this.npoints;
                int endIndex = (j + 1) * imageWidth / this.npoints;
                double currentY = this.ypoints[j];
                double nextY = j + 1 < this.npoints ? this.ypoints[j + 1] : currentY;
                for (int i = startIndex; i < endIndex && i < imageWidth; ++i) {
                    newXPoints[i] = i;
                    if (endIndex > startIndex) {
                        double ratio = (double)(i - startIndex) / (double)(endIndex - startIndex);
                        newYPoints[i] = currentY + (nextY - currentY) * ratio;
                        continue;
                    }
                    newYPoints[i] = currentY;
                }
            }
            return new Level2D(newXPoints, newYPoints, imageWidth);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error expanding polyline", e);
            return new Level2D(imageWidth);
        }
    }

    public Level2D contractPolylineToNewWidth(int imageWidth) {
        if (imageWidth <= 0) {
            throw new IllegalArgumentException("Image width must be positive: " + imageWidth);
        }
        if (this.npoints <= 0) {
            return new Level2D(imageWidth);
        }
        try {
            double[] newXPoints = new double[imageWidth];
            double[] newYPoints = new double[imageWidth];
            for (int i = 0; i < imageWidth; ++i) {
                int sourceIndex = i * this.npoints / imageWidth;
                sourceIndex = Math.min(sourceIndex, this.npoints - 1);
                newXPoints[i] = i;
                newYPoints[i] = this.ypoints[sourceIndex];
            }
            return new Level2D(newXPoints, newYPoints, imageWidth);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error contracting polyline", e);
            return new Level2D(imageWidth);
        }
    }

    public Level2D cropPolylineToNewWidth(int imageWidth) {
        if (imageWidth <= 0) {
            throw new IllegalArgumentException("Image width must be positive: " + imageWidth);
        }
        try {
            double[] newXPoints = new double[imageWidth];
            double[] newYPoints = new double[imageWidth];
            double lastValue = this.npoints > 0 ? this.ypoints[this.npoints - 1] : 0.0;
            for (int i = 0; i < imageWidth; ++i) {
                newXPoints[i] = i;
                newYPoints[i] = i < this.npoints ? this.ypoints[i] : lastValue;
            }
            return new Level2D(newXPoints, newYPoints, imageWidth);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error cropping polyline", e);
            return new Level2D(imageWidth);
        }
    }

    @Deprecated
    public void cropToNPoints(int npoints) {
        Level2D cropped = this.cropPolylineToNewWidth(npoints);
        this.npoints = cropped.npoints;
        this.xpoints = cropped.xpoints;
        this.ypoints = cropped.ypoints;
    }

    public void multiply_Y(double multiplier) {
        if (Double.isNaN(multiplier) || Double.isInfinite(multiplier)) {
            throw new IllegalArgumentException("Multiplier must be a finite number: " + multiplier);
        }
        int i = 0;
        while (i < this.npoints) {
            int n = i++;
            this.ypoints[n] = this.ypoints[n] * multiplier;
        }
    }

    public void add_Y(Level2D source) {
        if (source == null) {
            throw new IllegalArgumentException("Source Level2D cannot be null");
        }
        int sourcePoints = source.npoints;
        if (sourcePoints > this.npoints) {
            this.ensureCapacity(sourcePoints);
        }
        for (int i = 0; i < sourcePoints; ++i) {
            int n = i;
            this.ypoints[n] = this.ypoints[n] + source.ypoints[i];
        }
    }

    public double getMaximum_Y() {
        double maximum = this.ypoints[0];
        for (int i = 0; i < this.npoints; ++i) {
            if (!(this.ypoints[i] > maximum)) continue;
            maximum = this.ypoints[i];
        }
        return maximum;
    }

    public void threshold_Y(double threshold) {
        for (int i = 0; i < this.npoints; ++i) {
            this.ypoints[i] = this.ypoints[i] > threshold ? 1.0 : 0.0;
        }
    }

    public void computePI_Y(Level2D data1, Level2D data2) {
        if (data1 == null || data2 == null) {
            throw new IllegalArgumentException("Data sources cannot be null");
        }
        int maxPoints = Math.max(data1.npoints, data2.npoints);
        this.ensureCapacity(maxPoints);
        for (int i = 0; i < maxPoints; ++i) {
            double value1 = i < data1.npoints ? data1.ypoints[i] : 0.0;
            double value2 = i < data2.npoints ? data2.ypoints[i] : 0.0;
            double sum = value1 + value2;
            this.ypoints[i] = Math.abs(sum) > 1.0E-10 ? (value1 - value2) / sum : 0.0;
        }
    }

    public void computeSUM_Y(Level2D data1, Level2D data2) {
        if (data1 == null || data2 == null) {
            throw new IllegalArgumentException("Data sources cannot be null");
        }
        int maxPoints = Math.max(data1.npoints, data2.npoints);
        this.ensureCapacity(maxPoints);
        for (int i = 0; i < maxPoints; ++i) {
            double value1 = i < data1.npoints ? data1.ypoints[i] : 0.0;
            double value2 = i < data2.npoints ? data2.ypoints[i] : 0.0;
            this.ypoints[i] = value1 + value2;
        }
    }

    public void computeIsPresent_Y(Level2D data1, Level2D data2) {
        if (data1 == null || data2 == null) {
            throw new IllegalArgumentException("Data sources cannot be null");
        }
        int maxPoints = Math.max(data1.npoints, data2.npoints);
        this.ensureCapacity(maxPoints);
        for (int i = 0; i < maxPoints; ++i) {
            double value1 = i < data1.npoints ? data1.ypoints[i] : 0.0;
            double value2 = i < data2.npoints ? data2.ypoints[i] : 0.0;
            this.ypoints[i] = value1 + value2 > 1.0E-10 ? 1.0 : 0.0;
        }
    }

    public int getPointCount() {
        return this.npoints;
    }

    public double getYAt(int index) {
        if (index < 0 || index >= this.npoints) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds [0, " + this.npoints + ")");
        }
        return this.ypoints[index];
    }

    public void setYAt(int index, double value) {
        if (index < 0 || index >= this.npoints) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds [0, " + this.npoints + ")");
        }
        this.ypoints[index] = value;
    }

    private void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity > this.npoints) {
            int newCapacity = Math.max(requiredCapacity, this.npoints * 2);
            double[] newXPoints = new double[newCapacity];
            double[] newYPoints = new double[newCapacity];
            if (this.npoints > 0) {
                System.arraycopy(this.xpoints, 0, newXPoints, 0, this.npoints);
                System.arraycopy(this.ypoints, 0, newYPoints, 0, this.npoints);
            }
            for (int i = this.npoints; i < newCapacity; ++i) {
                newXPoints[i] = i;
            }
            this.xpoints = newXPoints;
            this.ypoints = newYPoints;
            this.npoints = requiredCapacity;
        }
    }
}

