/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.b_spots;

import icy.painter.Overlay;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS96.series.DetectSpotsOutline;
import plugins.fmp.multiSPOTS96.tools.Comparators;
import plugins.fmp.multiSPOTS96.tools.canvas2D.Canvas2D_3Transforms;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.overlay.OverlayThreshold;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class DetectSpots
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    private static final long serialVersionUID = -5257698990389571518L;
    private MultiSPOTS96 parent0 = null;
    private String detectString = "Detect blobs...";
    private JButton startComputationButton = new JButton(this.detectString);
    private JComboBox<String> allCellsComboBox = new JComboBox<String>(new String[]{"all cages", "selected cages"});
    private JCheckBox allCheckBox = new JCheckBox("ALL (current to last)", false);
    private JLabel spotsFilterLabel = new JLabel("Filter");
    ImageTransformEnums[] transforms = new ImageTransformEnums[]{ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.RGB_DIFFS, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB};
    private JComboBox<ImageTransformEnums> spotsTransformsComboBox = new JComboBox<ImageTransformEnums>(this.transforms);
    private String[] directions = new String[]{"threshold >", "threshold <"};
    private JComboBox<String> spotsDirectionComboBox = new JComboBox<String>(this.directions);
    private JSpinner spotsThresholdSpinner = new JSpinner(new SpinnerNumberModel(35, 0, 255, 1));
    private JToggleButton spotsViewButton = new JToggleButton("View");
    private JCheckBox spotsOverlayCheckBox = new JCheckBox("overlay");
    private JButton convertSpotToEllipseButton = new JButton("Convert blobs to spots");
    private JSpinner spotDiameterSpinner = new JSpinner(new SpinnerNumberModel(22, 1, 1200, 1));
    private JButton deleteSelectedSpotsButton = new JButton("Remove selected spots");
    private JButton duplicateSelectedSpotButton = new JButton("Duplicate selected spot");
    private JButton cleanUpNamesButton = new JButton("Clean up spot names");
    private DetectSpotsOutline detectSpots = null;
    private OverlayThreshold overlayThreshold = null;

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        layoutLeft.setVgap(0);
        JPanel panel0 = new JPanel(layoutLeft);
        panel0.add(this.startComputationButton);
        panel0.add(this.allCellsComboBox);
        panel0.add(this.allCheckBox);
        this.add(panel0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.spotsFilterLabel);
        panel1.add(this.spotsTransformsComboBox);
        panel1.add(this.spotsDirectionComboBox);
        panel1.add(this.spotsThresholdSpinner);
        panel1.add(this.spotsViewButton);
        panel1.add(this.spotsOverlayCheckBox);
        this.add(panel1);
        this.add(panel1);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(this.convertSpotToEllipseButton);
        panel2.add(new JLabel("size (pixels="));
        panel2.add(this.spotDiameterSpinner);
        this.add(panel2);
        JPanel panel3 = new JPanel(layoutLeft);
        panel3.add(this.deleteSelectedSpotsButton);
        panel3.add(this.duplicateSelectedSpotButton);
        panel3.add(this.cleanUpNamesButton);
        this.add(panel3);
        this.spotsTransformsComboBox.setSelectedItem((Object)ImageTransformEnums.RGB_DIFFS);
        this.spotsDirectionComboBox.setSelectedIndex(1);
        this.defineActionListeners();
        this.defineItemListeners();
    }

    private void defineItemListeners() {
        this.spotsThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DetectSpots.this.updateOverlayThreshold();
            }
        });
    }

    private void defineActionListeners() {
        this.startComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DetectSpots.this.startComputationButton.getText().equals(DetectSpots.this.detectString)) {
                    DetectSpots.this.startComputation();
                } else {
                    DetectSpots.this.stopComputation();
                }
            }
        });
        this.allCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (DetectSpots.this.allCheckBox.isSelected()) {
                    color = Color.RED;
                }
                DetectSpots.this.allCheckBox.setForeground(color);
                DetectSpots.this.startComputationButton.setForeground(color);
            }
        });
        this.spotsViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((DetectSpots)DetectSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    DetectSpots.this.displayTransform(exp);
                }
            }
        });
        this.spotsOverlayCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Experiment exp = (Experiment)((DetectSpots)DetectSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (DetectSpots.this.spotsOverlayCheckBox.isSelected()) {
                        DetectSpots.this.updateOverlay(exp);
                        DetectSpots.this.updateOverlayThreshold();
                    } else {
                        DetectSpots.this.removeOverlay(exp);
                        DetectSpots.this.overlayThreshold = null;
                    }
                }
            }
        });
        this.spotsDirectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetectSpots.this.updateOverlayThreshold();
            }
        });
        this.spotsThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DetectSpots.this.updateOverlayThreshold();
            }
        });
        this.deleteSelectedSpotsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((DetectSpots)DetectSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    DetectSpots.this.deleteSelectedSpot(exp);
                }
            }
        });
        this.duplicateSelectedSpotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((DetectSpots)DetectSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    DetectSpots.this.duplicateSelectedSpot(exp);
                }
            }
        });
        this.convertSpotToEllipseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((DetectSpots)DetectSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    int diameter = (Integer)DetectSpots.this.spotDiameterSpinner.getValue();
                    DetectSpots.this.convertBlobsToCircularSpots(exp, diameter);
                }
            }
        });
        this.spotDiameterSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Experiment exp = (Experiment)((DetectSpots)DetectSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    DetectSpots.this.changeSpotsDiameter(exp);
                }
            }
        });
        this.cleanUpNamesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((DetectSpots)DetectSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    DetectSpots.this.cleanUpSpotNames(exp);
                }
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Experiment exp;
        if (e.getSource() == this.spotsThresholdSpinner && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null) {
            exp.cagesArray.detect_threshold = (Integer)this.spotsThresholdSpinner.getValue();
        }
    }

    public void updateOverlay(Experiment exp) {
        if (this.overlayThreshold == null) {
            this.overlayThreshold = new OverlayThreshold(exp.seqCamData.getSequence());
        } else {
            exp.seqCamData.getSequence().removeOverlay((Overlay)this.overlayThreshold);
            this.overlayThreshold.setSequence(exp.seqCamData.getSequence());
        }
        exp.seqCamData.getSequence().addOverlay((Overlay)this.overlayThreshold);
    }

    private void displayTransform(Experiment exp) {
        boolean displayCheckOverlay = false;
        if (this.spotsViewButton.isSelected()) {
            this.updateTransformFunctionsOfCanvas(exp);
            displayCheckOverlay = true;
        } else {
            this.removeOverlay(exp);
            this.spotsOverlayCheckBox.setSelected(false);
            Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
            canvas.setTransformStep1Index(0);
        }
        this.spotsOverlayCheckBox.setEnabled(displayCheckOverlay);
    }

    private void updateTransformFunctionsOfCanvas(Experiment exp) {
        Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
        if (canvas.getTransformStep1ItemCount() < this.spotsTransformsComboBox.getItemCount() + 1) {
            canvas.updateTransformsComboStep1(this.transforms);
        }
        int index = this.spotsTransformsComboBox.getSelectedIndex();
        canvas.selectImageTransformFunctionStep1(index + 1, null);
    }

    void updateOverlayThreshold() {
        Experiment exp;
        if (!this.spotsOverlayCheckBox.isSelected()) {
            return;
        }
        if (this.overlayThreshold == null && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null) {
            this.updateOverlay(exp);
        }
        boolean ifGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        int threshold = (Integer)this.spotsThresholdSpinner.getValue();
        ImageTransformEnums transform = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        this.overlayThreshold.setThresholdSingle(threshold, transform, ifGreater);
        this.overlayThreshold.painterChanged();
    }

    private BuildSeriesOptions initTrackParameters(Experiment exp) {
        BuildSeriesOptions options = this.detectSpots.options;
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allCheckBox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.btrackWhite = this.spotsDirectionComboBox.getSelectedIndex() == 1;
        options.threshold = (Integer)this.spotsThresholdSpinner.getValue();
        options.detectFlies = false;
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.binSubDirectory = exp.getBinSubDirectory();
        options.fromFrame = exp.seqCamData.getCurrentFrame();
        options.transformop = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        int iselected = this.allCellsComboBox.getSelectedIndex() - 1;
        options.selectedIndexes = new ArrayList(exp.cagesArray.cagesList.size());
        options.selectedIndexes.addAll(this.getSelectedCages(exp, iselected));
        options.detectCage = iselected;
        return options;
    }

    ArrayList<Integer> getSelectedCages(Experiment exp, int iSelectedOption) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(exp.cagesArray.cagesList.size());
        for (Cage cage : exp.cagesArray.cagesList) {
            boolean bselected = true;
            if (iSelectedOption == 0) {
                bselected = cage.getRoi().isSelected();
            }
            if (!bselected) continue;
            indexes.add(cage.getProperties().getCageID());
        }
        return indexes;
    }

    void startComputation() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        this.parent0.dlgBrowse.loadSaveExperiment.closeViewsForCurrentExperiment(exp);
        this.detectSpots = new DetectSpotsOutline();
        this.detectSpots.options = this.initTrackParameters(exp);
        this.detectSpots.stopFlag = false;
        this.detectSpots.addPropertyChangeListener(this);
        this.detectSpots.execute();
        this.startComputationButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.detectSpots != null && !this.detectSpots.stopFlag) {
            this.detectSpots.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.startComputationButton.setText(this.detectString);
            this.parent0.dlgKymos.tabDisplay.selectKymographImage(this.parent0.dlgKymos.tabDisplay.indexImagesCombo);
            this.parent0.dlgKymos.tabDisplay.indexImagesCombo = -1;
            this.selectCagesAccordingToOptions(this.detectSpots.options.selectedIndexes);
        }
    }

    void selectCagesAccordingToOptions(ArrayList<Integer> selectedCagesList) {
        if (this.allCellsComboBox.getSelectedIndex() == 0 || selectedCagesList == null || selectedCagesList.size() < 1) {
            return;
        }
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        for (Cage cage : exp.cagesArray.cagesList) {
            if (!selectedCagesList.contains(cage.getProperties().getCageID())) continue;
            cage.getRoi().setSelected(true);
        }
    }

    void removeOverlay(Experiment exp) {
        if (exp.seqCamData != null && exp.seqCamData.getSequence() != null) {
            exp.seqCamData.getSequence().removeOverlay((Overlay)this.overlayThreshold);
        }
    }

    void deleteSelectedSpot(Experiment exp) {
        if (exp.seqCamData.getSequence() != null) {
            ArrayList listROIs = exp.seqCamData.getSequence().getSelectedROI2Ds();
            block0: for (ROI2D roi : listROIs) {
                String name = roi.getName();
                if (!name.contains("spot")) continue;
                Cage cage = exp.cagesArray.getCageFromSpotName(name);
                Iterator<Spot> iterator = cage.spotsArray.getSpotsList().iterator();
                while (iterator.hasNext()) {
                    Spot spot = iterator.next();
                    if (!name.equals(spot.getRoi().getName())) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            this.cleanUpSpotNames(exp);
        }
        exp.saveSpotsArray_file();
    }

    void duplicateSelectedSpot(Experiment exp) {
        if (exp.seqCamData.getSequence() != null) {
            ArrayList listROIs = exp.seqCamData.getSequence().getSelectedROI2Ds();
            for (ROI2D roi : listROIs) {
                String name = roi.getName();
                if (!name.contains("spot")) continue;
                Cage cage = exp.cagesArray.getCageFromSpotName(name);
                ArrayList<Spot> spotsToDuplicate = new ArrayList<Spot>();
                for (Spot spot : cage.spotsArray.getSpotsList()) {
                    if (!name.equals(spot.getRoi().getName())) continue;
                    spotsToDuplicate.add(spot);
                    break;
                }
                if (spotsToDuplicate.size() <= 0) continue;
                for (Spot spot : spotsToDuplicate) {
                    Point2D.Double pos = (Point2D.Double)spot.getRoi().getPosition2D();
                    Rectangle rect = spot.getRoi().getBounds();
                    int radius = rect.width / 2;
                    pos.setLocation(pos.getX() + 5.0, pos.getY() + 5.0);
                    cage.addEllipseSpot(pos, radius);
                    Spot newSpot = cage.spotsArray.getSpotsList().get(cage.spotsArray.getSpotsList().size() - 1);
                    exp.seqCamData.getSequence().addROI((ROI)newSpot.getRoi());
                }
            }
            this.cleanUpSpotNames(exp);
        }
        exp.saveSpotsArray_file();
    }

    void convertBlobsToCircularSpots(Experiment exp, int diameter) {
        boolean bOnlySelectedCages = this.allCellsComboBox.getSelectedIndex() == 1;
        for (Cage cage : exp.cagesArray.cagesList) {
            if (bOnlySelectedCages && !cage.getRoi().isSelected()) continue;
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                ROI2D roiP = spot.getRoi();
                Point center = roiP.getPosition();
                Rectangle rect = roiP.getBounds();
                center.x = (int)((double)center.x + rect.getWidth() / 2.0);
                center.y = (int)((double)center.y + rect.getHeight() / 2.0);
                String name = spot.getRoi().getName();
                Ellipse2D.Double ellipse = new Ellipse2D.Double(center.x - diameter / 2, center.y - diameter / 2, diameter, diameter);
                ROI2DEllipse roiEllipse = new ROI2DEllipse((Ellipse2D)ellipse);
                roiEllipse.setName(name);
                spot.setRoi((ROI2DShape)roiEllipse);
            }
        }
        exp.seqCamData.removeROIsContainingString("spot");
        exp.cagesArray.transferCageSpotsToSequenceAsROIs(exp.seqCamData);
        exp.saveSpotsArray_file();
    }

    void changeSpotsDiameter(Experiment exp) {
        int diameter = (Integer)this.spotDiameterSpinner.getValue();
        this.convertBlobsToCircularSpots(exp, diameter);
    }

    private void cleanUpSpotNames(Experiment exp) {
        for (Cage cage : exp.cagesArray.cagesList) {
            cage.mapSpotsToCageColumnRow();
            Collections.sort(cage.spotsArray.getSpotsList(), new Comparators.Spot_cagePosition());
            cage.cleanUpSpotNames();
        }
        exp.seqCamData.removeROIsContainingString("spot");
        exp.cagesArray.transferCageSpotsToSequenceAsROIs(exp.seqCamData);
        exp.saveSpotsArray_file();
    }
}

